/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.commandline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.commandline.ArgumentSignature;
import org.bbop.commandline.CommandLineParser;
import org.bbop.commandline.FailException;
import org.bbop.commandline.UnfullfilledException;

public class UnorderedArgumentSignature
implements ArgumentSignature {
    protected static final Logger logger = Logger.getLogger(UnorderedArgumentSignature.class);
    protected List signatures = new ArrayList();
    protected List usedSigs = new ArrayList();
    protected String shortDesc;
    protected int id = CommandLineParser.getID();

    @Override
    public int getID() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof ArgumentSignature) {
            return ((ArgumentSignature)o).getID() == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean onlyAcceptAsLastResort() {
        return false;
    }

    public String toString() {
        if (this.shortDesc != null) {
            return this.shortDesc;
        }
        return super.toString();
    }

    @Override
    public void init(CommandLineParser p, boolean defaultMode) {
        for (CardinalityConstraint sig : this.signatures) {
            sig.init(p, false);
        }
        this.usedSigs.clear();
    }

    @Override
    public void setOnlyAcceptAsLastResort(boolean lastResort) {
    }

    public void addSignature(ArgumentSignature sig) {
        this.addSignature(sig, 0, 1, false);
    }

    public void addSignature(ArgumentSignature sig, int minCardinality, int maxCardinality) {
        this.addSignature(sig, minCardinality, maxCardinality, false);
    }

    public void addSignature(ArgumentSignature sig, int minCardinality, int maxCardinality, boolean canDefault) {
        this.signatures.add(new CardinalityConstraint(sig, minCardinality, maxCardinality, canDefault));
    }

    public UnorderedArgumentSignature() {
        this(null);
    }

    public UnorderedArgumentSignature(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    protected String formatStringList(String str, int startindex, int endindex, boolean mandatory, boolean nospacedemo) {
        if (startindex == endindex) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        if (!mandatory) {
            out.append("[");
        }
        if (endindex - startindex == 1) {
            out.append(str);
        } else if (endindex - startindex < 3) {
            boolean first = true;
            while (startindex < endindex) {
                if (!first) {
                    out.append(" ");
                }
                out.append(str + "<" + (startindex + 1) + ">");
                first = false;
                ++startindex;
            }
        } else {
            out.append(str + (startindex + 1));
            if (!nospacedemo) {
                out.append(" " + str + "<" + (startindex + 2) + ">");
            }
            String lastNum = "N";
            if (endindex < Integer.MAX_VALUE) {
                lastNum = "" + (endindex + 1);
            }
            out.append(" ... " + str + "<" + lastNum + ">");
        }
        if (!mandatory) {
            out.append("]");
        }
        return out.toString();
    }

    @Override
    public String getShortDocumentation() {
        if (this.shortDesc == null) {
            StringBuffer out = new StringBuffer();
            Iterator it = this.signatures.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    out.append(" ");
                }
                first = false;
                CardinalityConstraint cc = (CardinalityConstraint)it.next();
                String s = cc.sig.getShortDocumentation();
                String firstSection = this.formatStringList(s, 0, cc.minCardinality, true, false);
                String secondSection = this.formatStringList(s, cc.minCardinality, cc.maxCardinality, false, cc.minCardinality > 1);
                if (firstSection.length() > 0 && secondSection.length() > 0) {
                    out.append(firstSection + " " + secondSection);
                    continue;
                }
                out.append(firstSection + secondSection);
            }
            return out.toString();
        }
        return "<" + this.shortDesc + ">";
    }

    @Override
    public ArgumentSignature copy() {
        UnorderedArgumentSignature out = new UnorderedArgumentSignature();
        for (CardinalityConstraint sig : this.signatures) {
            out.signatures.add(sig.copy());
        }
        out.shortDesc = this.shortDesc;
        out.usedSigs.addAll(this.usedSigs);
        out.id = this.id;
        return out;
    }

    @Override
    public void accept(CommandLineParser p) throws FailException {
        boolean gotSuccess;
        do {
            boolean stillWork = false;
            gotSuccess = false;
            for (int attempts = 0; attempts < 2; ++attempts) {
                int i = 0;
                while (i < this.signatures.size()) {
                    CardinalityConstraint c = (CardinalityConstraint)this.signatures.get(i);
                    if (c.isFull()) {
                        ++i;
                        continue;
                    }
                    stillWork = true;
                    if (attempts > 0 && !c.getCanDefault()) {
                        ++i;
                        continue;
                    }
                    ArgumentSignature sig = c.sig;
                    sig.init(p, attempts > 0);
                    try {
                        try {
                            p.doAccept(sig, attempts > 0);
                            ArgumentSignature copySig = sig.copy();
                            this.usedSigs.add(copySig);
                            ++c.index;
                        }
                        catch (CommandLineParser.FallbackException ex) {
                            if (sig != ex.getInitiatorFrame()) {
                                ArgumentSignature copySig = sig.copy();
                                this.usedSigs.add(copySig);
                                ++c.index;
                            }
                            throw ex;
                        }
                        gotSuccess = true;
                    }
                    catch (FailException ex) {
                        ++i;
                    }
                }
                if (gotSuccess) break;
            }
            if (stillWork) continue;
            return;
        } while (gotSuccess);
        for (int i = 0; i < this.signatures.size(); ++i) {
            CardinalityConstraint c = (CardinalityConstraint)this.signatures.get(i);
            if (c.isSatisfied()) continue;
            throw new FailException("Not enough values found for " + c);
        }
        if (p.hasMoreStrings()) {
            for (CardinalityConstraint cc : this.signatures) {
                cc.isFull();
            }
            throw new FailException("Unexpected values found: " + p.stringList);
        }
    }

    @Override
    public List getValues() throws UnfullfilledException {
        ArrayList out = new ArrayList();
        for (int i = 0; i < this.signatures.size(); ++i) {
            CardinalityConstraint c = (CardinalityConstraint)this.signatures.get(i);
        }
        for (ArgumentSignature as : this.usedSigs) {
            out.addAll(as.getValues());
        }
        return out;
    }

    protected class CardinalityConstraint {
        int minCardinality;
        int maxCardinality;
        ArgumentSignature sig;
        int index;
        boolean canDefault;

        public boolean isSatisfied() {
            return this.index >= this.minCardinality && this.index <= this.maxCardinality;
        }

        public boolean isFull() {
            return this.index >= this.maxCardinality;
        }

        public void init(CommandLineParser p, boolean defaultMode) {
            this.index = 0;
            this.sig.init(p, defaultMode);
        }

        public CardinalityConstraint copy() {
            CardinalityConstraint out = new CardinalityConstraint(this.sig.copy(), this.minCardinality, this.maxCardinality, this.canDefault);
            out.index = this.index;
            return out;
        }

        public CardinalityConstraint(ArgumentSignature sig, int minCard, int maxCard, boolean canDefault) {
            this.sig = sig;
            this.maxCardinality = maxCard;
            this.minCardinality = minCard;
            this.canDefault = canDefault;
            this.index = 0;
        }

        public boolean getCanDefault() {
            return this.canDefault;
        }

        public String toString() {
            return this.sig + ":" + this.index;
        }
    }
}

