/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.commandline;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bbop.commandline.ArgumentSignature;
import org.bbop.commandline.CommandLineParser;
import org.bbop.commandline.FailException;
import org.bbop.commandline.StringValue;
import org.bbop.commandline.UnfullfilledException;

public class ValueSpec
implements ArgumentSignature {
    protected static final Logger logger = Logger.getLogger(ValueSpec.class);
    protected String val;
    protected boolean lastResort = true;
    protected Pattern regexpPattern;
    protected String templateVal;
    protected int id = CommandLineParser.getID();

    @Override
    public int getID() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof ArgumentSignature) {
            return ((ArgumentSignature)o).getID() == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public String getShortDocumentation() {
        if (this.templateVal != null) {
            return this.templateVal;
        }
        return "<value>";
    }

    public ValueSpec(String val) {
        this(val, false);
    }

    public ValueSpec(String val, boolean isRegexp) {
        if (isRegexp) {
            this.regexpPattern = Pattern.compile(val);
        } else {
            this.templateVal = val;
        }
    }

    public ValueSpec() {
        this(null);
    }

    protected ValueSpec(boolean internal) {
    }

    public String toString() {
        return "ValueSpec" + this.id + (this.regexpPattern != null ? "(" + this.regexpPattern.pattern() + ")" : "") + ":" + this.val;
    }

    @Override
    public ArgumentSignature copy() {
        ValueSpec out = new ValueSpec(true);
        out.val = this.val;
        out.lastResort = this.lastResort;
        out.regexpPattern = this.regexpPattern;
        out.id = this.id;
        out.templateVal = this.templateVal;
        return out;
    }

    @Override
    public void init(CommandLineParser p, boolean b) {
        this.val = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void accept(CommandLineParser p) throws FailException {
        if (this.val != null) throw new FailException("UNEXPECTED CONDITION: Illegal attempt to replace " + this.val + " with " + p.peekNextString());
        String s = p.getNextString();
        if (this.regexpPattern != null) {
            if (!this.regexpPattern.matcher(s).matches()) throw new FailException("Badly formatted value " + s);
            this.val = s;
            return;
        } else if (this.templateVal != null) {
            if (!this.templateVal.equals(s)) throw new FailException("Expected " + this.templateVal + " instead of " + s);
            this.val = s;
            return;
        } else {
            if (s.startsWith("-")) {
                throw new FailException("Tag values can't start with -");
            }
            this.val = s;
        }
    }

    @Override
    public void setOnlyAcceptAsLastResort(boolean lastResort) {
        this.lastResort = lastResort;
    }

    @Override
    public boolean onlyAcceptAsLastResort() {
        return this.lastResort;
    }

    public void fail() {
        this.val = null;
    }

    @Override
    public List getValues() throws UnfullfilledException {
        if (this.val == null) {
            throw new UnfullfilledException();
        }
        return Collections.singletonList(new StringValue(this.val));
    }
}

