/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.dataadapter;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.AdapterWidgetI;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterRegistry;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.DataAdapterUIFactory;
import org.bbop.dataadapter.DataAdapterUtil;
import org.bbop.dataadapter.IOOperation;
import org.bbop.dataadapter.ParameterUI;
import org.bbop.util.Tag;
import org.bbop.util.TagSpec;

public class CommandLineWidget
implements AdapterWidgetI {
    protected static final Logger logger = Logger.getLogger(CommandLineWidget.class);
    protected static CommandLineWidget self = new CommandLineWidget();

    private CommandLineWidget() {
    }

    public static TagSpec getTagSpec(DataAdapterRegistry registry, DataAdapter defaultAdapter, IOOperation op, Object input) {
        TagSpec outerSpec = new TagSpec("-adapter", "<adapter options>");
        Class[] classes = new Class[]{ParameterUI.class};
        DataAdapter[] adapters = DataAdapterUtil.getAdapters(registry, op, classes);
        DataAdapterUIFactory factory = registry.getUIFactory();
        for (int i = 0; i < adapters.length; ++i) {
            TagSpec adapterSpec = new TagSpec("-" + adapters[i].getID());
            outerSpec.addArgumentSpec(adapterSpec, 1);
            if (adapters[i].equals(defaultAdapter)) {
                outerSpec.setImpliedSpec(adapterSpec, 1);
            }
            Collection<DataAdapterUI> uis = factory.getUIs(adapters[i]);
            DataAdapterUI ui = DataAdapterUtil.getUI(adapters[i], registry, classes);
            if (ui == null) continue;
            ui.init(self, op, adapters[i], input);
            TagSpec spec = ((ParameterUI)ui).getParameterSpec().copy("-options");
            ui.cleanup();
            adapterSpec.addArgumentSpec(spec, 1);
            adapterSpec.setImpliedSpec(spec, 1);
        }
        return outerSpec;
    }

    public static Object execute(DataAdapterRegistry registry, IOOperation op, Tag params, Object input) throws DataAdapterUIException, DataAdapterException {
        if (!params.getName().equals("-adapter")) {
            throw new DataAdapterUIException("Invalid argument: " + params.getName() + ". " + "CommandLineWidget requires an " + "-adapter argument");
        }
        Tag adapterTag = null;
        Tag adapterOptions = null;
        DataAdapter adapter = null;
        Class[] classes = new Class[]{ParameterUI.class};
        for (Tag tag : params.getArguments()) {
            adapter = registry.getAdapter(tag.getName().substring(1));
            if (adapter == null) continue;
            adapterTag = tag;
            break;
        }
        if (adapter == null) {
            throw new DataAdapterUIException("No adapter specified!");
        }
        for (Tag tag : adapterTag.getArguments()) {
            if (!tag.getName().equals("-options")) continue;
            adapterOptions = tag;
            break;
        }
        if (adapterOptions == null) {
            adapterOptions = new Tag("-options", true);
        }
        DataAdapterUI ui = null;
        ui = DataAdapterUtil.getUI(adapter, registry, classes);
        if (ui == null) {
            throw new DataAdapterException("Adapter " + adapter.getID() + " does " + "not support command line " + "arguments.");
        }
        logger.info((Object)("adapter = " + adapter + ", adapterOptions = " + adapterOptions));
        ui.init(self, op, adapter, input);
        ((ParameterUI)ui).setParameters(adapterOptions);
        AdapterConfiguration config = ui.getConfig(op, adapter, input);
        ui.cleanup();
        Object output = adapter.doOperation(op, config, input);
        return output;
    }
}

