/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.dataadapter;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterRegistry;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.IOOperation;

public class DataAdapterUtil {
    protected static final Logger logger = Logger.getLogger(DataAdapterUtil.class);

    public static DataAdapterUI getUI(DataAdapter adapter, DataAdapterRegistry registry, Class<?>[] uiClasses) {
        Collection<DataAdapterUI> c = registry.getUIFactory().getUIs(adapter);
        for (DataAdapterUI ui : c) {
            boolean match = true;
            for (int i = 0; i < uiClasses.length; ++i) {
                if (uiClasses[i].isAssignableFrom(ui.getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return ui;
        }
        return null;
    }

    public static DataAdapter[] getAdapters(DataAdapterRegistry registry, IOOperation<?, ?> op, Class<?>[] uiClasses) {
        ArrayList<DataAdapter> out = new ArrayList<DataAdapter>();
        for (DataAdapter adapter : registry.getAdapters()) {
            boolean matched = false;
            IOOperation[] ops = adapter.getSupportedOperations();
            for (int i = 0; i < ops.length; ++i) {
                if (!ops[i].equals(op)) continue;
                matched = true;
                break;
            }
            if (matched && uiClasses != null) {
                Collection<DataAdapterUI> uis = registry.getUIFactory().getUIs(adapter);
                matched = false;
                for (DataAdapterUI ui : uis) {
                    matched = true;
                    for (int i = 0; i < uiClasses.length; ++i) {
                        if (uiClasses[i].isAssignableFrom(ui.getClass())) continue;
                        matched = false;
                        break;
                    }
                    if (!matched) continue;
                    break;
                }
            }
            if (!matched) continue;
            out.add(adapter);
        }
        DataAdapter[] adapters = out.toArray(new DataAdapter[0]);
        return adapters;
    }
}

