/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.dataadapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterRegistry;
import org.bbop.dataadapter.DataAdapterUIFactory;
import org.bbop.dataadapter.DefaultUIFactory;

public class DefaultAdapterRegistry
implements DataAdapterRegistry {
    protected static final Logger logger = Logger.getLogger(DefaultAdapterRegistry.class);
    protected DataAdapterUIFactory factory = new DefaultUIFactory();
    protected Map<String, DataAdapter> adapters = new LinkedHashMap<String, DataAdapter>();

    @Override
    public void addAdapter(DataAdapter adapter) {
        this.adapters.put(adapter.getID(), adapter);
    }

    @Override
    public void removeAdapter(DataAdapter adapter) {
        this.adapters.remove(adapter.getID());
    }

    @Override
    public DataAdapter getAdapter(String id) {
        return this.adapters.get(id);
    }

    @Override
    public void setUIFactory(DataAdapterUIFactory factory) {
        this.factory = factory;
    }

    @Override
    public Collection<DataAdapter> getAdapters() {
        ArrayList<DataAdapter> out = new ArrayList<DataAdapter>();
        for (String id : this.adapters.keySet()) {
            out.add(this.adapters.get(id));
        }
        return out;
    }

    @Override
    public DataAdapterUIFactory getUIFactory() {
        return this.factory;
    }
}

