/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.dataadapter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AbstractGraphicalUI;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.AdapterWidgetI;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.IOOperation;
import org.bbop.dataadapter.ParameterUI;
import org.bbop.dataadapter.UIConfiguration;
import org.bbop.io.IOUtil;
import org.bbop.swing.SelectDialog;
import org.bbop.util.Tag;
import org.bbop.util.TagSpec;

public class FileAdapterUI
extends AbstractGraphicalUI
implements ParameterUI {
    protected static final Logger logger = Logger.getLogger(FileAdapterUI.class);
    private static final long serialVersionUID = 6457202902580260109L;
    protected JComboBox readField = new JComboBox();
    protected JComboBox writeField = new JComboBox();
    protected JButton readBrowseButton = new JButton("Browse...");
    protected JButton writeBrowseButton = new JButton("Browse...");
    protected JLabel readLabel = new JLabel("Load file");
    protected JLabel writeLabel = new JLabel("Save file");
    protected JPanel readPanel = new JPanel();
    protected JPanel writePanel = new JPanel();
    protected boolean multiSelectEnabled = true;
    protected IOOperation<?, ?> readOperation;
    protected IOOperation<?, ?> writeOperation;
    protected static final int MAX_HISTORY_SIZE = 5;

    protected boolean isReadOperation(IOOperation op) {
        return op.equals(this.readOperation);
    }

    protected boolean isWriteOperation(IOOperation op) {
        return op.equals(this.writeOperation);
    }

    public void setReadOperation(IOOperation op) {
        this.readOperation = op;
    }

    public void setWriteOperation(IOOperation op) {
        this.writeOperation = op;
    }

    protected JPanel buildFieldPanel(JLabel label, JComponent comp, JButton browseButton, int padding) {
        Box labelBox = new Box(0);
        labelBox.add(label);
        labelBox.add(Box.createHorizontalStrut(padding));
        Box browseBox = new Box(0);
        browseBox.add(Box.createHorizontalStrut(padding));
        browseBox.add(browseButton);
        JPanel out = new JPanel();
        out.setOpaque(false);
        out.setLayout(new BorderLayout());
        out.add((Component)labelBox, "West");
        out.add((Component)comp, "Center");
        out.add((Component)browseBox, "East");
        return out;
    }

    public void setButtonColor(Color background, Color foreground) {
        this.readBrowseButton.setBackground(background);
        this.readBrowseButton.setForeground(foreground);
        this.writeBrowseButton.setBackground(background);
        this.writeBrowseButton.setForeground(foreground);
        this.readField.setBackground(background);
        this.writeField.setBackground(background);
    }

    @Override
    public void setFont(Font font) {
        this.setLabelFont(font);
        this.setButtonFont(font);
    }

    public void setLabelFont(Font labelFont) {
        if (this.readLabel != null) {
            this.readLabel.setFont(labelFont);
        }
        if (this.writeLabel != null) {
            this.writeLabel.setFont(labelFont);
        }
    }

    public void setButtonFont(Font buttonFont) {
        if (this.readBrowseButton != null) {
            this.readBrowseButton.setFont(buttonFont);
        }
        if (this.writeBrowseButton != null) {
            this.writeBrowseButton.setFont(buttonFont);
        }
        if (this.readField != null) {
            this.readField.setFont(buttonFont);
        }
        if (this.writeField != null) {
            this.writeField.setFont(buttonFont);
        }
    }

    public FileAdapterUI() {
        this.setOpaque(false);
        this.setMultiSelectEnabled(true);
        this.readField.setEditable(true);
        this.writeField.setEditable(true);
        this.readPanel = this.buildFieldPanel(this.readLabel, this.readField, this.readBrowseButton, 10);
        this.writePanel = this.buildFieldPanel(this.writeLabel, this.writeField, this.writeBrowseButton, 10);
        this.uiConfig = new FileUIConfig();
        this.readBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentPath = (String)FileAdapterUI.this.readField.getSelectedItem();
                SelectDialog dialog = SelectDialog.getFileSelector(false, currentPath);
                dialog.show();
                String selected = dialog.getSelectedCanonicalPath();
                if (selected != null) {
                    selected = FileAdapterUI.this.handleSelected(selected, false);
                    FileAdapterUI.this.readField.setSelectedItem(FileAdapterUI.this.escapePath(selected, false));
                }
            }
        });
        this.writeBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentPath = (String)FileAdapterUI.this.writeField.getSelectedItem();
                SelectDialog dialog = SelectDialog.getFileSelector(true, currentPath);
                dialog.show();
                String selected = dialog.getSelectedCanonicalPath();
                if (selected != null) {
                    selected = FileAdapterUI.this.handleSelected(selected, true);
                    FileAdapterUI.this.writeField.setSelectedItem(selected);
                }
            }
        });
    }

    protected String handleSelected(String selected, boolean write) {
        return selected;
    }

    public void setMultiSelectEnabled(boolean multiSelectEnabled) {
        this.readLabel.setText(multiSelectEnabled ? "Load files" : "Load file");
    }

    @Override
    public void setUIConfiguration(UIConfiguration uiConfig) {
        super.setUIConfiguration(uiConfig);
        if (uiConfig == null) {
            return;
        }
        this.readField.removeAllItems();
        FileUIConfig config = (FileUIConfig)uiConfig;
        List readHistory = config.getReadHistory();
        for (String s : readHistory) {
            this.readField.addItem(s);
        }
        if (readHistory.size() > 0) {
            this.readField.setSelectedIndex(0);
        }
        this.writeField.removeAllItems();
        List writeHistory = config.getWriteHistory();
        for (String s : writeHistory) {
            this.writeField.addItem(s);
        }
        if (writeHistory.size() > 0) {
            this.writeField.setSelectedIndex(0);
        }
    }

    @Override
    public UIConfiguration getUIConfiguration() {
        String fieldContents;
        FileUIConfig config = (FileUIConfig)this.uiConfig;
        if (config == null) {
            config = new FileUIConfig();
        }
        Vector<String> readHistory = new Vector<String>();
        Vector<String> writeHistory = new Vector<String>();
        readHistory.addAll(config.getReadHistory());
        if (this.readField.getSelectedItem() != null && (fieldContents = ((String)this.readField.getSelectedItem()).trim()).length() > 0) {
            readHistory.remove(fieldContents);
            readHistory.add(0, fieldContents);
        }
        if (readHistory.size() > 5) {
            readHistory.setSize(5);
        }
        config.setReadHistory(readHistory);
        writeHistory.addAll(config.getWriteHistory());
        if (this.writeField.getSelectedItem() != null && (fieldContents = ((String)this.writeField.getSelectedItem()).trim()).length() > 0) {
            writeHistory.remove(fieldContents);
            writeHistory.add(0, fieldContents);
        }
        if (writeHistory.size() > 5) {
            writeHistory.setSize(5);
        }
        config.setWriteHistory(writeHistory);
        return super.getUIConfiguration();
    }

    @Override
    public void setConfiguration(AdapterConfiguration c) {
        if (!(c instanceof FileAdapterConfiguration)) {
            throw new IllegalArgumentException("File adapter UIs can only accept file adapter configuration files");
        }
        super.setConfiguration(c);
        FileAdapterConfiguration config = (FileAdapterConfiguration)c;
        if (config.getReadPaths() != null && config.getReadPaths().size() > 0) {
            String readPath = "";
            Iterator<String> it = config.getReadPaths().iterator();
            int i = 0;
            while (it.hasNext()) {
                String s = it.next();
                if (i > 0) {
                    readPath = readPath + " ";
                }
                readPath = readPath + this.escapePath(s, false);
                ++i;
            }
            this.readField.setSelectedItem(readPath);
        }
        if (config.getWritePath() != null) {
            this.writeField.setSelectedItem(config.getWritePath());
        }
    }

    protected String escapePath(String path, boolean quoted) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '\"') {
                out.append("\\\"");
                continue;
            }
            if (i + 1 < path.length() && path.charAt(i) == '\\' && path.charAt(i + 1) == '\"') {
                out.append("\\\\");
                continue;
            }
            if (path.charAt(i) == ' ' && !quoted) {
                out.append("\\ ");
                continue;
            }
            out.append(path.charAt(i));
        }
        return out.toString();
    }

    protected Collection getPaths() {
        HashSet<String> out = new HashSet<String>();
        String s = (String)this.readField.getSelectedItem();
        if (s == null) {
            return out;
        }
        s = s.trim();
        if (this.multiSelectEnabled) {
            boolean quotes = false;
            boolean inString = false;
            StringBuffer currentStr = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (inString) {
                        if (!quotes) {
                            out.add(currentStr.toString());
                            inString = false;
                            currentStr = new StringBuffer();
                            continue;
                        }
                        currentStr.append(c);
                        continue;
                    }
                    inString = false;
                    quotes = false;
                    continue;
                }
                if (c == '\"') {
                    if (inString && quotes) {
                        quotes = false;
                        inString = false;
                        out.add(currentStr.toString());
                        currentStr = new StringBuffer();
                        continue;
                    }
                    if (inString && !quotes) {
                        out.add(currentStr.toString());
                        currentStr = new StringBuffer();
                        quotes = true;
                        continue;
                    }
                    inString = true;
                    quotes = true;
                    continue;
                }
                if (c == '\\') {
                    if (s.length() > i + 1 && (s.charAt(i + 1) == '\"' || !quotes && s.charAt(i + 1) == ' ')) {
                        c = s.charAt(++i);
                    }
                    currentStr.append(c);
                    inString = true;
                    continue;
                }
                currentStr.append(c);
                inString = true;
            }
            if (inString) {
                out.add(currentStr.toString());
            }
        } else {
            out.add(s);
        }
        return out;
    }

    @Override
    public AdapterConfiguration createEmptyConfig() {
        return new FileAdapterConfiguration();
    }

    @Override
    public void init(AdapterWidgetI widget, IOOperation op, DataAdapter adapter, Object input) {
        super.init(widget, op, adapter, input);
        this.setLayout(new BorderLayout());
        this.removeAll();
        if (this.isReadOperation(op)) {
            this.add((Component)this.readPanel, "North");
        } else if (this.isWriteOperation(op)) {
            this.add((Component)this.writePanel, "North");
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
        FileAdapterConfiguration config = (FileAdapterConfiguration)this.config;
        config.setReadPaths(this.getPaths());
        config.setWritePath((String)this.writeField.getSelectedItem());
        if (this.isReadOperation(this.op)) {
            for (String path : config.getReadPaths()) {
                if (storeonly || IOUtil.isURL(path) || new File(path).exists()) continue;
                throw new DataAdapterUIException("File " + path + " does not exist.");
            }
        } else if (this.isWriteOperation(this.op)) {
            int val;
            String writePath = config.getWritePath();
            if (!storeonly && writePath != null && new File(writePath).exists() && (val = JOptionPane.showConfirmDialog(this, "File " + writePath + " exists. " + "Overwrite?", "Overwrite file?", 0)) != 0) {
                throw new DataAdapterUIException();
            }
        }
    }

    @Override
    public TagSpec getParameterSpec() {
        TagSpec out = new TagSpec();
        TagSpec fSpec = new TagSpec("-f");
        fSpec.addArgumentSpec(null, -1);
        TagSpec oSpec = new TagSpec("-o");
        oSpec.addArgumentSpec(null, 1);
        out.addArgumentSpec(fSpec, 1);
        out.addArgumentSpec(oSpec, 1);
        out.setImpliedSpec(fSpec, 1);
        return out;
    }

    @Override
    public void setParameters(Tag optionsTag) throws DataAdapterUIException {
        for (Tag param : optionsTag.getArguments()) {
            this.processParameter(param);
        }
    }

    protected void processParameter(Tag param) throws DataAdapterUIException {
        FileAdapterConfiguration config = (FileAdapterConfiguration)this.config;
        if (param.getName().equals("-o")) {
            if (!this.isWriteOperation(this.op)) {
                throw new DataAdapterUIException("Cannot set an output path when reading files");
            }
            if (param.getArguments().size() > 0) {
                throw new DataAdapterUIException("Cannot set multiple output files");
            }
            config.setWritePath((String)param.getArguments().get(0));
        } else if (param.getName().equals("-f")) {
            config.getReadPaths().addAll(param.getArguments());
        }
        if (!this.isReadOperation(this.op)) {
            if (config.getReadPaths().size() > 0) {
                throw new DataAdapterUIException("Cannot specify files to load when writing files.");
            }
        } else if (config.getReadPaths().size() < 1) {
            throw new DataAdapterUIException("Must specify at least one file to load.");
        }
    }

    @Override
    public void cleanup() {
    }

    public static class FileUIConfig
    implements UIConfiguration {
        protected List readHistory = new Vector();
        protected List writeHistory = new Vector();

        public void setReadHistory(List readHistory) {
            this.readHistory = readHistory;
        }

        public void setWriteHistory(List writeHistory) {
            this.writeHistory = writeHistory;
        }

        public List getReadHistory() {
            return this.readHistory;
        }

        public List getWriteHistory() {
            return this.writeHistory;
        }
    }
}

