/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.dataadapter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.AdapterWidgetI;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterOperationTask;
import org.bbop.dataadapter.DataAdapterRegistry;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.DataAdapterUtil;
import org.bbop.dataadapter.GraphicalUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.dataadapter.UIConfiguration;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.swing.MinusIcon;
import org.bbop.swing.PlusIcon;
import org.bbop.swing.SwingUtil;
import org.bbop.util.StringUtil;

public class GraphicalAdapterChooser<IN, OUT>
extends JPanel
implements AdapterWidgetI {
    protected static final Logger logger = Logger.getLogger(GraphicalAdapterChooser.class);
    private static final long serialVersionUID = -1304344582277871901L;
    protected static final Class[] checkClasses = new Class[]{Component.class, GraphicalUI.class};
    protected static final Icon rightArrowIcon = new Icon(){
        protected int height = 16;
        protected int width = 9;

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Polygon polygon = new Polygon();
            polygon.addPoint(x, y);
            polygon.addPoint(x + this.width - 1, y + this.height / 2);
            polygon.addPoint(x, y + this.height);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(c.getBackground());
            g.fillPolygon(polygon);
            g.setColor(c.getForeground());
            g.drawPolygon(polygon);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    };
    protected static final Icon downArrowIcon = new Icon(){
        protected int width = 16;
        protected int height = 9;

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Polygon polygon = new Polygon();
            polygon.addPoint(x, y);
            polygon.addPoint(x + this.width - 1, y);
            polygon.addPoint(x + this.width / 2, y + this.height);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(c.getBackground());
            g.fillPolygon(polygon);
            g.setColor(c.getForeground());
            g.drawPolygon(polygon);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    };
    protected static final URL rightArrowIconURL = ClassLoader.getSystemClassLoader().getResource("org/geneontology/resources/blue_arrow.gif");
    protected static final URL downArrowIconURL = ClassLoader.getSystemClassLoader().getResource("org/geneontology/resources/blue_arrow_down.gif");
    protected DataAdapterRegistry registry;
    protected JLabel profileChooserLabel = new JLabel("Stored adapter settings");
    protected JLabel adapterChooserLabel = new JLabel("Data adapter");
    protected JPanel uiPanel = new JPanel();
    protected JPanel profileButtonPanel = new JPanel();
    protected JButton showProfilesButton = new JButton(rightArrowIcon);
    protected JButton showAdvancedButton = new JButton("Advanced...");
    protected JButton showBasicButton = new JButton("Basic...");
    protected JComboBox adapterList = new JComboBox();
    protected JComboBox profileListChooser = new JComboBox();
    protected boolean profileListChooserVisible = false;
    protected GraphicalUI currentUI;
    protected DataAdapter currentAdapter;
    protected IOOperation<IN, OUT> op;
    protected IN input;
    protected String historyPath;
    protected AdapterChooserConfig chooserConfig = new AdapterChooserConfig();
    protected NamedAdapterConfig currentConfig;
    protected TitledBorder uiPanelBorder = new TitledBorder("Configuration");
    protected ProfileCollection profileList;
    protected boolean throwExceptions = false;
    protected boolean committed = false;
    protected JButton okButton = new JButton("  Ok  ");
    protected JButton cancelButton = new JButton("Cancel");
    protected JButton exceptionCancelButton = new JButton("Cancel");
    protected JButton tryAgainButton = new JButton("Try again");
    protected JButton plusButton = new JButton(new PlusIcon(1.5f, 8, 8));
    protected JButton minusButton = new JButton(new MinusIcon(1.5f, 8, 8));
    JDialog dialog;
    protected JPanel profileListChooserPanel = new JPanel();
    protected JPanel northPanel = new JPanel();
    protected JPanel okButtonPanel = new JPanel();
    protected JPanel exceptionButtonPanel = new JPanel();
    protected Color backgroundColor;
    protected Font labelFont;
    protected DataAdapterOperationTask<IN, OUT> loadtask;
    protected BackgroundEventQueue queue;
    protected JEditorPane exceptionEditorPane = new JEditorPane("text/html", "<html></html>");
    protected JScrollPane exceptionPanel = new JScrollPane(this.exceptionEditorPane, 20, 31);
    protected ActionListener profileChooserListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicalAdapterChooser.this.storeCurrentProfile();
            GraphicalAdapterChooser.this.loadProfile();
        }
    };
    protected ActionListener adapterListListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicalAdapterChooser.this.setCurrentAdapter((DataAdapter)GraphicalAdapterChooser.this.adapterList.getSelectedItem());
        }
    };

    public void setHistoryPath(String path) {
        try {
            this.historyPath = path;
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(path)));
            this.chooserConfig = (AdapterChooserConfig)d.readObject();
            d.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.chooserConfig == null) {
            this.chooserConfig = new AdapterChooserConfig();
        }
        this.profileList = null;
        this.currentConfig = null;
        this.setProfileListVisible(this.chooserConfig.getShowProfiles());
        this.initProfiles();
        String currentAdapterID = (String)this.chooserConfig.getOperationToLastAdapterMap().get(this.op.getID());
        if (currentAdapterID != null) {
            for (int i = 0; i < this.adapterList.getItemCount(); ++i) {
                DataAdapter adapter = (DataAdapter)this.adapterList.getItemAt(i);
                if (!adapter.getID().equals(currentAdapterID)) continue;
                this.adapterList.setSelectedIndex(i);
                break;
            }
        }
        if (this.profileList != null) {
            Boolean b = (Boolean)this.profileList.getOperationToAdvancedMap().get(this.op);
            this.setShowAdvanced(b == null ? false : b);
        }
    }

    public void flushConfiguration() {
        if (this.historyPath == null) {
            return;
        }
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.historyPath)));
            e.writeObject(this.chooserConfig);
            e.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setThrowException(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setButtonFont(font);
        this.setLabelFont(font);
    }

    public void setButtonFont(Font buttonFont) {
        if (this.okButton != null) {
            this.okButton.setFont(buttonFont);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setFont(buttonFont);
        }
        if (this.exceptionCancelButton != null) {
            this.exceptionCancelButton.setFont(buttonFont);
        }
        if (this.adapterList != null) {
            this.adapterList.setFont(buttonFont);
        }
        if (this.profileListChooser != null) {
            this.profileListChooser.setFont(buttonFont);
        }
        if (this.tryAgainButton != null) {
            this.tryAgainButton.setFont(buttonFont);
        }
        if (this.showAdvancedButton != null) {
            this.showAdvancedButton.setFont(buttonFont);
        }
        if (this.showBasicButton != null) {
            this.showBasicButton.setFont(buttonFont);
        }
    }

    public void setLabelFont(Font labelFont) {
        if (this.adapterChooserLabel != null) {
            this.adapterChooserLabel.setFont(labelFont);
        }
        if (this.profileChooserLabel != null) {
            this.profileChooserLabel.setFont(labelFont);
        }
        if (this.uiPanelBorder != null) {
            this.uiPanelBorder.setTitleFont(labelFont);
        }
    }

    public void setButtonColor(Color background, Color foreground) {
        this.adapterList.setBackground(background);
        this.adapterList.setForeground(foreground);
        this.plusButton.setBackground(background);
        this.plusButton.setForeground(foreground);
        this.minusButton.setBackground(background);
        this.minusButton.setForeground(foreground);
        this.profileListChooser.setBackground(background);
        this.profileListChooser.setForeground(foreground);
        this.okButton.setBackground(background);
        this.okButton.setForeground(foreground);
        this.cancelButton.setBackground(background);
        this.cancelButton.setForeground(foreground);
        this.exceptionCancelButton.setBackground(background);
        this.exceptionCancelButton.setForeground(foreground);
        this.tryAgainButton.setBackground(background);
        this.tryAgainButton.setForeground(foreground);
        this.showAdvancedButton.setBackground(background);
        this.showAdvancedButton.setForeground(foreground);
        this.showBasicButton.setBackground(background);
        this.showBasicButton.setForeground(foreground);
        this.showProfilesButton.setBackground(background);
        this.showProfilesButton.setForeground(foreground);
    }

    protected NamedAdapterConfig createNamedConfig() {
        NamedAdapterConfig nc = new NamedAdapterConfig();
        nc.setName("<create new profile>");
        nc.setConfiguration(this.currentUI.createEmptyConfig());
        return nc;
    }

    public void setMargins(int top, int left, int bottom, int right) {
        EmptyBorder margins = new EmptyBorder(10, 10, 10, 10);
        this.setBorder(margins);
    }

    public void deleteCurrentConfig() {
        this.profileListChooser.removeActionListener(this.profileChooserListener);
        int index = this.profileListChooser.getSelectedIndex();
        NamedAdapterConfig nextConfig = index >= this.profileListChooser.getItemCount() - 1 ? (index > 1 ? (NamedAdapterConfig)this.profileListChooser.getItemAt(index - 1) : null) : (NamedAdapterConfig)this.profileListChooser.getItemAt(index + 1);
        this.profileList.getProfiles().remove(this.currentConfig);
        if (this.profileList.getDefaultConfig().equals(this.currentConfig)) {
            this.profileList.setDefaultConfig(this.currentConfig);
        }
        this.storeProfileList();
        this.initProfiles();
        this.profileListChooser.addActionListener(this.profileChooserListener);
        if (nextConfig == null) {
            this.profileListChooser.setSelectedIndex(0);
        } else {
            this.profileListChooser.setSelectedItem(nextConfig);
        }
    }

    public void addNewNamedConfig() {
        if (this.currentConfig != null) {
            try {
                this.currentUI.acceptComponentConfig(true);
                this.currentConfig.setConfiguration(this.currentUI.getConfig(this.op, this.currentAdapter, this.input));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        NamedAdapterConfig nac = this.createNamedConfig();
        nac.setName("<new profile>");
        this.profileListChooser.removeActionListener(this.profileChooserListener);
        this.profileListChooser.insertItemAt(nac, 1);
        this.profileListChooser.addActionListener(this.profileChooserListener);
        this.profileListChooser.setSelectedIndex(1);
    }

    protected void storeCurrentProfile() {
        if (this.currentConfig != null) {
            try {
                this.currentUI.acceptComponentConfig(true);
                this.currentConfig.setConfiguration(this.currentUI.getConfig(this.op, this.currentAdapter, this.input));
                if (this.profileListChooser.getSelectedIndex() == 0 && !((NamedAdapterConfig)this.profileListChooser.getSelectedItem()).getName().equals("<create new profile>")) {
                    this.profileListChooser.insertItemAt(this.createNamedConfig(), 0);
                }
            }
            catch (Exception ex) {
                logger.info((Object)"GraphicalAdapterChooser.storeCurrentProfile: did not store current config!");
                ex.getMessage();
            }
        }
    }

    protected void storeProfileList() {
        if (this.profileList != null) {
            if (this.profileListChooser.getSelectedIndex() != 0) {
                this.profileList.setDefaultConfig(this.currentConfig);
            } else {
                this.profileList.setDefaultConfig(null);
            }
            this.profileList.getProfiles().remove(0);
            this.chooserConfig.getProfileMap().put(this.currentAdapter.getID(), this.profileList);
            this.profileList.setUIConfig(this.currentUI.getUIConfiguration());
        }
    }

    protected void initProfiles() {
        this.profileList = new ProfileCollection();
        this.currentConfig = null;
        this.profileList.getProfiles().add(this.createNamedConfig());
        ProfileCollection pc = (ProfileCollection)this.chooserConfig.getProfileMap().get(this.currentAdapter.getID());
        UIConfiguration uiConfig = null;
        if (pc != null) {
            this.profileList.setOperationToAdvancedMap(new HashMap(pc.getOperationToAdvancedMap()));
            Vector record = pc.getProfiles();
            if (record != null) {
                this.profileList.getProfiles().addAll(record);
            }
            uiConfig = pc.getUIConfig();
            this.currentUI.setUIConfiguration(uiConfig);
        }
        this.profileListChooser.removeActionListener(this.profileChooserListener);
        this.profileListChooser.setModel(new DefaultComboBoxModel(this.profileList.getProfiles()));
        this.profileListChooser.addActionListener(this.profileChooserListener);
        if (pc != null && pc.getDefaultConfig() != null) {
            this.profileListChooser.setSelectedItem(pc.getDefaultConfig());
        } else {
            this.profileListChooser.setSelectedIndex(0);
        }
        Boolean b = (Boolean)this.profileList.getOperationToAdvancedMap().get(this.op);
        this.setShowAdvanced(b == null ? false : b);
    }

    public void setCurrentAdapter(DataAdapter adapter) {
        this.storeProfileList();
        this.currentAdapter = adapter;
        this.uiPanelBorder.setTitle(adapter.getName() + " Configuration");
        DataAdapterUI ui = DataAdapterUtil.getUI(adapter, this.registry, checkClasses);
        this.setAdapterUI(ui);
        this.initProfiles();
    }

    public DataAdapter getCurrentAdapter() {
        return this.currentAdapter;
    }

    public void setProfileListVisible(boolean profileListChooserVisible) {
        this.chooserConfig.setShowProfiles(profileListChooserVisible);
        this.northPanel.remove(this.profileListChooserPanel);
        if (this.chooserConfig.getShowProfiles()) {
            this.northPanel.add(this.profileListChooserPanel);
            this.showProfilesButton.setIcon(downArrowIcon);
            this.showProfilesButton.setToolTipText("Hide stored adapter configurations");
        } else {
            this.showProfilesButton.setToolTipText("Show stored adapter configurations");
            this.showProfilesButton.setIcon(rightArrowIcon);
        }
        this.validate();
        this.repaint();
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    protected void loadProfile() {
        this.currentConfig = (NamedAdapterConfig)this.profileListChooser.getSelectedItem();
        if (this.currentConfig.getConfiguration() != null) {
            this.currentUI.setConfiguration(this.currentConfig.getConfiguration());
        }
        if (this.profileListChooser.getSelectedIndex() == 0) {
            this.profileList.setDefaultConfig(null);
        } else {
            this.profileList.setDefaultConfig(this.currentConfig);
        }
        this.minusButton.setEnabled(this.profileListChooser.getSelectedIndex() != 0);
    }

    public GraphicalAdapterChooser(DataAdapterRegistry registry, IOOperation<IN, OUT> op, BackgroundEventQueue queue, Frame frame, boolean modal, IN input) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.uiPanel, "Center");
        this.add((Component)this.okButtonPanel, "South");
        this.adapterList.setRenderer(new AdapterListRenderer());
        this.profileListChooserPanel.setOpaque(false);
        this.showProfilesButton.setContentAreaFilled(false);
        this.showProfilesButton.setBorderPainted(false);
        this.queue = queue;
        CompoundBorder paddedUIBorder = new CompoundBorder(this.uiPanelBorder, new EmptyBorder(10, 10, 10, 10));
        this.uiPanel.setBorder(paddedUIBorder);
        this.profileListChooserPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.northPanel.setLayout(new BorderLayout());
        this.profileButtonPanel.setLayout(new BoxLayout(this.profileButtonPanel, 0));
        this.profileButtonPanel.setOpaque(false);
        Box adapterLabelPanel = new Box(0);
        adapterLabelPanel.add(this.adapterChooserLabel);
        adapterLabelPanel.add(Box.createHorizontalStrut(10));
        JPanel adapterListPanel = new JPanel();
        adapterListPanel.setLayout(new BorderLayout());
        adapterListPanel.setOpaque(false);
        adapterListPanel.add((Component)adapterLabelPanel, "West");
        adapterListPanel.add((Component)this.adapterList, "Center");
        adapterListPanel.add((Component)this.profileButtonPanel, "East");
        adapterListPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.northPanel.add((Component)adapterListPanel, "North");
        this.northPanel.add((Component)this.profileListChooserPanel, "South");
        this.northPanel.setOpaque(false);
        this.uiPanel.setOpaque(false);
        this.uiPanel.setLayout(new BorderLayout());
        this.setProfileListVisible(false);
        this.setShowAdvanced(false);
        Box profileButtonBox = new Box(0);
        profileButtonBox.add(Box.createHorizontalStrut(10));
        profileButtonBox.add(this.plusButton);
        profileButtonBox.add(Box.createHorizontalStrut(5));
        profileButtonBox.add(this.minusButton);
        Box profileLabelPanel = new Box(0);
        profileLabelPanel.add(this.profileChooserLabel);
        profileLabelPanel.add(Box.createHorizontalStrut(10));
        this.profileListChooserPanel.setLayout(new BorderLayout());
        this.profileListChooserPanel.add((Component)profileLabelPanel, "West");
        this.profileListChooserPanel.add((Component)this.profileListChooser, "Center");
        this.profileListChooserPanel.add((Component)profileButtonBox, "East");
        NamedConfigEditor editor = new NamedConfigEditor();
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.storeCurrentProfile();
            }
        });
        this.profileListChooser.setEditable(true);
        this.profileListChooser.setEditor(editor);
        this.okButtonPanel.setLayout(new BoxLayout(this.okButtonPanel, 0));
        this.okButtonPanel.add(Box.createHorizontalGlue());
        this.okButtonPanel.add(this.okButton);
        this.okButtonPanel.add(Box.createHorizontalStrut(10));
        this.okButtonPanel.add(this.cancelButton);
        this.okButtonPanel.add(Box.createHorizontalGlue());
        this.okButtonPanel.setOpaque(false);
        this.exceptionButtonPanel.setLayout(new BoxLayout(this.exceptionButtonPanel, 0));
        this.exceptionButtonPanel.add(Box.createHorizontalGlue());
        this.exceptionButtonPanel.add(this.tryAgainButton);
        this.exceptionButtonPanel.add(Box.createHorizontalStrut(10));
        this.exceptionButtonPanel.add(this.exceptionCancelButton);
        this.exceptionButtonPanel.add(Box.createHorizontalGlue());
        this.exceptionButtonPanel.setOpaque(false);
        this.profileListChooser.addActionListener(this.profileChooserListener);
        this.showProfilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.setProfileListVisible(!GraphicalAdapterChooser.this.chooserConfig.getShowProfiles());
            }
        });
        this.showAdvancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.setShowAdvanced(true);
            }
        });
        this.showBasicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.setShowAdvanced(false);
            }
        });
        this.plusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.addNewNamedConfig();
            }
        });
        this.minusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.deleteCurrentConfig();
            }
        });
        this.tryAgainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.restoreGUI();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.commit();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.cancel();
            }
        });
        this.exceptionCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalAdapterChooser.this.cancel();
            }
        });
        this.exceptionEditorPane.setEditable(false);
        this.exceptionPanel.setPreferredSize(new Dimension(300, 300));
        int prefHeight = (int)this.profileListChooser.getPreferredSize().getHeight();
        this.plusButton.setPreferredSize(new Dimension(prefHeight, prefHeight));
        this.minusButton.setPreferredSize(new Dimension(prefHeight, prefHeight));
        this.setMargins(10, 10, 10, 10);
        this.setRegistry(registry, op, input);
    }

    protected void setShowAdvanced(boolean showAdvanced) {
        if (this.currentUI == null) {
            return;
        }
        this.setProfileListVisible(showAdvanced);
        this.profileList.getOperationToAdvancedMap().put(this.op, new Boolean(showAdvanced));
        AdapterConfiguration config = null;
        try {
            this.currentUI.acceptComponentConfig(true);
            config = this.currentUI.getConfig(this.op, this.currentAdapter, this.input);
        }
        catch (DataAdapterUIException dataAdapterUIException) {
            // empty catch block
        }
        if (showAdvanced && this.currentUI.getAdvancedUI() != null) {
            this.setPreferredSize(new Dimension(800, 550));
            this.setAdapterUI(this.currentUI.getAdvancedUI());
        } else if (!showAdvanced && this.currentUI.getSimpleUI() != null) {
            this.setPreferredSize(new Dimension(600, 160));
            this.setAdapterUI(this.currentUI.getSimpleUI());
        }
        this.currentUI.setConfiguration(config);
    }

    protected void restoreGUI() {
        this.remove(this.exceptionButtonPanel);
        this.uiPanel.removeAll();
        this.uiPanel.add((Component)((Object)this.currentUI), "Center");
        this.add((Component)this.okButtonPanel, "South");
        this.validate();
        this.repaint();
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    protected void showExceptionGUI(Throwable exception) {
        this.remove(this.okButtonPanel);
        this.uiPanel.removeAll();
        String html = "<html><body><b>" + StringUtil.escapeHTML(exception.getMessage()) + "</b><br>";
        if (exception.getCause() != null) {
            if (exception.getCause().getMessage() != null) {
                html = html + "<i>" + StringUtil.escapeHTML(exception.getCause().getMessage()) + "</i><br>";
            }
            html = html + "<ul>";
            for (int i = 0; i < exception.getCause().getStackTrace().length; ++i) {
                html = html + "<li>" + StringUtil.escapeHTML(exception.getCause().getStackTrace()[i].toString());
            }
            html = html + "</ul>";
        }
        html = html + "</body></html>";
        this.exceptionEditorPane.setText(html);
        this.uiPanel.add((Component)this.exceptionPanel, "Center");
        this.add((Component)this.exceptionButtonPanel, "South");
        this.validate();
        this.repaint();
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    public AdapterConfiguration getConfiguration() throws DataAdapterUIException {
        return this.currentUI.getConfig(this.op, this.currentAdapter, this.input);
    }

    public void commit() {
        block2: {
            try {
                this.currentUI.acceptComponentConfig(false);
                AdapterConfiguration config = this.getConfiguration();
                this.loadtask = new DataAdapterOperationTask<IN, OUT>(this.currentAdapter, this.op, config, this.input);
                this.loadtask.addPostExecuteRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GraphicalAdapterChooser.this.committed = true;
                        GraphicalAdapterChooser.this.chooserConfig.getOperationToLastAdapterMap().put(GraphicalAdapterChooser.this.op.getID(), GraphicalAdapterChooser.this.currentAdapter.getID());
                        GraphicalAdapterChooser.this.storeCurrentProfile();
                        GraphicalAdapterChooser.this.storeProfileList();
                        GraphicalAdapterChooser.this.flushConfiguration();
                        if (GraphicalAdapterChooser.this.dialog != null) {
                            GraphicalAdapterChooser.this.dialog.dispose();
                        }
                    }
                });
                this.loadtask.addFailedRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GraphicalAdapterChooser.this.showExceptionGUI(GraphicalAdapterChooser.this.loadtask.getException());
                    }
                });
                this.loadtask.addCancelledRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GraphicalAdapterChooser.this.restoreGUI();
                    }
                });
                this.queue.scheduleTask(this.loadtask);
            }
            catch (DataAdapterUIException ex) {
                if (!ex.showMessage()) break block2;
                this.showExceptionGUI(ex);
            }
        }
    }

    protected void cancel() {
        if (this.currentUI != null) {
            this.currentUI.cleanup();
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public void setRegistry(DataAdapterRegistry registry, IOOperation<IN, OUT> op, IN input) {
        this.registry = registry;
        this.op = op;
        this.input = input;
        DataAdapter[] adapters = DataAdapterUtil.getAdapters(registry, op, checkClasses);
        this.adapterList.removeActionListener(this.adapterListListener);
        this.adapterList.removeAllItems();
        for (int i = 0; i < adapters.length; ++i) {
            this.adapterList.addItem(adapters[i]);
        }
        this.adapterList.addActionListener(this.adapterListListener);
        this.setCurrentAdapter(adapters[0]);
    }

    public DataAdapter getLastAdapter() {
        return this.currentAdapter;
    }

    protected void configureProfileButtonPanel() {
        this.profileButtonPanel.removeAll();
        this.profileButtonPanel.add(Box.createHorizontalStrut(10));
        if (this.currentUI.getSimpleUI() != null) {
            this.profileButtonPanel.add(this.showBasicButton);
            this.profileButtonPanel.add(Box.createHorizontalStrut(10));
        }
        if (this.currentUI.getAdvancedUI() != null) {
            this.profileButtonPanel.add(this.showAdvancedButton);
            this.profileButtonPanel.add(Box.createHorizontalStrut(10));
        }
        this.profileButtonPanel.add(this.showProfilesButton);
        this.profileButtonPanel.validate();
    }

    public void setAdapterUI(DataAdapterUI ui) {
        if (!(ui instanceof Component) && ui instanceof GraphicalUI) {
            throw new IllegalArgumentException("GraphicalAdapterChooser can only display uis that extend java.awt.Component and GraphicalUI");
        }
        if (this.currentUI != null) {
            this.currentUI.cleanup();
        }
        this.currentUI = (GraphicalUI)ui;
        this.currentUI.init(this, this.op, this.currentAdapter, this.input);
        this.uiPanel.removeAll();
        this.configureProfileButtonPanel();
        this.uiPanel.add((Component)((Object)this.currentUI), "Center");
        this.uiPanel.validate();
        this.validate();
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    public OUT getResult() throws DataAdapterException {
        if (this.loadtask.getException() != null) {
            if (this.loadtask.getException() instanceof DataAdapterException) {
                throw (DataAdapterException)this.loadtask.getException();
            }
            throw new DataAdapterException(this.loadtask.getException());
        }
        return (OUT)this.loadtask.getResults();
    }

    public boolean showDialog(String title, JFrame owner) {
        this.dialog = new JDialog(owner);
        this.dialog.setContentPane(this);
        this.dialog.setModal(true);
        this.dialog.setTitle(title);
        this.dialog.pack();
        if (owner != null) {
            SwingUtil.center(owner, this.dialog);
        }
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.committed;
    }

    public static class NamedAdapterConfig {
        protected String name;
        protected AdapterConfiguration configuration;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public AdapterConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(AdapterConfiguration configuration) {
            this.configuration = configuration;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (o instanceof NamedAdapterConfig) {
                return ((NamedAdapterConfig)o).getName().equals(this.name);
            }
            return false;
        }
    }

    public static class AdapterChooserConfig {
        protected Map profileMap;
        protected boolean showProfiles = false;
        protected Map operationToLastAdapterMap = new HashMap();

        public void setOperationToLastAdapterMap(Map map) {
            this.operationToLastAdapterMap = map;
        }

        public Map getOperationToLastAdapterMap() {
            return this.operationToLastAdapterMap;
        }

        public void setShowProfiles(boolean showProfiles) {
            this.showProfiles = showProfiles;
        }

        public boolean getShowProfiles() {
            return this.showProfiles;
        }

        public AdapterChooserConfig() {
            this.profileMap = new HashMap();
        }

        public Map getProfileMap() {
            return this.profileMap;
        }

        public void setProfileMap(Map profileMap) {
            this.profileMap = profileMap;
        }
    }

    public static class ProfileCollection {
        protected Vector profiles = new Vector();
        protected NamedAdapterConfig defaultConfig;
        protected UIConfiguration uiConfig;
        protected Map operationToAdvancedMap = new HashMap();

        public void setOperationToAdvancedMap(Map operationToAdvancedMap) {
            this.operationToAdvancedMap = operationToAdvancedMap;
        }

        public Map getOperationToAdvancedMap() {
            return this.operationToAdvancedMap;
        }

        public void setUIConfig(UIConfiguration uiConfig) {
            this.uiConfig = uiConfig;
        }

        public UIConfiguration getUIConfig() {
            return this.uiConfig;
        }

        public void setProfiles(Vector profiles) {
            this.profiles = profiles;
        }

        public Vector getProfiles() {
            return this.profiles;
        }

        public NamedAdapterConfig getDefaultConfig() {
            return this.defaultConfig;
        }

        public void setDefaultConfig(NamedAdapterConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
        }
    }

    protected class NamedConfigEditor
    extends BasicComboBoxEditor {
        protected Object oldValue;

        protected NamedConfigEditor() {
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null && anObject instanceof NamedAdapterConfig) {
                NamedAdapterConfig nc = (NamedAdapterConfig)anObject;
                this.editor.setText(nc.getName());
                this.oldValue = anObject;
            } else {
                this.editor.setText("");
            }
        }

        @Override
        public Object getItem() {
            NamedAdapterConfig nc = (NamedAdapterConfig)this.oldValue;
            nc.setName(this.editor.getText());
            return nc;
        }
    }

    protected class AdapterListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 6595990724197125690L;

        protected AdapterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DataAdapter) {
                String name = ((DataAdapter)value).getName();
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

