/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression;

import java.io.StringReader;
import org.apache.log4j.Logger;
import org.bbop.expression.Expression;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.ExpressionImpl;
import org.bbop.expression.parser.ASTExpressionExpression;
import org.bbop.expression.parser.ASTForeachStatement;
import org.bbop.expression.parser.ASTIfStatement;
import org.bbop.expression.parser.ASTReferenceExpression;
import org.bbop.expression.parser.ASTStatementExpression;
import org.bbop.expression.parser.ASTWhileStatement;
import org.bbop.expression.parser.ParseException;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.parser.TokenMgrError;

public class ExpressionFactory {
    protected static final Logger logger = Logger.getLogger(ExpressionFactory.class);
    protected static Parser parser = new Parser(new StringReader(";"));
    protected static ExpressionFactory ef = new ExpressionFactory();

    private ExpressionFactory() {
    }

    protected static ExpressionFactory getInstance() {
        return ef;
    }

    public static Expression createExpression(String expression) throws Exception {
        return ExpressionFactory.getInstance().createNewExpression(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression createNewExpression(String expression) throws ExpressionException {
        SimpleNode tree;
        String expr = this.cleanExpression(expression);
        Parser parser = ExpressionFactory.parser;
        synchronized (parser) {
            try {
                tree = ExpressionFactory.parser.parse(new StringReader(expr));
            }
            catch (TokenMgrError tme) {
                throw new ParseException(tme.getMessage());
            }
            catch (Exception e) {
                throw new ExpressionException(e);
            }
        }
        SimpleNode node = (SimpleNode)tree.jjtGetChild(0);
        if (node instanceof ASTReferenceExpression || node instanceof ASTExpressionExpression || node instanceof ASTStatementExpression || node instanceof ASTIfStatement || node instanceof ASTWhileStatement || node instanceof ASTForeachStatement) {
            return new ExpressionImpl(expression, node);
        }
        throw new ExpressionException("Invalid Expression: not a Reference, Expression, Statement or If");
    }

    private String cleanExpression(String expression) {
        String expr = expression.trim();
        if (!expr.endsWith(";")) {
            expr = expr + ";";
        }
        return expr;
    }
}

