/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression;

import java.util.ArrayList;
import java.util.List;
import org.bbop.expression.Expression;
import org.bbop.expression.JexlContext;
import org.bbop.expression.JexlExprResolver;
import org.bbop.expression.parser.SimpleNode;

class ExpressionImpl
implements Expression {
    protected List preResolvers;
    protected List postResolvers;
    protected String expression;
    protected SimpleNode node;

    ExpressionImpl(String expr, SimpleNode ref) {
        this.expression = expr;
        this.node = ref;
    }

    @Override
    public Object evaluate(JexlContext context) throws Exception {
        Object val = null;
        if (this.preResolvers != null && (val = this.tryResolver(this.preResolvers, context)) != JexlExprResolver.NO_VALUE) {
            return val;
        }
        val = this.node.value(context);
        if (val == null && this.postResolvers != null && (val = this.tryResolver(this.postResolvers, context)) != JexlExprResolver.NO_VALUE) {
            return val;
        }
        return val;
    }

    protected Object tryResolver(List resolverList, JexlContext context) {
        Object val = JexlExprResolver.NO_VALUE;
        String expr = this.getExpression();
        for (int i = 0; i < resolverList.size(); ++i) {
            JexlExprResolver jer = (JexlExprResolver)resolverList.get(i);
            val = jer.evaluate(context, expr);
            if (val == JexlExprResolver.NO_VALUE) continue;
            return val;
        }
        return val;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void addPreResolver(JexlExprResolver resolver) {
        if (this.preResolvers == null) {
            this.preResolvers = new ArrayList();
        }
        this.preResolvers.add(resolver);
    }

    @Override
    public void addPostResolver(JexlExprResolver resolver) {
        if (this.postResolvers == null) {
            this.postResolvers = new ArrayList();
        }
        this.postResolvers.add(resolver);
    }

    public String toString() {
        String expr = this.getExpression();
        return expr == null ? "" : expr;
    }
}

