/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression;

import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.JexlContext;
import org.bbop.expression.JexlFunctionDef;
import org.bbop.expression.parser.BindException;
import org.bbop.expression.parser.SimpleNode;

public class JexlFunctionDefImpl
implements JexlFunctionDef {
    protected static final Logger logger = Logger.getLogger(JexlFunctionDefImpl.class);
    protected String name;
    protected List varNames;
    protected SimpleNode node;
    protected boolean isExtended;
    protected int lineNum;

    public JexlFunctionDefImpl(String name, SimpleNode node, List varNames, boolean isExtended) {
        this.name = name;
        this.node = node;
        this.varNames = varNames;
        this.isExtended = isExtended;
    }

    @Override
    public SimpleNode getNode() {
        return this.node;
    }

    @Override
    public List getVarNames() {
        return this.varNames;
    }

    @Override
    public boolean isExtendedParam() {
        return this.isExtended;
    }

    @Override
    public Object execute(JexlContext jc, Object[] params, SimpleNode callNode) throws Exception {
        JexlContext newFrame = jc.createNewFrame();
        if (this.isExtended) {
            try {
                newFrame.setLocalVariable((String)this.getVarNames().get(0), params, true);
            }
            catch (ExpressionException ex) {
                ex.decorateException(this.node);
            }
        } else {
            if (params.length > this.getVarNames().size()) {
                throw new BindException("Too many arguments for function " + this.name, callNode.getLineNum(), callNode.getCharNum());
            }
            for (int i = 0; i < this.getVarNames().size(); ++i) {
                newFrame.setLocalVariable((String)this.getVarNames().get(i), params[i], true);
            }
        }
        return this.getNode().value(newFrame);
    }
}

