/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.Script;
import org.bbop.expression.ScriptImpl;
import org.bbop.expression.parser.ASTJexlScript;
import org.bbop.expression.parser.ParseException;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.parser.TokenMgrError;

public class ScriptFactory {
    protected static final Logger logger = Logger.getLogger(ScriptFactory.class);
    protected static Parser parser = new Parser(new StringReader(";"));
    protected static ScriptFactory factory = new ScriptFactory();

    private ScriptFactory() {
    }

    protected static ScriptFactory getInstance() {
        return factory;
    }

    public static Script createScript(String scriptText) throws ExpressionException {
        return ScriptFactory.getInstance().createNewScript(scriptText);
    }

    public static Script createScript(File scriptFile) throws ExpressionException, IOException {
        if (scriptFile == null) {
            throw new NullPointerException("scriptFile is null");
        }
        if (!scriptFile.canRead()) {
            throw new IOException("Can't read scriptFile (" + scriptFile.getCanonicalPath() + ")");
        }
        BufferedReader reader = new BufferedReader(new FileReader(scriptFile));
        return ScriptFactory.createScript(ScriptFactory.readerToString(reader));
    }

    public static Script createScript(URL scriptUrl) throws ExpressionException, IOException {
        if (scriptUrl == null) {
            throw new NullPointerException("scriptUrl is null");
        }
        URLConnection connection = scriptUrl.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        return ScriptFactory.createScript(ScriptFactory.readerToString(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Script createNewScript(String scriptText) throws ExpressionException {
        SimpleNode script;
        String cleanText = this.cleanScript(scriptText);
        Parser parser = ScriptFactory.parser;
        synchronized (parser) {
            try {
                script = ScriptFactory.parser.parse(new StringReader(cleanText));
            }
            catch (TokenMgrError tme) {
                throw new ParseException(tme.getMessage());
            }
            catch (Exception ex) {
                throw new ExpressionException(ex);
            }
        }
        if (script instanceof ASTJexlScript) {
            return new ScriptImpl(cleanText, (ASTJexlScript)script);
        }
        throw new IllegalStateException("Parsed script is not an ASTJexlScript");
    }

    private String cleanScript(String script) {
        String expr = script.trim();
        if (!expr.endsWith(";")) {
            expr = expr + ";";
        }
        return expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readerToString(BufferedReader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }
}

