/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import org.apache.log4j.Logger;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.util.Coercion;

public class ASTEQNode
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTEQNode.class);

    public ASTEQNode(int id) {
        super(id);
    }

    public ASTEQNode(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object value(JexlContext pc) throws Exception {
        Object left = ((SimpleNode)this.jjtGetChild(0)).value(pc);
        Object right = ((SimpleNode)this.jjtGetChild(1)).value(pc);
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        if (left.getClass().equals(right.getClass())) {
            return left.equals(right) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            Double r;
            Double l = Coercion.coerceDouble(left);
            return l.equals(r = Coercion.coerceDouble(right)) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (left instanceof Number || right instanceof Number || left instanceof Character || right instanceof Character) {
            return Coercion.coerceLong(left).equals(Coercion.coerceLong(right)) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (left instanceof Boolean || right instanceof Boolean) {
            return Coercion.coerceBoolean(left).equals(Coercion.coerceBoolean(right)) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (left instanceof String || right instanceof String) {
            return left.toString().equals(right.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return left.equals(right) ? Boolean.TRUE : Boolean.FALSE;
    }
}

