/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.ASTReference;
import org.bbop.expression.parser.BreakLoopException;
import org.bbop.expression.parser.ParseException;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.util.Introspector;
import org.bbop.expression.util.introspection.Info;

public class ASTForeachStatement
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTForeachStatement.class);
    private static final Info DUMMY = new Info("", 1, 1);
    private static final int VAR_INDEX = 0;
    private static final int ITEMS_INDEX = 1;
    private static final int STATEMENT_INDEX = 2;

    public ASTForeachStatement(int id) {
        super(id);
    }

    public ASTForeachStatement(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object value(JexlContext jc) throws Exception {
        Object result = null;
        ASTReference loopVariable = (ASTReference)this.jjtGetChild(0);
        SimpleNode iterable = (SimpleNode)this.jjtGetChild(1);
        Object iterableValue = iterable.value(jc);
        if (iterableValue != null && this.jjtGetNumChildren() >= 3) {
            SimpleNode statement = (SimpleNode)this.jjtGetChild(2);
            Iterator itemsIterator = Introspector.getUberspect().getIterator(iterableValue, DUMMY);
            while (itemsIterator.hasNext()) {
                Object value = itemsIterator.next();
                try {
                    jc.setLocalVariable(loopVariable.getRootString(), value, true);
                }
                catch (ParseException ex) {
                    ex.decorateException(this);
                }
                try {
                    result = statement.value(jc);
                }
                catch (BreakLoopException ex) {
                    return null;
                }
            }
        }
        return result;
    }
}

