/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.expression.JexlContext;
import org.bbop.expression.JexlFunctionDefImpl;
import org.bbop.expression.parser.ASTBlock;
import org.bbop.expression.parser.ASTExtendedParamIdentifier;
import org.bbop.expression.parser.ASTGlobalTag;
import org.bbop.expression.parser.ASTIdentifier;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.SimpleNode;

public class ASTFunctionDefinition
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTFunctionDefinition.class);

    public ASTFunctionDefinition(int i) {
        super(i);
    }

    public ASTFunctionDefinition(Parser p, int i) {
        super(p, i);
    }

    @Override
    public Object value(JexlContext jc) throws Exception {
        int nameIndex = 0;
        boolean isGlobal = false;
        if (this.jjtGetChild(0) instanceof ASTGlobalTag) {
            nameIndex = 1;
            isGlobal = true;
        }
        String methodName = ((ASTIdentifier)this.jjtGetChild((int)nameIndex)).val;
        ASTBlock body = (ASTBlock)this.jjtGetChild(this.jjtGetNumChildren() - 1);
        LinkedList<Object> varNames = new LinkedList<Object>();
        int paramCount = this.jjtGetNumChildren() - (2 + nameIndex);
        boolean isExtended = false;
        for (int i = 0; i < paramCount; ++i) {
            SimpleNode node = (SimpleNode)this.jjtGetChild(i + nameIndex + 1);
            if (node instanceof ASTIdentifier) {
                varNames.add(((ASTIdentifier)this.jjtGetChild((int)(i + nameIndex + 1))).val);
                continue;
            }
            if (!(node instanceof ASTExtendedParamIdentifier)) continue;
            varNames.add(((ASTExtendedParamIdentifier)this.jjtGetChild(i + nameIndex + 1)).value(jc));
            isExtended = true;
        }
        JexlFunctionDefImpl def = new JexlFunctionDefImpl(methodName, body, varNames, isExtended);
        if (isGlobal) {
            jc.defineGlobalFunction(methodName, def);
        } else {
            this.getEnclosingScript().defineLocalFunction(jc, methodName, def);
        }
        return null;
    }
}

