/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.ASTIdentifier;
import org.bbop.expression.parser.ASTReference;
import org.bbop.expression.parser.ParseException;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.util.Coercion;

public class ASTPostDecrementNode
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTPostDecrementNode.class);

    public ASTPostDecrementNode(int id) {
        super(id);
    }

    public ASTPostDecrementNode(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object value(JexlContext context) throws Exception {
        SimpleNode left = (SimpleNode)this.jjtGetChild(0);
        Integer val = null;
        try {
            val = Coercion.coerceInteger(left.value(context));
        }
        catch (Exception ex) {
            throw new ParseException("Can't use decrement operator on non-integer");
        }
        ASTReference reference = (ASTReference)this.jjtGetChild(0);
        left = (SimpleNode)reference.jjtGetChild(0);
        if (left instanceof ASTIdentifier) {
            String identifier = ((ASTIdentifier)left).getIdentifierString();
            try {
                context.setVariable(identifier, new Integer(val - 1));
            }
            catch (ExpressionException ex) {
                ex.decorateException(this);
            }
        }
        return val;
    }
}

