/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.ASTIdentifier;
import org.bbop.expression.parser.ASTReference;
import org.bbop.expression.parser.ParseException;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.util.Coercion;

public class ASTPreIncrementNode
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTPreIncrementNode.class);

    public ASTPreIncrementNode(int id) {
        super(id);
    }

    public ASTPreIncrementNode(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object value(JexlContext context) throws Exception {
        SimpleNode left = (SimpleNode)this.jjtGetChild(0);
        Integer val = null;
        try {
            val = new Integer(Coercion.coerceInteger(left.value(context)) + 1);
        }
        catch (Exception ex) {
            throw new ParseException("Can't use increment operator on non-integer");
        }
        ASTReference reference = (ASTReference)this.jjtGetChild(0);
        left = (SimpleNode)reference.jjtGetChild(0);
        if (left instanceof ASTIdentifier) {
            String identifier = ((ASTIdentifier)left).getIdentifierString();
            try {
                context.setVariable(identifier, val);
            }
            catch (ExpressionException ex) {
                ex.decorateException(this);
            }
        }
        return val;
    }
}

