/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ArrayIterator
implements Iterator {
    protected static final Logger logger = Logger.getLogger(ArrayIterator.class);
    private final Object array;
    private int pos;
    private final int size;

    public ArrayIterator(Object arr) {
        if (!arr.getClass().isArray()) {
            throw new IllegalArgumentException("Programmer error : internal ArrayIterator invoked w/o array");
        }
        this.array = arr;
        this.pos = 0;
        this.size = Array.getLength(this.array);
    }

    public Object next() {
        if (this.pos < this.size) {
            return Array.get(this.array, this.pos++);
        }
        throw new NoSuchElementException("No more elements: " + this.pos + " / " + this.size);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.size;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

