/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.framework.AbstractSingleActionTask;
import org.bbop.framework.ComponentManager;
import org.bbop.framework.GUIComponentFactory;
import org.bbop.framework.GUIManager;
import org.bbop.framework.GUITask;
import org.bbop.framework.IOManager;
import org.bbop.framework.MainFrame;
import org.bbop.framework.PluginManager;
import org.bbop.framework.VetoableShutdownListener;
import org.bbop.framework.ViewMenu;
import org.bbop.framework.dock.LayoutDriver;
import org.bbop.framework.dock.idw.IDWDriver;
import org.bbop.swing.SwingUtil;
import org.bbop.util.CollectionUtil;
import org.bbop.util.ExceptionLogger;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;

public abstract class AbstractApplicationStartupTask
extends AbstractSingleActionTask {
    protected VetoableShutdownListener vetoableShutdownListener = new VetoableShutdownListener(){

        @Override
        public boolean willShutdown() {
            GUIManager.getManager();
            if (GUIManager.getManager().getFrame() != null && GUIManager.isConfirmOnExit()) {
                return JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), "Really quit?", "Exit?", 0) == 0;
            }
            return true;
        }
    };
    private int[][] dimensionInfo = new int[][]{{620, 460, 160}, {760, 560, 300}, {960, 700, 400}};

    protected abstract String getPerspectiveResourceDir();

    protected abstract Collection<GUITask> getDefaultTasks();

    protected abstract Collection<DataAdapter> getDefaultDataAdapters();

    protected abstract Collection<GUIComponentFactory<?>> getDefaultComponentFactories();

    protected abstract String getAppID();

    protected abstract String getAppName();

    protected File getPrefsDir() {
        return new File(System.getProperty("user.home") + File.separator + this.getAppID());
    }

    protected String getDefaultPerspectiveResourcePath() {
        if (this.getPerspectiveResourceDir() != null) {
            return this.getPerspectiveResourceDir() + File.separator + "default.idw";
        }
        return null;
    }

    protected String getPerspectiveListResourcePath() {
        if (this.getPerspectiveResourceDir() != null) {
            return this.getPerspectiveResourceDir() + File.separator + "perspectives.xml";
        }
        return null;
    }

    protected Action getOpenFileAction(String filename) {
        return null;
    }

    protected Action getAboutAction() {
        return null;
    }

    protected Action getExitAction() {
        return null;
    }

    protected Action getPreferencesAction() {
        return null;
    }

    @Override
    public void run() {
        GUIManager.setPrefsDir(this.getPrefsDir());
        PluginManager.getManager().setPluginDirs(this.getPluginDirs());
        this.configureLogging();
        this.installPlugins();
        this.configureUI();
        this.configureSystem();
        GUIManager.getManager().setFrame(this.createFrame());
        this.doPreInstallation();
        this.installSystemListeners();
        this.installDefaultDataAdapters();
        this.installDefaultComponentFactories();
        this.installDefaultTasks();
        this.installMenus();
        this.installDefaultToolBars();
        this.doOtherInstallations();
        ComponentManager.getManager().setDriver(this.createLayoutDriver());
        this.showFrame();
    }

    protected void configureSystem() {
        DefaultApplication application = new DefaultApplication();
        application.setEnabledAboutMenu(this.getAboutAction() != null);
        application.setEnabledPreferencesMenu(this.getPreferencesAction() != null);
        application.addApplicationListener((ApplicationListener)new MacApplicationSupport());
    }

    protected void installSystemListeners() {
        GUIManager.addVetoableShutdownListener(this.vetoableShutdownListener);
    }

    protected void doPreInstallation() {
    }

    protected void installDefaultTasks() {
        for (GUITask task : this.getDefaultTasks()) {
            this.getManager().installTask(task);
        }
    }

    protected void installDefaultComponentFactories() {
        for (GUIComponentFactory<?> factory : this.getDefaultComponentFactories()) {
            ComponentManager.getManager().install(factory);
        }
    }

    protected void installMenus() {
        for (JMenuItem jMenuItem : this.getDefaultMenus()) {
            GUIManager.getManager().installMenuItem(null, jMenuItem);
        }
    }

    protected void installDefaultToolBars() {
        for (JToolBar toolbar : this.getDefaultToolBars()) {
            GUIManager.getManager().installToolBar(toolbar);
        }
    }

    protected Collection<? extends JMenuItem> getDefaultMenus() {
        return CollectionUtil.list(new ViewMenu());
    }

    protected Collection<JToolBar> getDefaultToolBars() {
        return null;
    }

    protected void installDefaultDataAdapters() {
        for (DataAdapter adapter : this.getDefaultDataAdapters()) {
            IOManager.getManager().getAdapterRegistry().addAdapter(adapter);
        }
    }

    protected void doOtherInstallations() {
    }

    protected Color getLightColor() {
        return null;
    }

    protected Font getFont() {
        return null;
    }

    protected LayoutDriver createLayoutDriver() {
        IDWDriver driver = new IDWDriver();
        driver.setDefaultPerspectiveResourcePath(this.getDefaultPerspectiveResourcePath());
        driver.setPerspectiveResourceDir(this.getPerspectiveResourceDir());
        driver.setPerspectiveListResourcePath(this.getPerspectiveListResourcePath());
        if (this.getBackgroundColor() != null) {
            driver.setBackground(this.getBackgroundColor());
        }
        if (this.getButtonColor() != null) {
            driver.setDarkColor(this.getButtonColor());
        }
        if (this.getLightColor() != null) {
            driver.setLightColor(this.getLightColor());
        }
        if (this.getFont() != null) {
            driver.setFont(this.getFont());
        }
        return driver;
    }

    protected void showFrame() {
        JFrame frame = this.getManager().getFrame();
        frame.setVisible(true);
        SwingUtil.center(frame);
    }

    protected JFrame createFrame() {
        MainFrame out = new MainFrame(this.getAppID());
        out.setTitle(this.getAppName());
        return out;
    }

    protected Color getButtonColor() {
        return null;
    }

    protected Color getBackgroundColor() {
        return null;
    }

    protected void configureUI() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (!lf.getName().startsWith("Mac OS X Aqua")) {
            if (this.getButtonColor() != null) {
                UIManager.put("ComboBox.selectionBackground", this.getButtonColor());
                UIManager.put("ComboBox.buttonBackground", this.getButtonColor());
                UIManager.put("Button.background", this.getButtonColor());
                UIManager.put("ToggleButton.background", this.getButtonColor());
            }
            if (this.getBackgroundColor() != null) {
                UIManager.put("Panel.background", this.getBackgroundColor());
                UIManager.put("Label.background", this.getBackgroundColor());
                UIManager.put("OptionPane.background", this.getBackgroundColor());
                UIManager.put("ScrollPane.background", this.getBackgroundColor());
                UIManager.put("SplitPane.background", this.getBackgroundColor());
                UIManager.put("TabbedPane.background", this.getBackgroundColor());
                UIManager.put("ToolBar.background", this.getBackgroundColor());
                UIManager.put("ToolBar.dockingBackground", this.getBackgroundColor());
                UIManager.put("ToolBar.floatingBackground", this.getBackgroundColor());
                UIManager.put("ToolBar.viewportBackground", this.getBackgroundColor());
            }
        }
    }

    protected void installPlugins() {
        for (GUITask task : PluginManager.getManager().instantiateAll(GUITask.class)) {
            GUIManager.getManager().addStartupTask(task);
        }
        for (GUIComponentFactory factory : PluginManager.getManager().instantiateAll(GUIComponentFactory.class)) {
            ComponentManager.getManager().install(factory);
        }
        if (IOManager.getManager().getAdapterRegistry() != null) {
            for (DataAdapter adapter : PluginManager.getManager().instantiateAll(DataAdapter.class)) {
                IOManager.getManager().getAdapterRegistry().addAdapter(adapter);
            }
        }
    }

    protected File[] getPluginDirs() {
        File[] out = new File[]{new File(GUIManager.getPrefsDir(), "extensions")};
        return out;
    }

    protected void configureLogging() {
        Logger logger = Logger.getLogger((String)"");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Logger global = Logger.getLogger((String)"");
                global.log((Priority)Level.FATAL, (Object)"Uncaught event dispatch exception", e);
            }
        });
        System.setProperty("sun.awt.exception.handler", ExceptionLogger.class.getName());
        logger.info((Object)"Configured final exception handlers");
    }

    public class MacApplicationSupport
    implements ApplicationListener {
        private Application application = new DefaultApplication();

        public void handleAbout(ApplicationEvent event) {
            Action aboutAction = AbstractApplicationStartupTask.this.getAboutAction();
            if (aboutAction != null) {
                aboutAction.actionPerformed(new ActionEvent(event.getSource(), 0, "about"));
                event.setHandled(true);
            }
        }

        public void handleQuit(ApplicationEvent event) {
            Action exitAction = AbstractApplicationStartupTask.this.getExitAction();
            if (exitAction != null) {
                exitAction.actionPerformed(new ActionEvent(event.getSource(), 0, "exit"));
            } else {
                GUIManager.exit(0);
            }
        }

        public void handleOpenApplication(ApplicationEvent event) {
        }

        public void handleOpenFile(ApplicationEvent event) {
            Action openAction = AbstractApplicationStartupTask.this.getOpenFileAction(event.getFilename());
            if (openAction != null) {
                openAction.actionPerformed(new ActionEvent(event.getSource(), 0, "openFile"));
                event.setHandled(true);
            }
        }

        public void handlePreferences(ApplicationEvent event) {
            Action prefsAction = AbstractApplicationStartupTask.this.getPreferencesAction();
            if (prefsAction != null) {
                prefsAction.actionPerformed(new ActionEvent(event.getSource(), 0, "about"));
                event.setHandled(true);
            }
        }

        public void handlePrintFile(ApplicationEvent event) {
        }

        public void handleReopenApplication(ApplicationEvent event) {
        }
    }
}

