/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.bbop.framework.GUIComponent;
import org.bbop.framework.GUIComponentFactory;

public abstract class AbstractComponentFactory<T extends GUIComponent>
implements GUIComponentFactory<T> {
    @Override
    public T createComponent(String id) {
        T out = this.doCreateComponent(id);
        out.setTitle(this.getName());
        return out;
    }

    public abstract T doCreateComponent(String var1);

    @Override
    public boolean getPreferSeparateWindow() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public boolean showInMenus() {
        return true;
    }

    @Override
    public boolean isRestoreOnStartup() {
        return true;
    }

    @Override
    public String getHelpTopicID() {
        return null;
    }

    protected class MessageAction
    extends AbstractAction {
        private Component parentComponent;
        private String message;
        private String name;

        public MessageAction(Component parentComponent, String name, Icon icon, String message) {
            super(name, icon);
            this.message = message;
            this.name = name;
            this.parentComponent = parentComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(this.parentComponent, this.message, this.name, 1);
        }
    }
}

