/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.awt.Color;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.framework.ComponentConfiguration;
import org.bbop.framework.GUIComponent;
import org.bbop.framework.GUIComponentFactory;
import org.bbop.framework.GUIManager;
import org.bbop.framework.dock.LayoutDriver;
import org.bbop.framework.dock.LayoutListener;
import org.bbop.framework.dock.Perspective;
import org.bbop.framework.dock.idw.IDWDriver;
import org.bbop.framework.event.GUIComponentEvent;
import org.bbop.framework.event.GUIComponentListener;

public class ComponentManager {
    protected static final Logger logger = Logger.getLogger(ComponentManager.class);
    protected static ComponentManager manager;
    protected static File prefsPath;
    protected Map<String, GUIComponentFactory> factoryMap = new LinkedHashMap<String, GUIComponentFactory>();
    protected Map<String, List<GUIComponent>> currentConfig = new HashMap<String, List<GUIComponent>>();
    protected Map<GUIComponent, GUIComponentFactory> componentToFactoryMap = new HashMap<GUIComponent, GUIComponentFactory>();
    public Map<String, GUIComponent> activeComponents = new HashMap<String, GUIComponent>();
    protected List<GUIComponentListener> componentListeners = new LinkedList<GUIComponentListener>();
    protected static final String DEFAULT_COMPONENT_ID_SUFFIX = "main";
    protected static int idgen;
    protected LayoutDriver driver;

    public void addComponentListener(GUIComponentListener listener) {
        this.componentListeners.add(listener);
    }

    public void removeComponentListener(GUIComponentListener listener) {
        this.componentListeners.remove(listener);
    }

    public void setDriver(LayoutDriver driver) {
        if (this.driver != null) {
            this.driver.cleanup();
        }
        this.driver = driver;
        driver.init();
    }

    public LayoutDriver getDriver() {
        if (this.driver == null) {
            this.setDriver(new IDWDriver());
        }
        return this.driver;
    }

    public static ComponentManager getManager() {
        if (manager == null) {
            manager = new ComponentManager();
            GUIManager.addShutdownHook(new Runnable(){

                @Override
                public void run() {
                    manager.cleanup();
                }
            });
        }
        return manager;
    }

    protected void cleanup() {
        if (manager.getDriver() != null) {
            manager.getDriver().cleanup();
        }
        LinkedList<String> keys = new LinkedList<String>(this.activeComponents.keySet());
        for (String id : keys) {
            GUIComponent c = this.activeComponents.get(id);
            this.removeActiveComponent(c);
        }
    }

    public void addLayoutListener(LayoutListener listener) {
        this.driver.addLayoutListener(listener);
    }

    public void removeLayoutListener(LayoutListener listener) {
        this.driver.removeLayoutListener(listener);
    }

    public Perspective getPerspective(String name) {
        return this.driver.getPerspective(name);
    }

    public void setPerspective(String name) {
        Perspective p = this.getPerspective(name);
        if (p != null) {
            this.setPerspective(p);
        }
    }

    public void setPerspective(Perspective perspective) {
        this.driver.setPerspective(perspective);
    }

    public List<Perspective> getPerspectives() {
        return this.driver.getPerspectives();
    }

    public Perspective getCurrentPerspective() {
        return this.driver.getCurrentPerspective();
    }

    public void deletePerspective(Perspective p) {
        this.driver.deletePerspective(p);
        this.driver.savePerspectives();
    }

    public void savePerspectiveAs(Perspective p, String name) {
        this.driver.savePerspectiveAs(p, name);
        this.driver.savePerspectives();
    }

    public void importPerspective(File file) {
        this.driver.importPerspective(file);
        this.driver.savePerspectives();
    }

    public String showComponent(GUIComponentFactory factory, boolean showInNewWindow) {
        return this.showComponent(factory, null, null, showInNewWindow);
    }

    public String showComponent(GUIComponentFactory factory, GUIComponent target) {
        return this.showComponent(factory, target, null, false);
    }

    public String showComponent(GUIComponentFactory factory, GUIComponent target, boolean showInNewWindow) {
        return this.showComponent(factory, target, null, showInNewWindow);
    }

    public String showComponent(GUIComponentFactory factory, GUIComponent target, String label, boolean showInNewWindow) {
        if (factory.isSingleton()) {
            for (GUIComponent component : this.getActiveComponents()) {
                if (this.getFactory(component) == null) {
                    String m = "Cant find factory for " + component;
                    logger.fatal((Object)m);
                    System.out.println(m);
                    return null;
                }
                if (!this.getFactory(component).equals(factory)) continue;
                this.focusComponent(component);
                return component.getID();
            }
        }
        return this.getDriver().showComponent(factory, target, null, label, factory.getPreferSeparateWindow() || showInNewWindow, null);
    }

    public void focusComponent(GUIComponent component) {
        this.getDriver().restoreComponent(component);
        this.getDriver().focusComponent(component);
    }

    public static File getPrefsPath() {
        if (prefsPath == null) {
            prefsPath = new File(GUIManager.getPrefsDir(), "components.prefs.xml");
        }
        return prefsPath;
    }

    public static Map<String, List<ComponentConfiguration>> getConfigurationMap(File file) {
        try {
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(ComponentManager.getPrefsPath())));
            Map out = (Map)decoder.readObject();
            decoder.close();
            return out;
        }
        catch (Exception ex) {
            return new HashMap<String, List<ComponentConfiguration>>();
        }
    }

    public boolean isFloating(GUIComponent c) {
        return this.driver.isFloating(c);
    }

    public void setFloating(GUIComponent c, boolean floating) {
        this.driver.setFloating(c, floating);
    }

    public void setLabel(GUIComponent c, String label) {
        this.driver.setComponentLabel(c, label);
    }

    public String getLabel(GUIComponent c) {
        return this.driver.getComponentLabel(c);
    }

    public void setTitlebarTooltip(GUIComponent c, String tooltip) {
        this.driver.setComponentTitlebarTooltip(c, tooltip);
    }

    public String getTitlebarTooltip(GUIComponent c) {
        return this.driver.getComponentLabel(c);
    }

    public void setTitlebarColor(GUIComponent c, Color color) {
        this.driver.setComponentTitlebarColor(c, color);
    }

    public Color getTitlebarColor(GUIComponent c) {
        return this.driver.getComponentTitlebarColor(c);
    }

    public void resetCurrentConfigurationMap() {
        this.currentConfig = new HashMap<String, List<GUIComponent>>();
        this.componentToFactoryMap = new HashMap<GUIComponent, GUIComponentFactory>();
    }

    public Map<String, List<ComponentConfiguration>> getCurrentConfigurationMap() {
        HashMap<String, List<ComponentConfiguration>> out = new HashMap<String, List<ComponentConfiguration>>();
        for (String factoryID : this.currentConfig.keySet()) {
            List<GUIComponent> l = this.currentConfig.get(factoryID);
            if (l == null) continue;
            LinkedList<ComponentConfiguration> configList = new LinkedList<ComponentConfiguration>();
            for (GUIComponent c : l) {
                configList.add(c.getConfiguration());
            }
            out.put(factoryID, configList);
        }
        return out;
    }

    public void install(GUIComponentFactory<?> factory) {
        this.factoryMap.put(factory.getID(), factory);
    }

    public void uninstall(GUIComponentFactory<?> factory) {
        this.factoryMap.remove(factory.getID());
    }

    public GUIComponent createComponent(String factoryID, String componentID) {
        GUIComponentFactory factory = this.factoryMap.get(factoryID);
        if (factory != null) {
            return this.createComponent(factory, componentID);
        }
        return null;
    }

    public GUIComponent createComponent(GUIComponentFactory<?> factory, String componentID) {
        if (componentID == null) {
            componentID = factory.getID() + ":" + DEFAULT_COMPONENT_ID_SUFFIX;
        }
        if (componentID != null && this.getActiveComponent(componentID) != null) {
            componentID = null;
        }
        if (componentID == null) {
            int idgen = 1;
            while (this.getActiveComponent(componentID = factory.getID() + ":" + idgen++) != null) {
            }
        }
        Object c = factory.createComponent(componentID);
        return c;
    }

    public void destroyComponent(GUIComponent c) {
        GUIComponentFactory factory = this.componentToFactoryMap.get(c);
        if (factory != null) {
            List<GUIComponent> l = this.currentConfig.get(factory.getID());
            if (l != null) {
                l.remove(c);
            }
            l.add(c);
            this.componentToFactoryMap.remove(c);
        }
    }

    public Collection<GUIComponentFactory<?>> getFactories() {
        LinkedHashSet out = new LinkedHashSet(this.factoryMap.values());
        return out;
    }

    public Map<String, GUIComponent> getActiveComponentMap() {
        return this.activeComponents;
    }

    public Collection<GUIComponent> getActiveComponents() {
        return this.activeComponents.values();
    }

    public void clearActiveComponents() {
        LinkedList<String> it = new LinkedList<String>(this.activeComponents.keySet());
        for (String id : it) {
            GUIComponent c = this.activeComponents.get(id);
            c.cleanup();
            this.activeComponents.remove(id);
        }
    }

    protected static File getFile(GUIComponent comp) {
        File compPrefsDir = new File(GUIManager.getPrefsDir(), "component_prefs");
        compPrefsDir.mkdirs();
        File f = new File(compPrefsDir, comp.getID());
        return f;
    }

    public void addActiveComponent(GUIComponent comp) {
        this.activeComponents.put(comp.getID(), comp);
        ComponentConfiguration config = comp.getConfiguration();
        File f = ComponentManager.getFile(comp);
        if (f.exists()) {
            try {
                XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(f)));
                config = (ComponentConfiguration)decoder.readObject();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        comp.setConfiguration(config);
        comp.init();
        for (GUIComponentListener listener : this.componentListeners) {
            listener.componentShown(new GUIComponentEvent(this, comp, true, false));
        }
    }

    public void removeActiveComponent(GUIComponent comp) {
        this.activeComponents.remove(comp.getID());
        for (GUIComponentListener listener : this.componentListeners) {
            listener.componentHidden(new GUIComponentEvent(this, comp, false, true));
        }
        File f = ComponentManager.getFile(comp);
        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(f)));
            encoder.writeObject(comp.getConfiguration());
            encoder.close();
        }
        catch (IOException ex) {
            logger.info((Object)"Couldn't flush component config successfully");
        }
        comp.cleanup();
    }

    public GUIComponent getActiveComponent(String id) {
        return this.activeComponents.get(id);
    }

    public static File getComponentConfigDir() {
        return new File(GUIManager.getPrefsDir(), "component_prefs");
    }

    public static String getFactoryID(String componentID) {
        int endIndex = componentID.indexOf(58);
        if (endIndex > 0) {
            return componentID.substring(0, endIndex);
        }
        return componentID;
    }

    public static String getIDSuffix(String componentID) {
        int endIndex = componentID.indexOf(58);
        if (endIndex > 0) {
            return componentID.substring(endIndex + 1, componentID.length());
        }
        return "";
    }

    public GUIComponentFactory getFactory(String id) {
        return this.factoryMap.get(id);
    }

    public GUIComponentFactory getFactory(GUIComponent c) {
        String factoryID = ComponentManager.getFactoryID(c.getID());
        return this.factoryMap.get(factoryID);
    }

    static {
        idgen = 0;
    }
}

