/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.bbop.framework.ComponentManager;
import org.bbop.framework.GUITask;
import org.bbop.framework.VetoableShutdownListener;
import org.bbop.framework.event.UserEvent;
import org.bbop.framework.event.UserListener;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.swing.ComponentPath;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.bbop.util.TaskDelegate;

public class GUIManager {
    protected static final Logger logger = Logger.getLogger(GUIManager.class);
    protected static GUIManager manager;
    protected static final String PREFS_DIR_PROPERTY = "prefsdir";
    protected BackgroundEventQueue screenLockQueue;
    protected BackgroundEventQueue backgroundQueue;
    protected JFrame frame;
    protected boolean started = false;
    protected List<GUITask> activeTasks = new ArrayList<GUITask>();
    protected LinkedList<GUITask> startupTasks = new LinkedList();
    protected static List<Runnable> hooks;
    protected static List<VetoableShutdownListener> shutdownListeners;
    protected MultiMap<String, UserListener> userListeners = new MultiHashMap<String, UserListener>();
    protected static boolean confirmOnExit;
    protected static boolean advxpMatrixEditorCheckBox;
    protected static boolean advIntersectionEditorCheckBox;
    protected static boolean advSemanticParserCheckBox;
    protected static File prefsDir;
    protected boolean lockDoc = false;
    protected boolean OTElock = false;

    public BackgroundEventQueue getScreenLockQueue() {
        return this.screenLockQueue;
    }

    public BackgroundEventQueue getBackgroundQueue() {
        return this.backgroundQueue;
    }

    public static void addVetoableShutdownListener(VetoableShutdownListener listener) {
        shutdownListeners.add(listener);
    }

    public static void removeVetoableShutdownListener(VetoableShutdownListener listener) {
        shutdownListeners.remove(listener);
    }

    public void runTaskNow(TaskDelegate<?> task, boolean lockScreen) {
        this.getQueue(lockScreen).runTaskNow(task);
    }

    public void scheduleTask(TaskDelegate<?> task, boolean lockScreen) {
        this.getQueue(lockScreen).scheduleTask(task);
    }

    protected BackgroundEventQueue getQueue(boolean lockScreen) {
        if (lockScreen) {
            return this.screenLockQueue;
        }
        return this.backgroundQueue;
    }

    public void scheduleTasks(boolean lockScreen, TaskDelegate<?> ... tasks) {
        this.getQueue(lockScreen).scheduleTasks(tasks);
    }

    public void scheduleDependentTasks(boolean lockScreen, TaskDelegate<?> ... tasks) {
        this.getQueue(lockScreen).scheduleDependentTasks(tasks);
    }

    public GUIManager() {
        this.screenLockQueue = BackgroundEventQueue.getGlobalQueue();
        this.backgroundQueue = new BackgroundEventQueue();
    }

    public static GUIManager getManager() {
        if (manager == null) {
            manager = new GUIManager();
        }
        return manager;
    }

    public static void setManager(GUIManager manager) {
        GUIManager.manager = manager;
    }

    public void addUserListener(UserListener listener) {
        this.userListeners.add(listener.getEventType(), listener);
    }

    public void removeUserListener(UserListener listener) {
        this.userListeners.remove(listener.getEventType(), listener);
    }

    public void fireUserEvent(UserEvent event) {
        Collection listeners = (Collection)this.userListeners.get(event.getType());
        for (UserListener listener : listeners) {
            listener.userEventOccurred(event);
        }
    }

    public void addStartupTask(GUITask task) {
        if (this.started) {
            throw new IllegalStateException("Cannot add a new startup task once the gui manager has started");
        }
        this.startupTasks.add(task);
    }

    public void removeStartupTask(GUITask task) {
        if (this.started) {
            throw new IllegalStateException("Cannot remove a startup task once the gui manager has started");
        }
        this.startupTasks.remove(task);
    }

    protected GUITask popTask() {
        return this.startupTasks.removeFirst();
    }

    public void installTask(GUITask task) {
        this.activeTasks.add(task);
        task.install();
    }

    public void notifyComplete(GUITask task) {
        task.shutdown();
        this.activeTasks.remove(task);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public boolean installMenuItem(String path, JMenuItem item) {
        return ComponentPath.addComponent(path, this.getFrame().getJMenuBar(), item);
    }

    public boolean uninstallMenuItem(String path, JMenuItem item) {
        return ComponentPath.removeComponent(path, this.getFrame().getJMenuBar(), item);
    }

    public void setEnabledMenuItem(String path, boolean enabled) {
        if (path != null) {
            ComponentPath.getComponent(path, this.getFrame().getJMenuBar()).setEnabled(enabled);
        } else {
            logger.error((Object)"GUIManager.setEnabledMenuItem failed - null path");
        }
    }

    public boolean installToolBar(JToolBar toolbar) {
        return ComponentPath.addComponent(null, this.getFrame(), toolbar);
    }

    public void setDocLockStatus(boolean lock) {
        this.lockDoc = lock;
        if (this.lockDoc) {
            ComponentManager.getManager().getDriver().lockDockingPanels();
        } else {
            ComponentManager.getManager().getDriver().unlockDockingPanels();
        }
    }

    public boolean getDocLockStatus() {
        return this.lockDoc;
    }

    public void setOTELockStatus(boolean lock) {
        this.OTElock = lock;
        if (this.OTElock) {
            ComponentManager.getManager().getDriver().lockOTE();
        } else {
            ComponentManager.getManager().getDriver().unlockOTE();
        }
    }

    public boolean getOTELockStatus() {
        return this.OTElock;
    }

    public void start() {
        GUIManager.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                GUIManager.this.shutdown();
            }
        });
        while (this.startupTasks.size() > 0) {
            GUITask startupTask = this.popTask();
            this.installTask(startupTask);
        }
        this.started = true;
    }

    public void shutdown() {
        LinkedList<GUITask> taskList = new LinkedList<GUITask>(this.activeTasks);
        for (GUITask task : taskList) {
            task.shutdown();
        }
        this.started = false;
    }

    public static final File readPrefsDir() {
        File prefsDir = null;
        if (System.getProperty(PREFS_DIR_PROPERTY) != null) {
            prefsDir = new File(System.getProperty(PREFS_DIR_PROPERTY));
            boolean worked = true;
            if (!prefsDir.exists()) {
                worked = prefsDir.mkdirs();
            }
            if (!worked) {
                prefsDir = null;
            }
        }
        if (prefsDir == null && !(prefsDir = new File(System.getProperty("user.home") + "/.bbopframework")).exists()) {
            prefsDir.mkdirs();
        }
        return prefsDir;
    }

    public static File getPrefsDir() {
        if (prefsDir == null) {
            GUIManager.readPrefsDir();
        }
        return prefsDir;
    }

    public static void setPrefsDir(File dir) {
        prefsDir = dir;
        boolean worked = true;
        if (!prefsDir.exists()) {
            worked = prefsDir.mkdirs();
        }
        if (!worked) {
            prefsDir = null;
        }
    }

    public static void addShutdownHook(Runnable r) {
        hooks.add(r);
    }

    public static void removeShutdownHook(Runnable r) {
        hooks.remove(r);
    }

    public static void exit(final int status) {
        for (VetoableShutdownListener listener : shutdownListeners) {
            if (listener.willShutdown()) continue;
            return;
        }
        for (Runnable r : hooks) {
            SwingUtilities.invokeLater(r);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Exiting.\n");
                System.exit(status);
            }
        });
    }

    public static boolean isConfirmOnExit() {
        return confirmOnExit;
    }

    public static void setConfirmOnExit(boolean confirmOnExit) {
        GUIManager.confirmOnExit = confirmOnExit;
    }

    public static boolean advxpMatrixEditorCheckBox() {
        return advxpMatrixEditorCheckBox;
    }

    public static void setadvxpMatrixEditorCheckBox(boolean advxpMatrixEditorCheckBox) {
        GUIManager.advxpMatrixEditorCheckBox = advxpMatrixEditorCheckBox;
    }

    public static boolean advIntersectionEditorCheckBox() {
        return advIntersectionEditorCheckBox;
    }

    public static void setadvIntersectionEditorCheckBox(boolean advIntersectionEditorCheckBox) {
        GUIManager.advIntersectionEditorCheckBox = advIntersectionEditorCheckBox;
    }

    public static boolean advSemanticParserCheckBox() {
        return advSemanticParserCheckBox;
    }

    public static void setadvSemanticParserCheckBox(boolean advSemanticParserCheckBox) {
        GUIManager.advSemanticParserCheckBox = advSemanticParserCheckBox;
    }

    static {
        hooks = new LinkedList<Runnable>();
        shutdownListeners = new ArrayList<VetoableShutdownListener>();
        confirmOnExit = true;
        advxpMatrixEditorCheckBox = false;
        advIntersectionEditorCheckBox = false;
        advSemanticParserCheckBox = false;
    }
}

