/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterRegistry;
import org.bbop.dataadapter.DefaultAdapterRegistry;
import org.bbop.dataadapter.GraphicalAdapterChooser;
import org.bbop.dataadapter.IOOperation;
import org.bbop.framework.GUIManager;
import org.bbop.framework.IOEvent;
import org.bbop.framework.IOListener;
import org.bbop.io.FileUtil;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.swing.BackgroundUtil;
import org.bbop.util.AbstractTaskDelegate;

public class IOManager {
    protected static final Logger logger = Logger.getLogger(IOManager.class);
    protected static IOManager manager;
    protected Collection<IOListener> listeners = new LinkedList<IOListener>();
    protected DataAdapterRegistry adapterRegistry = new DefaultAdapterRegistry();
    protected DataAdapter currentAdapter = null;
    protected String historyPath;

    public void setHistoryFilePath(String historyPath) {
        this.historyPath = historyPath;
    }

    public String getHistoryFilePath() {
        if (this.historyPath == null) {
            File historyFile = new File(GUIManager.getPrefsDir(), "history.xml");
            try {
                FileUtil.ensureExists(historyFile, "org/oboedit/resources/history.xml");
                this.historyPath = historyFile.getAbsolutePath();
            }
            catch (IOException e) {
                logger.error((Object)("ensureExists failed: " + e));
            }
        }
        return this.historyPath;
    }

    public DataAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    public void setAdapterRegistry(DataAdapterRegistry adapterRegistry) {
        this.adapterRegistry = adapterRegistry;
    }

    public static IOManager getManager() {
        if (manager == null) {
            manager = new IOManager();
        }
        return manager;
    }

    protected void fireOperationExecuted(IOEvent<?> e) {
        for (IOListener listener : new LinkedList<IOListener>(this.listeners)) {
            listener.operationExecuted(e);
        }
    }

    public void addIOListener(IOListener listener) {
        this.listeners.add(listener);
    }

    public void removeIOListener(IOListener listener) {
        this.listeners.remove(listener);
    }

    protected IOManager() {
    }

    public void installDataAdapter(DataAdapter adapter) {
        this.adapterRegistry.addAdapter(adapter);
    }

    public void removeDataAdapter(DataAdapter adapter) {
        this.adapterRegistry.removeAdapter(adapter);
    }

    public <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE doOperation(final IOOperation<INPUT_TYPE, OUTPUT_TYPE> op, final INPUT_TYPE input, boolean fireEvents) throws DataAdapterException {
        if (fireEvents) {
            AbstractTaskDelegate<Boolean> eventTask = new AbstractTaskDelegate<Boolean>(){

                @Override
                public void execute() throws Exception {
                    for (IOListener listener : new LinkedList<IOListener>(IOManager.this.listeners)) {
                        if (listener.willExecuteOperation(new IOEvent<Object>(this, op, input))) continue;
                        this.setResults(true);
                        return;
                    }
                    this.setResults(false);
                }
            };
            BackgroundEventQueue queue = new BackgroundEventQueue();
            BackgroundUtil.scheduleTask(queue, eventTask, true, "OBO-Edit: IOManager working");
            queue.die();
            if (((Boolean)eventTask.getResults()).booleanValue()) {
                return null;
            }
        }
        DataAdapterRegistry registry = this.getAdapterRegistry();
        GraphicalAdapterChooser<INPUT_TYPE, OUTPUT_TYPE> gac = new GraphicalAdapterChooser<INPUT_TYPE, OUTPUT_TYPE>(registry, op, GUIManager.getManager().getScreenLockQueue(), GUIManager.getManager().getFrame(), true, input);
        gac.setHistoryPath(this.getHistoryFilePath());
        boolean worked = gac.showDialog(op.getName(), GUIManager.getManager().getFrame());
        if (worked) {
            this.setCurrentAdapter(gac.getCurrentAdapter());
            return gac.getResult();
        }
        return null;
    }

    public DataAdapter getCurrentAdapter() {
        return this.currentAdapter;
    }

    private void setCurrentAdapter(DataAdapter ca) {
        this.currentAdapter = ca;
    }

    public <INPUT_TYPE, OUTPUT_TYPE> boolean justFireEvents(final IOOperation<INPUT_TYPE, OUTPUT_TYPE> op, final INPUT_TYPE input) throws DataAdapterException {
        boolean willExecute = true;
        AbstractTaskDelegate<Boolean> eventTask = new AbstractTaskDelegate<Boolean>(){

            @Override
            public void execute() throws Exception {
                for (IOListener listener : new LinkedList<IOListener>(IOManager.this.listeners)) {
                    if (listener.willExecuteOperation(new IOEvent<Object>(this, op, input))) continue;
                    this.setResults(true);
                    return;
                }
                this.setResults(false);
            }
        };
        BackgroundEventQueue queue = new BackgroundEventQueue();
        BackgroundUtil.scheduleTask(queue, eventTask, true, "OBO-Edit: IOManager working");
        queue.die();
        return (Boolean)eventTask.getResults();
    }
}

