/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bbop.framework.GUITask;
import org.bbop.io.IOUtil;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;

public class PluginManager {
    static final Logger logger = Logger.getLogger("PluginManager.class");
    protected static PluginManager manager;
    protected File[] pluginDirs;
    protected boolean initialized = false;
    protected Map<URL, ClassLoader> classLoaderMap = new HashMap<URL, ClassLoader>();
    protected Collection<URL> pluginJars;
    protected MultiMap<URL, Class<?>> classMap = new MultiHashMap();
    protected static FilenameFilter jarFilter;

    public static void createInstallerConfiguration(Collection<String> classes, Collection<String> libs, File dest) throws FileNotFoundException {
        InstallerConfig config = new InstallerConfig();
        config.setClasses(classes);
        config.setLibs(libs);
        XMLEncoder encoder = new XMLEncoder(new FileOutputStream(dest));
        encoder.writeObject(config);
        encoder.close();
    }

    public <T> Collection<T> instantiateAll(Class<T> makeMe) {
        LinkedList out = new LinkedList();
        for (Class<?> c : this.getClasses()) {
            if (!makeMe.isAssignableFrom(c)) continue;
            Class<?> tc = c;
            try {
                Constructor<?> con = tc.getConstructor(new Class[0]);
                out.add(con.newInstance(new Object[0]));
            }
            catch (IllegalArgumentException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {}
        }
        return out;
    }

    public static PluginManager getManager() {
        if (manager == null) {
            manager = new PluginManager();
        }
        return manager;
    }

    public File[] getPluginDirs() {
        return this.pluginDirs;
    }

    public void setPluginDirs(File ... pluginDirs) {
        this.pluginDirs = pluginDirs;
    }

    public Collection<Class<?>> getClasses() {
        if (!this.initialized) {
            this.init();
        }
        return this.classMap.singleValues();
    }

    public Collection<Class<?>> getClasses(URL url) {
        if (!this.initialized) {
            this.init();
        }
        return (Collection)this.classMap.get(url);
    }

    public Collection<URL> getPluginJars() {
        if (!this.initialized) {
            this.init();
        }
        return this.pluginJars;
    }

    public ClassLoader getClassLoader(URL url) {
        if (!this.initialized) {
            this.init();
        }
        return this.classLoaderMap.get(url);
    }

    public static void main(String[] args) throws Exception {
        LinkedList<String> list = new LinkedList<String>();
        list.add("edu.berkeley.oboplugins.MoreInfoPlugin");
        PluginManager.createInstallerConfiguration(list, null, new File("/Users/jrichter/workspace/PluginProject/classes/install.xml"));
        PluginManager.getManager().setPluginDirs(new File("/Users/jrichter/testjars"));
        Collection<GUITask> tasks = PluginManager.getManager().instantiateAll(GUITask.class);
        logger.info("tasks = " + tasks);
    }

    protected void init() {
        ClassLoader pluginLoader;
        Object temp;
        this.initialized = true;
        ClassLoader parentLoader = PluginManager.class.getClassLoader();
        LinkedList<URL> classPathJars = new LinkedList<URL>();
        MultiHashMap<URL, URL> embeddedJars = new MultiHashMap<URL, URL>();
        LinkedList<URL> pluginJars = new LinkedList<URL>();
        HashMap<URL, JarFile> classSearchJarFiles = new HashMap<URL, JarFile>();
        MultiHashMap<URL, String> classLoadJarFiles = new MultiHashMap<URL, String>();
        for (File f : this.getPluginDirs()) {
            if (!f.exists() || !f.isDirectory()) continue;
            File sharedDir = new File(f, "shared");
            if (sharedDir.exists() && sharedDir.isDirectory()) {
                LinkedList<URL> sharedLibs = new LinkedList<URL>();
                for (File d : sharedDir.listFiles(jarFilter)) {
                    try {
                        new JarFile(d);
                        sharedLibs.add(d.toURL());
                    }
                    catch (IOException e) {
                        logger.info("Could not read shared jar " + d);
                    }
                }
                if (sharedLibs.size() > 0) {
                    parentLoader = new URLClassLoader(sharedLibs.toArray(new URL[sharedLibs.size()]));
                }
            }
            temp = f.listFiles(jarFilter);
            for (File jar : temp) {
                try {
                    JarEntry libEntry;
                    XMLDecoder decoder;
                    InstallerConfig config;
                    JarFile jf = new JarFile(jar);
                    classPathJars.add(jar.toURL());
                    pluginJars.add(jar.toURL());
                    URL[] urls = new URL[]{jar.toURL()};
                    URLClassLoader pluginLoader2 = new URLClassLoader(urls);
                    boolean doLibrarySearch = true;
                    boolean doClassSearch = true;
                    URL classIndexFile = pluginLoader2.getResource("install.xml");
                    if (classIndexFile != null && (config = (InstallerConfig)(decoder = new XMLDecoder(classIndexFile.openStream())).readObject()) != null) {
                        String file = null;
                        try {
                            if (config.getLibs() != null) {
                                Iterator<String> iterator = config.getLibs().iterator();
                                while (iterator.hasNext()) {
                                    String s;
                                    file = s = iterator.next();
                                    URL embeddedURL = pluginLoader2.getResource(s);
                                    if (embeddedURL == null) continue;
                                    embeddedJars.add(jar.toURL(), embeddedURL);
                                }
                                doLibrarySearch = false;
                            }
                        }
                        catch (Throwable t) {
                            Logger logger = Logger.getLogger("plugins");
                            logger.log(Level.WARNING, "Unable to load embedded library " + file, t);
                        }
                        String className = null;
                        if (config.getClasses() != null) {
                            Iterator<String> iterator = config.getClasses().iterator();
                            while (iterator.hasNext()) {
                                String s;
                                className = s = iterator.next();
                                classLoadJarFiles.add(jar.toURL(), s);
                            }
                            doClassSearch = false;
                        }
                    }
                    if (doLibrarySearch && (libEntry = jf.getJarEntry("lib/")) != null && libEntry.isDirectory()) {
                        Enumeration<JarEntry> e = jf.entries();
                        while (e.hasMoreElements()) {
                            JarEntry je = e.nextElement();
                            if (!je.getName().startsWith("lib/") || !je.getName().endsWith(".jar")) continue;
                            URL embeddedURL = pluginLoader2.getResource(je.getName());
                            embeddedJars.add(jar.toURL(), embeddedURL);
                        }
                    }
                    if (!doClassSearch) continue;
                    classSearchJarFiles.put(jar.toURL(), jf);
                }
                catch (IOException e) {
                    Logger logger = Logger.getLogger("plugins");
                    logger.log(Level.WARNING, "Could not read plugin jar " + jar, e);
                }
            }
        }
        this.pluginJars = pluginJars;
        for (URL url : classPathJars) {
            LinkedList<URL> urlList = new LinkedList<URL>();
            for (URL embedded : (Collection)embeddedJars.get(url)) {
                try {
                    temp = File.createTempFile("templib", ".jar");
                    ((File)temp).deleteOnExit();
                    IOUtil.dumpAndClose(embedded.openStream(), new FileOutputStream((File)temp));
                    urlList.add(((File)temp).toURL());
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            urlList.add(url);
            URLClassLoader loader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), parentLoader);
            this.classLoaderMap.put(url, loader);
        }
        URL[] urls = classPathJars.toArray(new URL[classPathJars.size()]);
        for (URL url : classSearchJarFiles.keySet()) {
            pluginLoader = this.getClassLoader(url);
            JarFile jf = (JarFile)classSearchJarFiles.get(url);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je.getName().startsWith("lib/") || !je.getName().endsWith(".class") || je.getName().length() <= 6) continue;
                String name = je.getName().replace('/', '.').substring(0, je.getName().length() - 6);
                try {
                    Class<?> c = pluginLoader.loadClass(name);
                    this.classMap.add(url, c);
                }
                catch (ClassNotFoundException e1) {
                    Logger logger = Logger.getLogger("plugins");
                    logger.log(Level.WARNING, "Could not read class file " + name + " during automatic search of jar " + url, e1);
                }
            }
        }
        for (URL url : classLoadJarFiles.keySet()) {
            pluginLoader = this.getClassLoader(url);
            for (String s : (Collection)classLoadJarFiles.get(url)) {
                try {
                    Class<?> c = pluginLoader.loadClass(s);
                    this.classMap.add(url, c);
                }
                catch (ClassNotFoundException e1) {
                    Logger logger = Logger.getLogger("plugins");
                    logger.log(Level.WARNING, "Could not read class file " + s + " specified in installation preferences of jar " + url, e1);
                }
            }
        }
    }

    private PluginManager() {
    }

    static {
        jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
    }

    public static class InstallerConfig {
        protected Collection<String> libs = new LinkedList<String>();
        protected Collection<String> classes = new LinkedList<String>();

        public InstallerConfig(Collection<String> classes, Collection<String> libs) {
            this.setClasses(classes);
            this.setLibs(libs);
        }

        public InstallerConfig() {
        }

        public Collection<String> getLibs() {
            return this.libs;
        }

        public void setLibs(Collection<String> libs) {
            this.libs = libs;
        }

        public Collection<String> getClasses() {
            return this.classes;
        }

        public void setClasses(Collection<String> classes) {
            this.classes = classes;
        }
    }
}

