/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.bbop.framework.ComponentManager;
import org.bbop.framework.GUIComponentFactory;

public class ViewMenus {
    protected static final Logger logger = Logger.getLogger(ViewMenus.class);

    public List<JMenu> getMenus() {
        HashMap factoryMap = new HashMap();
        Collection<GUIComponentFactory<?>> f = ComponentManager.getManager().getFactories();
        for (GUIComponentFactory<?> factory : f) {
            if (!factory.showInMenus()) continue;
            ArrayList factories = (ArrayList)factoryMap.get((Object)factory.getCategory());
            if (factories == null) {
                factories = new ArrayList();
                factoryMap.put(factory.getCategory(), factories);
            }
            factories.add(factory);
        }
        Comparator<GUIComponentFactory> factoryComparator = new Comparator<GUIComponentFactory>(){

            @Override
            public int compare(GUIComponentFactory o1, GUIComponentFactory o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        LinkedList<JMenu> out = new LinkedList<JMenu>();
        for (GUIComponentFactory.FactoryCategory category : GUIComponentFactory.FactoryCategory.values()) {
            List factories = (List)factoryMap.get((Object)category);
            if (factories == null || factories.size() <= 0) continue;
            Collections.sort(factories, factoryComparator);
            JMenu subMenu = new JMenu(category.toString());
            subMenu.setName(category.toString());
            for (final GUIComponentFactory factory : factories) {
                JMenuItem item = new JMenuItem(new AbstractAction(factory.getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ComponentManager.getManager().showComponent(factory, null);
                    }
                });
                item.setName(item.getText());
                subMenu.add(item);
            }
            out.add(subMenu);
        }
        return out;
    }
}

