/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework.dock.idw;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.util.StringViewMap;
import org.apache.log4j.Logger;
import org.bbop.framework.AbstractGUIComponent;
import org.bbop.framework.ComponentManager;
import org.bbop.framework.GUIComponent;
import org.bbop.framework.GUIComponentFactory;
import org.bbop.framework.dock.idw.ComponentConfigCard;
import org.bbop.framework.dock.idw.IDWDriver;

public class DefaultViewSerializer
implements ViewSerializer {
    protected static final Logger logger = Logger.getLogger(DefaultViewSerializer.class);
    protected IDWDriver driver;
    protected StringViewMap viewMap;

    public DefaultViewSerializer(StringViewMap viewMap, IDWDriver driver) {
        this.driver = driver;
        this.viewMap = viewMap;
    }

    public View readView(ObjectInputStream in) throws IOException {
        boolean initialLoad = this.driver.getCurrentPerspective() == null;
        String id = in.readUTF();
        Object v = this.viewMap.getView(id);
        if (v == null) {
            String factoryID = ComponentManager.getFactoryID(id);
            GUIComponentFactory factory = ComponentManager.getManager().getFactory(factoryID);
            v = factory != null && (!initialLoad || factory.isRestoreOnStartup()) ? this.driver.createView(factory, id, null) : new GarbageView();
            if (v != null) {
                this.driver.addView((View)v);
            }
        } else {
            this.driver.fireCreatedView((View)v, IDWDriver.getComponent(v));
        }
        return v;
    }

    public void writeView(View view, ObjectOutputStream out) throws IOException {
        GUIComponent c = ((ComponentConfigCard)view.getComponent()).getComponent();
        out.writeUTF(c.getID());
    }

    public static class GarbageView
    extends View {
        private static int idgen = 0;

        public GarbageView() {
            super("Garbage" + idgen, null, (Component)new ComponentConfigCard(new AbstractGUIComponent("dummy:" + idgen){}));
            ++idgen;
        }
    }
}

