/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework.dock.idw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.infonode.docking.DefaultButtonFactories;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.internal.ViewTitleBar;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.StringViewMap;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.util.Direction;
import org.apache.log4j.Logger;
import org.bbop.framework.ComponentManager;
import org.bbop.framework.ConfigurationPanel;
import org.bbop.framework.FrameworkUtil;
import org.bbop.framework.GUIComponent;
import org.bbop.framework.GUIComponentFactory;
import org.bbop.framework.GUIManager;
import org.bbop.framework.HelpManager;
import org.bbop.framework.dock.LayoutDriver;
import org.bbop.framework.dock.LayoutListener;
import org.bbop.framework.dock.Perspective;
import org.bbop.framework.dock.idw.BBOPDockingTheme;
import org.bbop.framework.dock.idw.BitmapIcon;
import org.bbop.framework.dock.idw.ComponentConfigCard;
import org.bbop.framework.dock.idw.DefaultViewSerializer;
import org.bbop.framework.dock.idw.DockPanel;
import org.bbop.framework.dock.idw.IDWUtil;
import org.bbop.framework.dock.idw.ViewListener;
import org.bbop.io.FileUtil;
import org.bbop.io.IOUtil;
import org.bbop.swing.SwingUtil;
import org.bbop.util.ObjectUtil;

public class IDWDriver
implements LayoutDriver {
    protected static final Logger logger = Logger.getLogger((String)"IDWDriver.class");
    protected StringViewMap viewMap;
    protected RootWindow rootWindow;
    protected DockingWindowsTheme currentTheme = new ShapedGradientDockingTheme();
    protected DockingWindowsTheme customTheme = null;
    protected RootWindowProperties properties = new RootWindowProperties();
    protected List<Perspective> perspectives = new LinkedList<Perspective>();
    protected Perspective currentPerspective;
    protected Color background = Color.lightGray;
    protected Font font = new Font("Arial", 0, 10);
    protected Color darkColor = Color.blue;
    protected Color lightColor = Color.white;
    protected Collection<ViewListener> viewListeners = new LinkedList<ViewListener>();
    protected String perspectiveResourceDir;
    protected String defaultPerspectiveResourcePath;
    protected String perspectiveListResourcePath;
    protected Collection<LayoutListener> layoutListeners = new ArrayList<LayoutListener>();
    private boolean saveLayoutOnExit = true;
    protected DockingWindowListener floatingWindowCloseListener = new DockingWindowAdapter(){

        public void windowClosed(DockingWindow window) {
            View v = SwingUtil.getDescendantOfType((Component)window, View.class);
            if (v != null) {
                IDWDriver.this.destroyView(v);
            }
        }

        public void windowClosing(DockingWindow window) throws OperationAbortedException {
            View v = SwingUtil.getDescendantOfType((Component)window, View.class);
            GUIComponent c = IDWDriver.getComponent(v);
            if (c != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    if (listener.closing(c)) continue;
                    throw new OperationAbortedException();
                }
            }
        }
    };
    protected DockingWindowListener masterDockingListener = new DockingWindowListener(){

        public void viewFocusChanged(View old, View newView) {
            GUIComponent oldC = IDWDriver.getComponent(old);
            GUIComponent newC = IDWDriver.getComponent(newView);
            for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                listener.focusChanged(oldC, newC);
            }
            if (newView != null) {
                IDWDriver.this.lastComponent = newView;
            }
        }

        public void windowAdded(DockingWindow parent, DockingWindow child) {
            GUIComponent parentC = IDWDriver.getComponent(parent);
            GUIComponent childC = IDWDriver.getComponent(child);
            if (childC != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    listener.add(parentC, childC);
                }
            }
            if (child != null && child instanceof View) {
                IDWDriver.this.lastComponent = child;
            }
        }

        public void windowClosed(DockingWindow d) {
            View v = SwingUtil.getDescendantOfType((Component)d, View.class);
            if (v != null) {
                IDWDriver.this.destroyView(v);
            }
        }

        public void windowUndocked(DockingWindow d) {
            FloatingWindow floater = SwingUtil.getAncestorOfClass(FloatingWindow.class, (Component)d);
            floater.addListener(IDWDriver.this.floatingWindowCloseListener);
        }

        public void windowDocked(DockingWindow d) {
        }

        public void windowMaximized(DockingWindow d) {
        }

        public void windowMinimized(DockingWindow d) {
        }

        public void windowRestored(DockingWindow d) {
        }

        public void windowHidden(DockingWindow arg0) {
        }

        public void windowClosing(DockingWindow d) throws OperationAbortedException {
            GUIComponent c = IDWDriver.getComponent(d);
            if (c != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    if (listener.closing(c)) continue;
                    throw new OperationAbortedException();
                }
            }
        }

        public void windowDocking(DockingWindow d) throws OperationAbortedException {
            GUIComponent c = IDWDriver.getComponent(d);
            if (c != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    if (listener.docking(c)) continue;
                    throw new OperationAbortedException();
                }
            }
        }

        public void windowMaximizing(DockingWindow d) throws OperationAbortedException {
            GUIComponent c = IDWDriver.getComponent(d);
            if (c != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    if (listener.maximizing(c)) continue;
                    throw new OperationAbortedException();
                }
            }
        }

        public void windowMinimizing(DockingWindow d) throws OperationAbortedException {
            GUIComponent c = IDWDriver.getComponent(d);
            if (c != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    if (listener.minimizing(c)) continue;
                    throw new OperationAbortedException();
                }
            }
        }

        public void windowRestoring(DockingWindow d) throws OperationAbortedException {
            GUIComponent c = IDWDriver.getComponent(d);
            if (c != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    if (listener.restoring(c)) continue;
                    throw new OperationAbortedException();
                }
            }
        }

        public void windowShown(DockingWindow d) {
        }

        public void windowUndocking(DockingWindow d) throws OperationAbortedException {
            GUIComponent c = IDWDriver.getComponent(d);
            if (c != null) {
                for (LayoutListener listener : IDWDriver.this.layoutListeners) {
                    if (listener.undocking(c)) continue;
                    throw new OperationAbortedException();
                }
            }
        }

        public void windowRemoved(DockingWindow arg0, DockingWindow arg1) {
        }
    };
    protected DockingWindow lastComponent;
    protected Icon wrenchIcon = new BitmapIcon(FrameworkUtil.getResourceImage("tiny_wrench_icon.gif"));
    protected Icon checkIcon = new BitmapIcon(FrameworkUtil.getResourceImage("tiny_checkmark_icon.gif"));
    protected Icon questionIcon = new BitmapIcon(FrameworkUtil.getResourceImage("tiny_question_icon.gif"));

    @Override
    public void addLayoutListener(LayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    @Override
    public void removeLayoutListener(LayoutListener listener) {
        this.layoutListeners.remove(listener);
    }

    public void addViewListener(ViewListener listener) {
        this.viewListeners.add(listener);
    }

    public void removeViewListener(ViewListener listener) {
        this.viewListeners.remove(listener);
    }

    protected void fireCreatedView(View v, GUIComponent c) {
        for (ViewListener listener : this.viewListeners) {
            listener.viewCreated(v, c);
        }
    }

    protected void fireDestroyedView(View v, GUIComponent c) {
        for (ViewListener listener : this.viewListeners) {
            listener.viewDestroyed(v, c);
        }
    }

    @Override
    public void cleanup() {
        if (this.saveLayoutOnExit && this.currentPerspective != null) {
            this.savePerspectiveAs(this.currentPerspective, this.currentPerspective.getName());
        }
        if (this.currentPerspective != null) {
            this.savePerspectives();
        }
    }

    @Override
    public void setSaveLayoutOnExit(boolean saveLayout) {
        this.saveLayoutOnExit = saveLayout;
    }

    @Override
    public void savePerspectives() {
        File file = IDWDriver.getPerspectivesFile();
        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
            encoder.writeObject(this.perspectives);
            encoder.writeObject(this.currentPerspective);
            encoder.close();
        }
        catch (IOException e) {
            logger.warn((Object)("savePerspectives: exception trying to write perspectives file " + file));
            e.printStackTrace();
        }
    }

    @Override
    public GUIComponent createMainPanel(String id) {
        return new DockPanel(id, this);
    }

    @Override
    public boolean deletePerspective(Perspective p) {
        if (p.getBuiltIn()) {
            return false;
        }
        File perspectiveFile = IDWDriver.getFile(p);
        int index = this.perspectives.indexOf(p);
        if (index >= 0) {
            this.perspectives.remove(index);
            perspectiveFile.delete();
            if (p.equals(this.currentPerspective)) {
                if (index >= this.perspectives.size()) {
                    index = 0;
                }
                this.setPerspective(this.perspectives.get(index));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean importPerspective(File newPerspectiveFile) {
        logger.info((Object)("IDWDriver.importPerspective " + newPerspectiveFile));
        try {
            IOUtil.copyFiles(newPerspectiveFile, new File(IDWDriver.getPerspectivesDir(), newPerspectiveFile.getName()));
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't copy " + newPerspectiveFile + " to prefs dir."));
            return false;
        }
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(newPerspectiveFile)));
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't open " + newPerspectiveFile));
            return false;
        }
        String name = newPerspectiveFile.getName();
        name = name.replace(".idw", "");
        Perspective newPerspective = new Perspective(name.toLowerCase(), name);
        this.perspectives.add(newPerspective);
        this.setPerspective(newPerspective);
        this.savePerspectives();
        return true;
    }

    @Override
    public Perspective getCurrentPerspective() {
        return this.currentPerspective;
    }

    @Override
    public Perspective getPerspective(String name) {
        for (Perspective p : this.perspectives) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public List<Perspective> getPerspectives() {
        return this.perspectives;
    }

    protected static File getFile(Perspective perspective) {
        return IDWDriver.getFile(perspective.getID());
    }

    protected static File getFile(String name) {
        return new File(IDWDriver.getPerspectivesDir(), name.toLowerCase() + ".idw");
    }

    protected static File getPerspectivesDir() {
        return new File(GUIManager.getPrefsDir(), "perspectives");
    }

    protected static File getPerspectivesFile() {
        return new File(IDWDriver.getPerspectivesDir(), "perspectives.xml");
    }

    protected void loadPerspectives() {
        File toFile = IDWDriver.getPerspectivesFile();
        if (this.getPerspectiveListResourcePath() != null) {
            try {
                FileUtil.ensureExists(toFile, this.getPerspectiveListResourcePath());
            }
            catch (IOException e1) {
                logger.warn((Object)("loadPerspectives: exception trying to create perspectives file " + toFile + " from resource" + this.getPerspectiveListResourcePath()));
                e1.printStackTrace();
            }
        }
        if (toFile.exists()) {
            this.perspectives = null;
            Perspective currentPerspective = null;
            try {
                XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(toFile)));
                this.perspectives = (List)d.readObject();
                currentPerspective = (Perspective)d.readObject();
                d.close();
            }
            catch (Exception e) {
                logger.warn((Object)("loadPerspectives: exception trying to read perspectives file " + toFile));
                e.printStackTrace();
            }
            if (this.perspectives == null) {
                this.perspectives = new LinkedList<Perspective>();
            } else {
                Iterator<Perspective> it = this.perspectives.iterator();
                while (it.hasNext()) {
                    Perspective p = it.next();
                    if (p == null) {
                        it.remove();
                        continue;
                    }
                    try {
                        ObjectInputStream s = this.getInputStream(IDWDriver.getFile(p).getAbsolutePath());
                        ((InputStream)s).close();
                    }
                    catch (Throwable t) {
                        it.remove();
                    }
                }
            }
            this.createDefaultPerspectives();
            if (currentPerspective == null && this.perspectives.size() > 0) {
                currentPerspective = this.perspectives.get(0);
            }
            if (currentPerspective != null) {
                this.setPerspective(currentPerspective);
            }
        }
    }

    protected void createDefaultPerspectives() {
        try {
            FileUtil.ensureExists(IDWDriver.getPerspectivesFile(), this.getPerspectiveListResourcePath());
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(IDWDriver.getPerspectivesFile())));
            List defaultPerspectiveList = (List)d.readObject();
            for (Perspective p : defaultPerspectiveList) {
                if (this.perspectives.contains(p)) continue;
                this.perspectives.add(p);
            }
        }
        catch (IOException e) {
            logger.warn((Object)("createDefaultPerspectives: exception trying to create default perspectives file " + IDWDriver.getPerspectivesFile() + " from resource" + this.getPerspectiveListResourcePath()));
            e.printStackTrace();
        }
    }

    protected String getResource(Perspective perspective) {
        boolean classLoaderCanFind;
        String out = this.perspectiveResourceDir + "/" + perspective.getID() + ".idw";
        boolean bl = classLoaderCanFind = ClassLoader.getSystemClassLoader().getResource(out) != null;
        if (!classLoaderCanFind) {
            boolean bl2 = classLoaderCanFind = IDWDriver.class.getResource(out) != null;
            if (!classLoaderCanFind) {
                boolean bl3 = classLoaderCanFind = IDWDriver.class.getClassLoader().getResource(out) != null;
            }
        }
        if (!classLoaderCanFind) {
            out = this.defaultPerspectiveResourcePath;
        }
        return out;
    }

    @Override
    public void setPerspective(Perspective perspective) {
        if (this.currentPerspective != null) {
            this.savePerspectiveAs(this.currentPerspective, this.currentPerspective.getName());
        }
        try {
            FileUtil.ensureExists(IDWDriver.getFile(perspective), this.getResource(perspective));
            File file = IDWDriver.getFile(perspective);
            if (file.exists()) {
                String path = file.getAbsolutePath();
                this.restorePerspectiveFromDisk(path);
            }
            this.currentPerspective = perspective;
        }
        catch (Exception e) {
            logger.warn((Object)("setPerspective: exception trying to restore perspective from " + IDWDriver.getFile(perspective)));
            e.printStackTrace();
            this.currentPerspective = this.currentPerspective == null && this.perspectives.size() > 0 ? this.perspectives.get(0) : null;
        }
    }

    protected void restorePerspectiveFromDisk(String path) throws FileNotFoundException, IOException {
        LinkedList<GUIComponent> comps = new LinkedList<GUIComponent>(ComponentManager.getManager().getActiveComponents());
        for (GUIComponent c : comps) {
            View v = this.viewMap.getView(c.getID());
            if (v != null) {
                v.removeListener(this.masterDockingListener);
            }
            if (v == null) continue;
            this.destroyView(v);
        }
        ObjectInputStream stream = this.getInputStream(path);
        this.rootWindow.read(stream, false);
        stream.close();
        ArrayList<String> deadViews = new ArrayList<String>();
        for (int i = 0; i < this.viewMap.getViewCount(); ++i) {
            View v = this.viewMap.getViewAtIndex(i);
            if (!(v instanceof DefaultViewSerializer.GarbageView)) continue;
            logger.info((Object)("View #" + i + ", " + v + ", is a garbage view--destroying"));
            this.destroyView(v);
            --i;
            deadViews.add(IDWDriver.getComponent(v).getID());
        }
        for (String id : deadViews) {
            this.viewMap.removeView(id);
        }
    }

    protected ObjectInputStream getInputStream(String path) throws IOException {
        return new ObjectInputStream(new BufferedInputStream(new FileInputStream(path)));
    }

    protected ObjectOutputStream getOutputStream(String path) throws IOException {
        return new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
    }

    @Override
    public void init() {
        this.viewMap = new StringViewMap();
        this.rootWindow = new RootWindow((ViewSerializer)new DefaultViewSerializer(this.viewMap, this));
        this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
        this.properties.addSuperObject(this.currentTheme.getRootWindowProperties());
        this.rootWindow.getRootWindowProperties().addSuperObject(this.properties);
        if (this.customTheme == null) {
            this.customTheme = new BBOPDockingTheme((ColorProvider)new FixedColorProvider(this.getDarkColor()), (ColorProvider)new FixedColorProvider(this.getLightColor()), (ColorProvider)new FixedColorProvider(this.getBackground()), 4, this.getFont());
        }
        this.setTheme(this.customTheme);
        this.loadPerspectives();
    }

    protected void configureTheme() {
        if (this.currentTheme instanceof BBOPDockingTheme) {
            ((BBOPDockingTheme)this.currentTheme).configure(this.getDarkColor(), this.getLightColor(), this.getBackground(), 4, this.getFont());
        }
    }

    public void setTheme(DockingWindowsTheme theme) {
        this.properties.getMap().clear(true);
        this.properties.replaceSuperObject(this.currentTheme.getRootWindowProperties(), theme.getRootWindowProperties());
        this.properties.getTabWindowProperties().getTabbedPanelProperties().setTabAreaOrientation(Direction.UP);
        this.currentTheme = theme;
        this.configureTheme();
    }

    public void setCustomTheme(DockingWindowsTheme theme) {
        this.customTheme = theme;
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    @Override
    public Perspective savePerspectiveAs(Perspective p, String name) {
        Perspective result;
        try {
            if (this.currentPerspective == null || this.currentPerspective.equals(p)) {
                IDWDriver.getFile(name).getParentFile().mkdirs();
                ObjectOutputStream out = this.getOutputStream(IDWDriver.getFile(name).getAbsolutePath());
                this.rootWindow.write(out, false);
                out.close();
                if (this.currentPerspective == null || !this.currentPerspective.getName().equals(name)) {
                    result = new Perspective(name.toLowerCase(), name);
                    this.perspectives.add(result);
                    this.currentPerspective = result;
                } else {
                    result = this.currentPerspective;
                }
            } else {
                IOUtil.copyFile(IDWDriver.getFile(p), IDWDriver.getFile(name));
                result = new Perspective(name.toLowerCase(), name);
                this.perspectives.add(result);
            }
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    protected String getDefaultIDSuffix() {
        return "main";
    }

    public View createView(final GUIComponentFactory factory, String id, String label) {
        View tempView;
        if (id == null) {
            id = factory.getID() + ":" + this.getDefaultIDSuffix();
        }
        if ((tempView = this.viewMap.getView(id)) != null && tempView.getWindowParent() == null) {
            return tempView;
        }
        GUIComponent c = ComponentManager.getManager().createComponent(factory, null);
        ComponentConfigCard card = new ComponentConfigCard(c);
        if (label == null) {
            label = c.getTitle();
        }
        final String flabel = label;
        final View v = new View(label, null, (Component)card);
        v.addListener(this.masterDockingListener);
        v.addListener((DockingWindowListener)new DockingWindowAdapter(){

            public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
                v.getViewProperties().setTitle(flabel);
                IDWDriver.this.lastComponent = addedWindow;
            }
        });
        DefaultButtonFactories.getCloseButtonFactory();
        final JToggleButton configButton = IDWUtil.createFlatHighlightToggleButton(this.wrenchIcon, "Configure Component", 0, null);
        this.updateConfigButton(configButton);
        configButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IDWDriver.this.updateConfigButton(configButton);
                IDWDriver.this.configureComponent(configButton, v);
            }
        });
        if (c.getConfigurationPanel() == null) {
            configButton.setEnabled(false);
        }
        if (c.getConfigurationPanel() != null) {
            v.getCustomTitleBarComponents().add(configButton);
            v.getCustomTabComponents().add(configButton);
        }
        if (factory.getHelpTopicID() != null) {
            try {
                if (HelpManager.getManager().isEnabled()) {
                    final JToggleButton helpButton = IDWUtil.createFlatHighlightToggleButton(this.questionIcon, "Display Help", 0, null);
                    helpButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HelpManager.getManager().displayHelp(helpButton, factory.getHelpTopicID());
                        }
                    });
                    v.getCustomTitleBarComponents().add(helpButton);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        final MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ViewTitleBar bar = (ViewTitleBar)e.getComponent();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("View");
                    for (Container p = v.getParent(); p != null; p = p.getParent()) {
                        if (p instanceof DockingWindow) {
                            Collection comps = SwingUtil.getAllDescendants(p, Tab.class);
                            buffer.append(" -> " + p.getClass());
                        }
                        if (p != null && !(p instanceof Tab)) continue;
                    }
                    EditorField field = new EditorField(v, bar);
                    field.install();
                }
            }
        };
        v.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof ViewTitleBar) {
                    ViewTitleBar bar = (ViewTitleBar)e.getChild();
                    bar.addMouseListener(listener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof ViewTitleBar) {
                    ViewTitleBar bar = (ViewTitleBar)e.getChild();
                    bar.removeMouseListener(listener);
                }
            }
        });
        return v;
    }

    protected void updateConfigButton(JToggleButton configButton) {
        if (configButton.isSelected()) {
            configButton.setIcon(this.checkIcon);
            configButton.setToolTipText("Save configuration settings and display component");
        } else {
            configButton.setIcon(this.wrenchIcon);
            configButton.setToolTipText("Configure Component");
        }
    }

    public static GUIComponent getComponent(DockingWindow d) {
        if (d instanceof View) {
            return IDWDriver.getComponent((View)d);
        }
        return null;
    }

    public static GUIComponent getComponent(View v) {
        if (v == null || v.getComponent() == null) {
            return null;
        }
        return ((ComponentConfigCard)v.getComponent()).getComponent();
    }

    protected void addView(View v) {
        GUIComponent c = ((ComponentConfigCard)v.getComponent()).getComponent();
        if (c.teardownWhenHidden() || !this.viewMap.contains(v)) {
            this.viewMap.addView(c.getID(), v);
            ComponentManager.getManager().addActiveComponent(c);
        }
        this.fireCreatedView(v, c);
    }

    protected void destroyView(View v) {
        GUIComponent c = ((ComponentConfigCard)v.getComponent()).getComponent();
        if (ObjectUtil.equals(v, this.lastComponent)) {
            this.lastComponent = this.lastComponent.getWindowParent();
        }
        if (v.getWindowParent() != null) {
            v.close();
        }
        if (c.teardownWhenHidden()) {
            ComponentManager.getManager().removeActiveComponent(c);
            this.rootWindow.removeView(v);
            this.viewMap.removeView(c.getID());
        }
        this.fireDestroyedView(v, c);
    }

    public View getView(GUIComponent c) {
        return this.viewMap.getView(c.getID());
    }

    public Collection<View> getAllViews() {
        LinkedList<View> out = new LinkedList<View>();
        for (GUIComponent c : ComponentManager.getManager().getActiveComponents()) {
            out.add(this.getView(c));
        }
        return out;
    }

    @Override
    public String showComponent(GUIComponentFactory factory, GUIComponent target, String name, String label, boolean preferFloat, Rectangle floatRect) {
        View v = this.createView(factory, name, label);
        GUIComponent c = ((ComponentConfigCard)v.getComponent()).getComponent();
        boolean restoringFromCache = this.viewMap.contains(v);
        this.addView(v);
        this.addWindow(v, target, restoringFromCache, preferFloat, floatRect);
        return c.getID();
    }

    protected static Rectangle getFloatRectangle(View window) {
        Dimension d = window.getComponent().getPreferredSize();
        JFrame f = GUIManager.getManager().getFrame();
        int x = (int)((double)f.getX() + ((double)f.getWidth() - d.getWidth()) / 2.0);
        int y = (int)((double)f.getY() + ((double)f.getHeight() - d.getHeight()) / 2.0);
        return new Rectangle(x, y, d.width, d.height);
    }

    protected void addWindow(View window, GUIComponent targetComponent, boolean tryRestore, boolean preferFloat, Rectangle floatRect) {
        if (this.rootWindow == null) {
            return;
        }
        if (tryRestore) {
            window.restore();
        }
        if (window.getWindowParent() == null) {
            if (preferFloat) {
                if (floatRect == null) {
                    floatRect = IDWDriver.getFloatRectangle(window);
                }
                FloatingWindow w = this.rootWindow.createFloatingWindow(floatRect.getLocation(), floatRect.getSize(), (DockingWindow)window);
                w.addListener(this.floatingWindowCloseListener);
                w.getTopLevelAncestor().setVisible(true);
            } else {
                DockingWindow w;
                DockingWindow target = null;
                if (targetComponent != null) {
                    target = this.viewMap.getView(targetComponent.getID());
                }
                if (target == null) {
                    target = this.lastComponent;
                }
                if ((w = target == null || target.getWindowParent() == null ? this.rootWindow.getWindow() : target.getWindowParent()) == null) {
                    this.rootWindow.setWindow((DockingWindow)window);
                } else if (w instanceof TabWindow) {
                    ((TabWindow)w).addTab((DockingWindow)window);
                } else if (w instanceof SplitWindow) {
                    DockingWindow left = ((SplitWindow)w).getLeftWindow();
                    DockingWindow right = ((SplitWindow)w).getRightWindow();
                    ((SplitWindow)w).setWindows((DockingWindow)new TabWindow(), (DockingWindow)new TabWindow());
                    if (ObjectUtil.equals(target, left)) {
                        left = new TabWindow(new DockingWindow[]{left, window});
                    } else {
                        right = new TabWindow(new DockingWindow[]{right, window});
                    }
                    ((SplitWindow)w).setWindows(left, right);
                } else {
                    this.rootWindow.setWindow((DockingWindow)new TabWindow(new DockingWindow[]{w, window}));
                }
            }
        }
    }

    protected void configureComponent(JToggleButton button, View v) {
        ComponentConfigCard card = (ComponentConfigCard)v.getComponent();
        if (button.isSelected()) {
            v.getViewProperties().setTitle("Configuring: " + card.getComponent().getTitle());
            ConfigurationPanel panel = card.getConfigScreen();
            panel.setComponent(card.getComponent());
            panel.init();
        } else {
            v.getViewProperties().setTitle(card.getComponent().getTitle());
            card.getConfigScreen().commit();
        }
        card.toggle();
        card.repaint();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.configureTheme();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.configureTheme();
    }

    public Color getDarkColor() {
        return this.darkColor;
    }

    public void setDarkColor(Color darkColor) {
        this.darkColor = darkColor;
    }

    public Color getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(Color lightColor) {
        this.lightColor = lightColor;
    }

    public String getPerspectiveResourceDir() {
        return this.perspectiveResourceDir;
    }

    public void setPerspectiveResourceDir(String perspectiveResourceDir) {
        this.perspectiveResourceDir = perspectiveResourceDir;
    }

    public String getDefaultPerspectiveResourcePath() {
        return this.defaultPerspectiveResourcePath;
    }

    public void setDefaultPerspectiveResourcePath(String defaultPerspectiveResourcePath) {
        this.defaultPerspectiveResourcePath = defaultPerspectiveResourcePath;
    }

    public String getPerspectiveListResourcePath() {
        return this.perspectiveListResourcePath;
    }

    public void setPerspectiveListResourcePath(String perspectiveListResourcePath) {
        this.perspectiveListResourcePath = perspectiveListResourcePath;
    }

    @Override
    public void setComponentTitlebarTooltip(GUIComponent target, String label) {
        View v = this.getView(target);
        if (v == null) {
            return;
        }
        ViewTitleBar titleBar = SwingUtil.getDescendantOfType((Component)v, ViewTitleBar.class);
        if (titleBar == null) {
            return;
        }
        TabWindow tabWindow = (TabWindow)SwingUtilities.getAncestorOfClass(TabWindow.class, (Component)v);
        titleBar.setToolTipText(label);
        tabWindow.setToolTipText(label);
    }

    @Override
    public void setComponentTitlebarColor(GUIComponent target, Color color) {
        View v = this.getView(target);
        if (v == null) {
            return;
        }
        ViewTitleBar titleBar = SwingUtil.getDescendantOfType((Component)v, ViewTitleBar.class);
        TabWindow tabWindow = (TabWindow)SwingUtilities.getAncestorOfClass(TabWindow.class, (Component)v);
        if (tabWindow != null) {
            TabbedPanel panel = SwingUtil.getDescendantOfType((Component)tabWindow, TabbedPanel.class);
            if (panel == null) {
                return;
            }
            for (int i = 0; i < panel.getTabCount(); ++i) {
                Tab t = panel.getTabAt(i);
                if (!(t instanceof TitledTab)) continue;
                TitledTab tt = (TitledTab)t;
                if (!SwingUtilities.isDescendingFrom((Component)v, t.getContentComponent())) continue;
                tt.getProperties().getNormalProperties().getComponentProperties().setForegroundColor(color);
            }
        }
        if (titleBar != null) {
            titleBar.getLabel().setForeground(color);
        }
    }

    @Override
    public void setComponentLabel(GUIComponent target, String label) {
        View v = this.getView(target);
        if (v == null) {
            return;
        }
        ViewTitleBar titleBar = SwingUtil.getDescendantOfType((Component)v, ViewTitleBar.class);
        v.getViewProperties().getViewTitleBarProperties().getNormalProperties().setTitle(label);
        v.getViewProperties().getViewTitleBarProperties().getNormalProperties().setTitleVisible(true);
        v.getViewProperties().setTitle(label);
        TabWindow tabWindow = (TabWindow)SwingUtilities.getAncestorOfClass(TabWindow.class, (Component)v);
        if (tabWindow != null) {
            TabbedPanel panel = SwingUtil.getDescendantOfType((Component)tabWindow, TabbedPanel.class);
            if (panel == null) {
                return;
            }
            for (int i = 0; i < panel.getTabCount(); ++i) {
                Tab t = panel.getTabAt(i);
                if (!(t instanceof TitledTab)) continue;
                TitledTab tt = (TitledTab)t;
                if (!SwingUtilities.isDescendingFrom((Component)v, t.getContentComponent())) continue;
                tt.getProperties().getNormalProperties().setText(label);
                tt.setText(label);
            }
        }
        for (LayoutListener listener : this.layoutListeners) {
            listener.titleChanged(target, label);
        }
    }

    @Override
    public String getComponentLabel(GUIComponent c) {
        View v = this.getView(c);
        if (v == null) {
            return null;
        }
        return v.getViewProperties().getTitle();
    }

    @Override
    public Color getComponentTitlebarColor(GUIComponent c) {
        View v = this.getView(c);
        ViewTitleBar titleBar = SwingUtil.getDescendantOfType((Component)v, ViewTitleBar.class);
        return titleBar.getLabel().getForeground();
    }

    @Override
    public String getComponentTitlebarTooltip(GUIComponent c) {
        View v = this.getView(c);
        ViewTitleBar titleBar = SwingUtil.getDescendantOfType((Component)v, ViewTitleBar.class);
        return titleBar.getToolTipText();
    }

    @Override
    public boolean isFloating(GUIComponent c) {
        View v = this.getView(c);
        return v.isUndocked();
    }

    @Override
    public void setFloating(GUIComponent c, boolean floating) {
        View v = this.getView(c);
        if (floating) {
            JFrame f = GUIManager.getManager().getFrame();
            Rectangle r = IDWDriver.getFloatRectangle(v);
            v.undock(r.getLocation());
        } else {
            v.dock();
        }
    }

    @Override
    public void focusComponent(GUIComponent c) {
        this.getView(c).requestFocus();
        this.getView(c).restoreFocus();
    }

    @Override
    public void restoreComponent(GUIComponent c) {
        this.getView(c).restore();
    }

    @Override
    public void lockDockingPanels() {
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setDragEnabled(false);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setUndockEnabled(false);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setCloseEnabled(false);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setMinimizeEnabled(false);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setMaximizeEnabled(false);
    }

    @Override
    public void unlockDockingPanels() {
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setDragEnabled(true);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setUndockEnabled(true);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setCloseEnabled(true);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setMinimizeEnabled(true);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setMaximizeEnabled(true);
    }

    @Override
    public void lockOTE() {
    }

    @Override
    public void unlockOTE() {
    }

    protected class EditorField
    extends JTextField {
        protected View view;
        protected ViewTitleBar bar;

        public EditorField(View view, ViewTitleBar bar) {
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.getMaximumSize().getHeight()));
            this.bar = bar;
            this.view = view;
            this.setFont(bar.getLabel().getFont());
            this.setOpaque(false);
            this.setText(bar.getText());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorField.this.commit();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    EditorField.this.commit();
                }
            });
        }

        public void install() {
            JComponent[] comps = new JComponent[]{this};
            this.bar.setLeftTitleComponents(comps);
            this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties().setTitleVisible(false);
            this.requestFocus();
        }

        public void commit() {
            if (IDWDriver.getComponent(this.view) != null) {
                IDWDriver.this.setComponentLabel(IDWDriver.getComponent(this.view), this.getText());
            }
            this.bar.setLeftTitleComponents(new JComponent[0]);
        }
    }
}

