/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework.dock.idw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import net.infonode.docking.View;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.FlatIconButtonUI;
import net.infonode.gui.UIManagerUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.util.ColorUtil;
import org.apache.log4j.Logger;

public class IDWUtil {
    protected static final Logger logger = Logger.getLogger(IDWUtil.class);

    public static void setTitleBarColor(View view, Color focused, Color unfocused) {
        view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new SolidColorComponentPainter((ColorProvider)new FixedColorProvider(unfocused))).setOpaque(false);
        view.getViewProperties().getViewTitleBarProperties().getFocusedProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new SolidColorComponentPainter((ColorProvider)new FixedColorProvider(focused))).setOpaque(false);
    }

    public static JButton createFlatHighlightButton(Icon icon, String tooltipText, int padding, ActionListener action) {
        JButton b = new JButton(icon){

            @Override
            public void setUI(ButtonUI ui) {
                super.setUI((ButtonUI)new FlatIconButtonUI());
            }
        };
        b.setFocusable(false);
        b.setVerticalAlignment(0);
        b.setToolTipText(tooltipText);
        b.setMargin(new Insets(0, 0, 0, 0));
        new ButtonHighlighter(b, padding);
        b.setRolloverEnabled(true);
        if (action != null) {
            b.addActionListener(action);
        }
        return b;
    }

    public static JToggleButton createFlatHighlightToggleButton(Icon icon, String tooltipText, int padding, ActionListener action) {
        JToggleButton b = new JToggleButton(icon){

            @Override
            public void setUI(ButtonUI ui) {
                super.setUI((ButtonUI)new FlatIconButtonUI());
            }
        };
        b.setFocusable(false);
        b.setVerticalAlignment(0);
        b.setToolTipText(tooltipText);
        b.setMargin(new Insets(0, 0, 0, 0));
        new ButtonHighlighter(b, padding);
        b.setRolloverEnabled(true);
        if (action != null) {
            b.addActionListener(action);
        }
        return b;
    }

    protected static class ButtonHighlighter
    implements ComponentListener,
    HierarchyListener {
        private AbstractButton button;
        private Border pressedBorder;
        private Border highlightedBorder;
        private Border normalBorder;
        private boolean rollover;
        private long rolloverStart;

        ButtonHighlighter(AbstractButton button, int padding) {
            this.button = button;
            this.normalBorder = new EmptyBorder(padding + 2, padding + 2, padding + 2, padding + 2);
            this.pressedBorder = new EmptyBorder(padding + 2, padding + 2, padding, padding);
            this.highlightedBorder = new EmptyBorder(padding + 1, padding + 1, padding + 1, padding + 1);
            button.setContentAreaFilled(false);
            this.setNormalState();
            button.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    rollover = System.currentTimeMillis() - rolloverStart > 20L && button.getModel().isRollover();
                    this.update();
                    if (button.getModel().isRollover()) {
                        rolloverStart = 0L;
                    }
                }
            });
            button.addHierarchyListener(this);
            button.addComponentListener(this);
        }

        private void setNormalState() {
            this.button.setBackground(null);
            this.button.setOpaque(false);
            this.button.setBorder(this.normalBorder);
            this.rollover = false;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            this.setNormalState();
            this.rolloverStart = System.currentTimeMillis();
        }

        private void update() {
            boolean pressed = this.button.getModel().isArmed();
            if (this.button.isEnabled() && (this.rollover || pressed)) {
                this.button.setOpaque(true);
                Color backgroundColor = ComponentUtil.getBackgroundColor((Component)this.button.getParent());
                backgroundColor = backgroundColor == null ? UIManagerUtil.getColor((String)"control", (Color)Color.LIGHT_GRAY) : backgroundColor;
                this.button.setBackground(ColorUtil.mult((Color)backgroundColor, (double)(pressed ? 0.8 : 1.15)));
                this.button.setBorder(pressed ? new CompoundBorder(new LineBorder(ColorUtil.mult((Color)backgroundColor, (double)0.3)), this.pressedBorder) : new CompoundBorder(new LineBorder(ColorUtil.mult((Color)backgroundColor, (double)0.5)), this.highlightedBorder));
            } else {
                this.setNormalState();
            }
        }
    }
}

