/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.io;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class AuditedPrintStream
extends PrintStream {
    protected static final Logger logger = Logger.getLogger(AuditedPrintStream.class);
    protected int padding;
    protected PrintStream stream;
    protected boolean suppressStackTraces;

    public AuditedPrintStream(PrintStream stream) {
        this(stream, 0, false);
    }

    public AuditedPrintStream(PrintStream stream, int padding, boolean suppressStackTraces) {
        super(stream);
        this.stream = stream;
        this.padding = padding;
        this.suppressStackTraces = suppressStackTraces;
    }

    @Override
    public boolean checkError() {
        return this.stream.checkError();
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public void flush() {
        this.stream.flush();
    }

    @Override
    public void print(boolean b) {
        this.stream.print(b);
    }

    @Override
    public void print(char c) {
        this.stream.print(c);
    }

    @Override
    public void print(char[] s) {
        this.stream.print(s);
    }

    @Override
    public void print(double d) {
        this.stream.print(d);
    }

    @Override
    public void print(float f) {
        this.stream.print(f);
    }

    @Override
    public void print(int i) {
        this.stream.print(i);
    }

    @Override
    public void print(long l) {
        this.stream.print(l);
    }

    @Override
    public void print(Object obj) {
        this.stream.print(obj);
    }

    @Override
    public void print(String s) {
        this.stream.print(s);
    }

    @Override
    public void println() {
        this.printLeader();
        this.stream.println();
    }

    @Override
    public void println(boolean x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(char x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(char[] x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(double x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(float x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(int x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(long x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(Object x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    public void println(String x) {
        this.printLeader();
        this.stream.println(x);
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.stream.write(buf, off, len);
    }

    @Override
    public void write(int b) {
        this.stream.write(b);
    }

    protected StackTraceElement getFirstInterestingElement(Exception e) {
        StackTraceElement[] elts = e.getStackTrace();
        for (int i = 0; i < elts.length; ++i) {
            Class<?> c = null;
            try {
                c = Class.forName(elts[i].getClassName());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (c == null || Exception.class.isAssignableFrom(c) || OutputStream.class.isAssignableFrom(c)) continue;
            return elts[i];
        }
        return null;
    }

    protected void printLeader() {
        Exception e = new Exception();
        StackTraceElement elt = this.getFirstInterestingElement(e);
        if (!(elt == null || elt.getFileName() == null || elt.getFileName().equals("Throwable.java") && this.suppressStackTraces)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(elt.getFileName());
            buffer.append(':');
            buffer.append(elt.getLineNumber());
            buffer.append(':');
            for (int i = buffer.length(); i < this.padding; ++i) {
                buffer.append(' ');
            }
            this.stream.print(buffer.toString());
        }
    }
}

