/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.io;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.log4j.Logger;

public class ExtensionFilenameFilter
implements FilenameFilter {
    protected static final Logger logger = Logger.getLogger(ExtensionFilenameFilter.class);
    protected String[] extensions;
    protected String desc;
    protected boolean showHidden;

    private static String[] createExtensionArray(String ext) {
        String[] exts = new String[]{ext};
        return exts;
    }

    public ExtensionFilenameFilter(String extension) {
        this(extension, null);
    }

    public ExtensionFilenameFilter(String extension, String desc) {
        this(ExtensionFilenameFilter.createExtensionArray(extension), desc);
    }

    public ExtensionFilenameFilter(String[] extensions) {
        this(extensions, null);
    }

    public ExtensionFilenameFilter(String[] extensions, String desc) {
        this.extensions = extensions;
        this.desc = desc;
        this.showHidden = false;
    }

    @Override
    public boolean accept(File dir, String file) {
        File path = new File(dir, file);
        if (!this.showHidden && file.startsWith(".")) {
            return false;
        }
        if (path.isDirectory()) {
            return true;
        }
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!file.endsWith("." + this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public boolean getShowHidden() {
        return this.showHidden;
    }

    protected String getExtensionDesc() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (i > 0) {
                out.append(",");
            }
            out.append("*." + this.extensions[i]);
        }
        return out.toString();
    }

    public String toString() {
        if (this.desc == null) {
            return this.getExtensionDesc();
        }
        return this.desc + " (" + this.getExtensionDesc() + ")";
    }
}

