/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtil {
    protected static final Logger logger = Logger.getLogger(FileUtil.class);
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DASH = "-";
    public static final String UNDERSCORE = "_";
    public static final String DOT = ".";

    public static void ensureExists(File file, String resource) throws IOException {
        ClassLoader loader = FileUtil.getSystemClassLoader();
        FileUtil.ensureExists(file, loader, resource);
    }

    public static void ensureExists(File file, ClassLoader loader, String resource) throws IOException {
        if (file.exists()) {
            return;
        }
        if (loader == null) {
            throw new IOException("ClassLoader is null, can't load resource.");
        }
        if (resource == null) {
            throw new NullPointerException("Can't load from null resource");
        }
        InputStream is = loader.getResourceAsStream(resource);
        if (is == null) {
            try {
                is = FileUtil.findInputStream(resource);
            }
            catch (FileNotFoundException e) {
                Path currentRelativePath = Paths.get("", new String[0]);
                String s = currentRelativePath.toAbsolutePath().toString();
                String resourcePath = s + File.separator + resource;
                is = FileUtil.findInputStream(resourcePath);
            }
            if (is == null) {
                throw new FileNotFoundException("Couldn't find resource " + resource);
            }
        }
        new File(file.getParent()).mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        logger.info((Object)("Creating " + file.getAbsolutePath() + " from resource " + resource));
        int next = is.read();
        while (next != -1) {
            ((OutputStream)os).write(next);
            next = is.read();
        }
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    private static InputStream findInputStream(String resource) throws FileNotFoundException {
        URL u = FileUtil.class.getResource(resource);
        if (u == null) {
            throw new FileNotFoundException("cant get resource " + resource);
        }
        InputStream is = null;
        try {
            is = u.openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is == null) {
            throw new FileNotFoundException("failed to open stream " + resource);
        }
        return is;
    }

    public static ClassLoader getSystemClassLoader() {
        try {
            Method loaderMethod = ClassLoader.class.getMethod("getSystemClassLoader", new Class[0]);
            Object out = loaderMethod.invoke(null, new Object[0]);
            return (ClassLoader)out;
        }
        catch (Exception e) {
            return Class.class.getClassLoader();
        }
    }

    public static URL findUrl(String filename) throws FileNotFoundException {
        if (filename == null) {
            String m = "cant find null file";
            logger.error((Object)m);
            System.out.println(m);
            throw new FileNotFoundException(m);
        }
        List<URL> possibleUrls = FileUtil.getPossibleUrls(filename);
        for (URL u : possibleUrls) {
            if (!FileUtil.urlExists(u)) continue;
            return u;
        }
        throw new FileNotFoundException(filename + " not found");
    }

    private static List<URL> getPossibleUrls(String filename) {
        ArrayList<URL> urls = new ArrayList<URL>(5);
        if (filename == null) {
            System.out.println("cant find null file");
            logger.error((Object)"cant find null file");
            return urls;
        }
        FileUtil.addFile(filename, urls);
        FileUtil.addFile("conf/" + filename, urls);
        FileUtil.addFile("images/" + filename, urls);
        FileUtil.addFile(FileUtil.getOboDir().getPath() + "/" + filename, urls);
        FileUtil.addFile("obo-files/" + filename, urls);
        return urls;
    }

    private static void addFile(String filename, List<URL> urls) {
        if (filename == null) {
            System.out.println("cant find null file");
            logger.error((Object)"cant find null file");
            return;
        }
        try {
            URL jarUrl;
            URL u = new File(filename).toURL();
            if (u != null) {
                urls.add(u);
            }
            if ((jarUrl = FileUtil.class.getResource(filename)) != null) {
                urls.add(jarUrl);
            }
            if ((jarUrl = FileUtil.class.getResource("/" + filename)) != null) {
                urls.add(jarUrl);
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)("bad file url " + e));
        }
    }

    public static boolean urlExists(URL u) {
        try {
            u.openStream();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static File getOboDir() {
        return FileUtil.getSubDir("obo-files");
    }

    private static File getSubDir(String subdirString) {
        File d = FileUtil.getDotHomeDir();
        File subdir = new File(d, subdirString);
        if (!subdir.exists()) {
            logger.info((Object)("creating " + subdir + " directory"));
            subdir.mkdir();
        }
        return subdir;
    }

    public static File getDotHomeDir() {
        String home = System.getProperty("user.home");
        String app_name = System.getProperty("application");
        File dotHome = new File(FileUtil.sep(home, DOT + app_name));
        if (!dotHome.exists()) {
            logger.info((Object)("creating " + dotHome + " directory"));
            dotHome.mkdir();
        }
        return dotHome;
    }

    private static String sep(String a, String b) {
        return a + FILE_SEPARATOR + b;
    }
}

