/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.bbop.io.IOUtil;

public class SafeFileOutputStream
extends OutputStream {
    protected static final Logger logger = Logger.getLogger(SafeFileOutputStream.class);
    protected File tempFile;
    protected File file;
    protected FileOutputStream stream;
    protected boolean deleteOnFail;

    public SafeFileOutputStream(String path) throws IOException {
        this(path, true);
    }

    public SafeFileOutputStream(File file) throws IOException {
        this(file, true);
    }

    public SafeFileOutputStream(String path, boolean deleteOnFail) throws IOException {
        this(new File(path));
    }

    public SafeFileOutputStream(File file, boolean deleteOnFail) throws IOException {
        this.deleteOnFail = deleteOnFail;
        this.tempFile = File.createTempFile("temp", "output");
        this.stream = new FileOutputStream(this.tempFile);
        this.tempFile.deleteOnExit();
        this.file = file;
    }

    @Override
    public void flush() throws IOException {
        try {
            this.stream.flush();
        }
        catch (IOException ex) {
            this.tempFile.delete();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.tempFile.delete();
            throw ex;
        }
    }

    public void fail() throws IOException {
        this.stream.close();
        if (this.deleteOnFail) {
            this.tempFile.delete();
        }
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public void finalize() throws IOException {
        this.fail();
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.stream.write(b);
        }
        catch (IOException ex) {
            this.tempFile.delete();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.tempFile.delete();
            throw ex;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.stream.write(b, off, len);
        }
        catch (IOException ex) {
            this.tempFile.delete();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.tempFile.delete();
            throw ex;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.stream.write(b);
        }
        catch (IOException ex) {
            this.tempFile.delete();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.tempFile.delete();
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
            this.file.delete();
            IOUtil.copyFile(this.tempFile, this.file);
            this.tempFile.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.tempFile.delete();
            throw ex;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            this.tempFile.delete();
            throw ex;
        }
    }
}

