/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.rdbms.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.rdbms.ConstraintSet;
import org.bbop.rdbms.RelationalQuery;
import org.bbop.rdbms.WhereClause;
import org.bbop.rdbms.impl.AbstractRelationalTerm;
import org.bbop.rdbms.impl.SqlConstraintSetImpl;

public class SqlWhereClauseImpl
extends AbstractRelationalTerm
implements WhereClause {
    protected static final Logger logger = Logger.getLogger(SqlWhereClauseImpl.class);
    protected ConstraintSet constraintSet = new SqlConstraintSetImpl();
    protected Collection<Object> placeHolderVals = new LinkedList<Object>();

    public SqlWhereClauseImpl(String s) {
        this.constraintSet.addConstraint(s);
    }

    public SqlWhereClauseImpl() {
    }

    @Override
    public ConstraintSet getConstraintSet() {
        return this.constraintSet;
    }

    @Override
    public void setConstraintSet(ConstraintSet constraintTerm) {
        this.constraintSet = constraintTerm;
    }

    @Override
    public void addConstraint(String s) {
        this.constraintSet.addConstraint(s);
    }

    @Override
    public void addOperatorConstraint(String op, String arg1, Object arg2) {
        this.constraintSet.addConstraint(arg1 + " " + op + " ?");
        this.placeHolderVals.add(arg2);
    }

    @Override
    public void addInConstraint(String s, Collection<?> in) {
        if (in.size() == 0) {
            this.constraintSet.addConstraint("1=0");
        } else {
            this.constraintSet.addConstraint(s + " IN (" + this.concatValues(",", in) + ")");
        }
    }

    @Override
    public void addContainsAllConstraint(String colName, String in) {
        String[] parts = in.split("\\s");
        String constraints = "(";
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].trim().length() <= 0) continue;
            if (i > 0) {
                constraints = constraints + " AND ";
            }
            constraints = constraints + this.lower(colName) + " LIKE " + this.lower("?");
            this.placeHolderVals.add("%" + parts[i].trim() + "%");
        }
        constraints = constraints + ")";
        this.constraintSet.addConstraint(constraints);
    }

    @Override
    public void addLikeConstraint(String colName, String in) {
        this.constraintSet.addConstraint("(" + colName + " LIKE '%" + in.trim() + "%')");
    }

    @Override
    public void addCaseInsensitiveRegexConstraint(String colName, String in) {
        this.constraintSet.addConstraint(colName + " ~* '.*" + in.trim() + ".*'");
    }

    @Override
    public void addContainsAnyConstraint(String colName, String in) {
        String[] parts = in.split("\\s");
        String constraints = "(";
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].trim().length() <= 0) continue;
            if (i > 0) {
                constraints = constraints + " OR ";
            }
            constraints = constraints + this.lower(colName) + " LIKE " + this.lower("?");
            this.placeHolderVals.add("%" + parts[i].trim() + "%");
        }
        constraints = constraints + ")";
        this.constraintSet.addConstraint(constraints);
    }

    private String lower(String s) {
        return "lower(" + s + ")";
    }

    @Override
    public void addInConstraint(String s, RelationalQuery subQuery) {
        this.constraintSet.addConstraint(s + " IN (" + subQuery.toSQL() + ")");
        this.placeHolderVals.addAll(subQuery.getPlaceHolderVals());
    }

    @Override
    public void addNotInConstraint(String s, RelationalQuery subQuery) {
        this.constraintSet.addConstraint(s + " NOT IN (" + subQuery.toSQL() + ")");
        this.placeHolderVals.addAll(subQuery.getPlaceHolderVals());
    }

    @Override
    public void addEqualityConstraint(String col, Object val) {
        this.constraintSet.addConstraint(col + " = ?");
        this.placeHolderVals.add(val);
    }

    @Override
    public void addJoinConstraint(String col1, String col2) {
        this.constraintSet.addConstraint(col1 + " = " + col2);
    }

    @Override
    public WhereClause.BooleanOperator getOperator() {
        return this.constraintSet.getOperator();
    }

    @Override
    public void setOperator(WhereClause.BooleanOperator operator) {
        this.constraintSet.setOperator(operator);
    }

    @Override
    public String toSQL() {
        if (this.constraintSet.isEmpty()) {
            return "";
        }
        return "WHERE " + this.constraintSet.toSQL();
    }

    @Override
    public Collection<Object> getPlaceHolderVals() {
        return this.placeHolderVals;
    }

    public void setPlaceHolderVals(Collection<Object> placeHolderVals) {
        this.placeHolderVals = placeHolderVals;
    }

    @Override
    public void addDisjunctiveConstraints(WhereClause subClause) {
        subClause.setOperator(WhereClause.BooleanOperator.OR);
        this.constraintSet.addConstraint("(" + subClause.getConstraintSet().toSQL() + ")");
        this.placeHolderVals.addAll(subClause.getPlaceHolderVals());
    }
}

