/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.bbop.swing.DynamicMenuItem;
import org.bbop.util.ObjectUtil;

public abstract class AbstractDynamicMenuItem
extends JMenu
implements DynamicMenuItem {
    protected boolean bracketTop;
    protected boolean bracketBottom;
    protected boolean merge;
    protected boolean addSep = false;

    public AbstractDynamicMenuItem(String s) {
        this(s, true, false, false);
    }

    public AbstractDynamicMenuItem(String s, boolean merge, boolean bracketTop, boolean bracketBottom) {
        super(s, true);
        this.setName(AbstractDynamicMenuItem.escapeID(s));
        this.bracketTop = bracketTop;
        this.bracketBottom = bracketBottom;
        this.merge = merge;
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                AbstractDynamicMenuItem.this.buildMenu();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                AbstractDynamicMenuItem.super.removeAll();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                AbstractDynamicMenuItem.super.removeAll();
            }
        });
    }

    protected void addItemToMenu(Component o, boolean isFirst, boolean isLast) {
        if (o instanceof DynamicMenuItem && ((DynamicMenuItem)((Object)o)).getMerge()) {
            Component last;
            DynamicMenuItem dmi = (DynamicMenuItem)((Object)o);
            if (dmi.bracketTop() && !isFirst && !((last = this.getMenuComponent(this.getMenuComponentCount() - 1)) instanceof JSeparator)) {
                this.addSep = true;
            }
            if (this.addSep) {
                super.addSeparator();
                this.addSep = false;
            }
            int j = 0;
            List<? extends Component> items = dmi.getItems();
            for (Component component : items) {
                this.addItemToMenu(component, j == 0, j >= items.size() - 1);
                ++j;
            }
            if (dmi.bracketBottom() && this.getMenuComponentCount() > 0 && !isLast) {
                this.addSep = true;
            }
        } else if (o instanceof JMenuItem) {
            if (this.addSep) {
                super.addSeparator();
                this.addSep = false;
            }
            super.add((JMenuItem)o);
        } else if (o instanceof Component) {
            if (this.addSep) {
                if (!(o instanceof JSeparator)) {
                    super.addSeparator();
                }
                this.addSep = false;
            }
            super.add(o);
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (!pressed) {
            return false;
        }
        if (ks == null) {
            return false;
        }
        List<? extends Component> items = this.getItems();
        for (Component component : items) {
            if (!this.processComponent(ks, component)) continue;
            return true;
        }
        return false;
    }

    protected boolean processComponent(KeyStroke ks, Component c) {
        block5: {
            block4: {
                if (!c.isEnabled()) {
                    return false;
                }
                if (c instanceof JMenuItem && ObjectUtil.equals(((JMenuItem)c).getAccelerator(), ks)) {
                    ((JMenuItem)c).doClick();
                    return true;
                }
                if (!(c instanceof DynamicMenuItem)) break block4;
                for (Component component : ((DynamicMenuItem)((Object)c)).getItems()) {
                    if (!this.processComponent(ks, component)) continue;
                    return true;
                }
                break block5;
            }
            if (!(c instanceof Container)) break block5;
            for (Component child : ((Container)c).getComponents()) {
                if (!this.processComponent(ks, child)) continue;
                return true;
            }
        }
        return false;
    }

    public void buildMenu() {
        super.removeAll();
        this.addSep = false;
        int index = 0;
        List<? extends Component> items = this.getItems();
        for (Component component : items) {
            this.addItemToMenu(component, index == 0, index >= items.size() - 1);
            ++index;
        }
        this.setEnabled(items.size() > 0);
    }

    protected static String escapeID(String s) {
        return s.replace(':', '_').replace('|', '_');
    }

    @Override
    public boolean getMerge() {
        return this.merge;
    }

    @Override
    public boolean bracketBottom() {
        return this.bracketBottom;
    }

    @Override
    public boolean bracketTop() {
        return this.bracketTop;
    }

    @Override
    public void addSeparator() {
    }

    @Override
    public JMenuItem add(Action a) {
        return null;
    }

    @Override
    public Component add(Component c) {
        return null;
    }

    @Override
    public Component add(Component c, int index) {
        return null;
    }

    @Override
    public void add(Component comp, Object constraints) {
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        return null;
    }

    @Override
    public synchronized void add(PopupMenu popup) {
    }

    @Override
    public Component add(String name, Component comp) {
        return null;
    }

    @Override
    public JMenuItem add(String s) {
        return null;
    }

    @Override
    public void remove(Component c) {
    }

    @Override
    public void remove(int pos) {
    }

    @Override
    public void remove(JMenuItem item) {
    }

    @Override
    public synchronized void remove(MenuComponent popup) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public Component getMenuComponent(int n) {
        return this.getItems().get(n);
    }

    @Override
    public int getMenuComponentCount() {
        return this.getItems().size();
    }

    @Override
    public Component[] getMenuComponents() {
        List<? extends Component> items = this.getItems();
        return items.toArray(new Component[items.size()]);
    }

    public boolean isBracketTop() {
        return this.bracketTop;
    }

    public void setBracketTop(boolean bracketTop) {
        this.bracketTop = bracketTop;
    }

    public boolean isBracketBottom() {
        return this.bracketBottom;
    }

    public void setBracketBottom(boolean bracketBottom) {
        this.bracketBottom = bracketBottom;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }
}

