/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.util.TaskDelegate;

public abstract class AbstractPeriodicUpdateRunnable
implements Runnable {
    protected Timer timer;
    protected BackgroundEventQueue queue;
    protected boolean swingFriendly;

    public AbstractPeriodicUpdateRunnable(BackgroundEventQueue queue, boolean swingFriendly) {
        this.queue = queue;
        this.swingFriendly = swingFriendly;
    }

    protected abstract void setupUpdate();

    protected abstract void cleanupUpdate();

    protected abstract void doUpdate(TaskDelegate<?> var1);

    protected abstract boolean isCancelled();

    @Override
    public void run() {
        this.clearTimer();
        if (this.swingFriendly) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractPeriodicUpdateRunnable.this.setupUpdate();
                }
            });
        } else {
            this.setupUpdate();
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                AbstractPeriodicUpdateRunnable.this.updateStep();
            }
        }, 100L, 200L);
    }

    protected void clearTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        if (this.swingFriendly) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractPeriodicUpdateRunnable.this.cleanupUpdate();
                }
            });
        } else {
            this.cleanupUpdate();
        }
    }

    protected TaskDelegate<?> getCurrentTask() {
        return this.queue.getCurrentTask();
    }

    protected void updateStep() {
        final TaskDelegate<?> currentTask = this.getCurrentTask();
        if (currentTask == null) {
            this.clearTimer();
        } else if (this.isCancelled()) {
            this.queue.cancelAll();
            this.clearTimer();
        } else if (this.swingFriendly) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractPeriodicUpdateRunnable.this.doUpdate(currentTask);
                }
            });
        } else {
            this.doUpdate(currentTask);
        }
    }

    public void install() {
        this.queue.addStartupNotifier(this);
    }

    public void shutdown() {
        this.queue.removeStartupNotifier(this);
    }
}

