/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class BackgroundImagePanel
extends JPanel
implements ImageObserver {
    protected static final Logger logger = Logger.getLogger(BackgroundImagePanel.class);
    private static final long serialVersionUID = -7879156272563295319L;
    protected Image backgroundImage;
    protected volatile Image workingImage;
    protected Image tempImage;
    protected boolean scaleImage;
    protected boolean keepAspect = true;

    public BackgroundImagePanel() {
        this(false);
    }

    public BackgroundImagePanel(boolean scale) {
        super.setOpaque(false);
        this.setScaleImage(scale);
    }

    public BackgroundImagePanel(Image image) {
        this();
        this.setBackground(image);
    }

    public BackgroundImagePanel(String imagePath) {
        this();
        this.setBackground(imagePath);
    }

    public BackgroundImagePanel(URL imagePath) {
        this();
        this.setBackground(imagePath);
    }

    public BackgroundImagePanel(Image image, boolean scale) {
        this(scale);
        this.setBackground(image);
    }

    public BackgroundImagePanel(String imagePath, boolean scale) {
        this(scale);
        this.setBackground(imagePath);
    }

    public BackgroundImagePanel(URL imagePath, boolean scale) {
        this(scale);
        this.setBackground(imagePath);
    }

    public void setKeepAspect(boolean keepAspect) {
        this.keepAspect = keepAspect;
        if (this.scaleImage) {
            this.resizeImage();
        }
    }

    public void setScaleImage(boolean scale) {
        this.scaleImage = scale;
        if (this.scaleImage) {
            this.resizeImage();
        } else {
            this.workingImage = this.backgroundImage;
        }
    }

    public void setBackground(String filename) {
        Image image = Toolkit.getDefaultToolkit().getImage(filename);
        this.setBackground(image);
    }

    public void setBackground(URL filename) {
        Image image = Toolkit.getDefaultToolkit().getImage(filename);
        this.loadImage(image);
        this.setBackground(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(Image image) {
        MediaTracker tracker;
        MediaTracker mediaTracker = tracker = new MediaTracker(this);
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            int loadStatus = tracker.statusID(0, false);
            tracker.removeImage(image, 0);
        }
        this.repaint();
    }

    public void setBackground(Image image) {
        this.backgroundImage = image;
        if (this.scaleImage) {
            this.resizeImage();
        } else {
            this.workingImage = image;
        }
    }

    public Image getImage() {
        return this.backgroundImage;
    }

    protected void resizeImage() {
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.backgroundImage != null && width > 0 && height > 0) {
            if (this.keepAspect) {
                double scaleFactor = (double)width / (double)this.backgroundImage.getWidth(null);
                height = (int)((double)this.backgroundImage.getHeight(null) * scaleFactor);
                if (width > this.getWidth() || height > this.getHeight()) {
                    height = this.getHeight();
                    scaleFactor = (double)height / (double)this.backgroundImage.getHeight(null);
                    width = (int)((double)this.backgroundImage.getWidth(null) * scaleFactor);
                }
            }
            this.workingImage = this.backgroundImage.getScaledInstance(width, height, 2);
            this.loadImage(this.workingImage);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.scaleImage) {
            this.resizeImage();
        }
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        if (this.scaleImage) {
            this.resizeImage();
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        if (this.scaleImage) {
            this.resizeImage();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.scaleImage) {
            this.resizeImage();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (g != null) {
            if (this.backgroundImage != null) {
                int x = 0;
                int y = 0;
                if (this.workingImage.getWidth(null) < this.getWidth()) {
                    x = (this.getWidth() - this.workingImage.getWidth(null)) / 2;
                }
                if (this.workingImage.getHeight(null) < this.getHeight()) {
                    y = (this.getHeight() - this.workingImage.getHeight(null)) / 2;
                }
                g.drawImage(this.workingImage, x, y, null);
            }
            super.paint(g);
        }
    }
}

