/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class CachedPanel
extends JPanel {
    protected static final Logger logger = Logger.getLogger(CachedPanel.class);
    private static final long serialVersionUID = 8061084982652763299L;
    protected Dimension cacheDim;
    protected Hashtable rows;
    protected Rectangle clipBounds;
    protected boolean useSoftReferences = true;
    protected boolean useCache = true;
    private Color boxColor = Color.yellow;
    private ReferenceQueue queue = new ReferenceQueue();

    public CachedPanel() {
        this.cacheDim = new Dimension(100, 100);
        this.rows = new Hashtable();
        this.clipBounds = new Rectangle();
    }

    public void setCacheDimensions(Dimension d) {
        this.cacheDim = new Dimension(d);
        this.dumpCache();
    }

    public Dimension getCacheDimensions() {
        return this.cacheDim;
    }

    @Override
    public void paint(Graphics g) {
        if (this.useCache) {
            this.clipBounds = g.getClipBounds(this.clipBounds);
            int sectorx = this.clipBounds.x / this.cacheDim.width;
            int sectory = this.clipBounds.y / this.cacheDim.height;
            int sectorWidth = 2 + this.clipBounds.width / this.cacheDim.width;
            int sectorHeight = 2 + this.clipBounds.height / this.cacheDim.height;
            for (int i = sectorx; i < sectorx + sectorWidth; ++i) {
                for (int j = sectory; j < sectory + sectorHeight; ++j) {
                    this.paintSector(g, i, j);
                }
            }
        } else {
            this.doPaint(g);
        }
    }

    protected void paintSector(Graphics g, int x, int y) {
        Integer intx = new Integer(x);
        Integer inty = new Integer(y);
        Object hashKey = this.getHashKey(intx, inty);
        int pixelx = x * this.cacheDim.width;
        int pixely = y * this.cacheDim.height;
        Image cached = this.fetchImage(hashKey);
        if (cached == null) {
            cached = this.buildImage(this.cacheDim, pixelx, pixely);
            this.storeImage(hashKey, cached);
        }
        g.drawImage(cached, pixelx, pixely, null);
        if (this.boxColor != null) {
            g.setColor(this.boxColor);
            g.drawRect(pixelx, pixely, this.cacheDim.width, this.cacheDim.height);
        }
    }

    protected void storeImage(Object key, Image image) {
        if (this.useSoftReferences) {
            this.rows.put(key, new SoftReference<Image>(image));
        } else {
            this.rows.put(key, image);
        }
    }

    protected Image fetchImage(Object key) {
        Object image = null;
        if (this.useSoftReferences) {
            SoftReference ref = (SoftReference)this.rows.get(key);
            if (ref != null) {
                return (Image)ref.get();
            }
            return null;
        }
        return (Image)this.rows.get(key);
    }

    protected Image buildImage(Dimension cacheDim, int pixelx, int pixely) {
        BufferedImage cached = new BufferedImage(cacheDim.width, cacheDim.height, 2);
        Graphics graphics = ((Image)cached).getGraphics().create();
        graphics.translate(-pixelx, -pixely);
        graphics.setClip(pixelx, pixely, cacheDim.width, cacheDim.height);
        this.doPaint(graphics);
        return cached;
    }

    public void doPaint(Graphics g) {
        super.paint(g);
    }

    public void dumpCache(Rectangle dirtyRegion) {
        int sectorx = dirtyRegion.x / this.cacheDim.width;
        int sectory = dirtyRegion.y / this.cacheDim.height;
        int sectorWidth = 2 + dirtyRegion.width / this.cacheDim.width;
        int sectorHeight = 2 + dirtyRegion.height / this.cacheDim.height;
        for (int i = sectorx; i < sectorx + sectorWidth; ++i) {
            for (int j = sectory; j < sectory + sectorHeight; ++j) {
                Object key = this.getHashKey(new Integer(i), new Integer(j));
                this.rows.remove(key);
            }
        }
    }

    protected Object getHashKey(Integer x, Integer y) {
        return x + "-" + y;
    }

    public void dumpCache() {
        this.rows = new Hashtable();
    }

    public boolean getUseSoftReferences() {
        return this.useSoftReferences;
    }

    public void setUseSoftReferences(boolean use) {
        this.useSoftReferences = use;
        this.dumpCache();
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public static void main(String[] args) {
        Thing thing = new Thing();
        thing.setPreferredSize(new Dimension(2000, 1000));
        JScrollPane pane = new JScrollPane(thing);
        pane.setSize(200, 200);
        pane.setPreferredSize(new Dimension(200, 200));
        JDialog dialog = new JDialog();
        dialog.setTitle("Cached");
        dialog.getContentPane().add(pane);
        dialog.setSize(600, 600);
        dialog.show();
    }

    public static class Thing
    extends CachedPanel {
        private static final long serialVersionUID = -2668631913940388574L;
        Rectangle clipRect = new Rectangle();

        @Override
        public void doPaint(Graphics g) {
            this.clipRect = g.getClipBounds(this.clipRect);
            g.setColor(Color.white);
            g.fillRect(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
            for (int i = this.clipRect.x; i < this.clipRect.x + this.clipRect.width; ++i) {
                for (int j = this.clipRect.y; j < this.clipRect.y + this.clipRect.height; ++j) {
                    int count = i * this.getSize().width + j;
                    g.setColor(new Color(count));
                    g.drawLine(i, j, i, j);
                }
            }
        }
    }
}

