/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;
import org.apache.log4j.Logger;

public class CustomLinebreakHTMLEditorKit
extends HTMLEditorKit {
    protected static final Logger logger = Logger.getLogger(CustomLinebreakHTMLEditorKit.class);
    protected ViewFactory defaultFactory = new CustomHTMLFactory();

    protected boolean isBreakCharacter(char c) {
        return Character.isWhitespace(c) || c == '-' || c == '_';
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.defaultFactory;
    }

    public class CustomLinebreakInlineView
    extends InlineView {
        public CustomLinebreakInlineView(Element elem) {
            super(elem);
        }

        @Override
        public View breakView(int axis, int p0, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                int breakSpot = this.getBreakSpot(p0, p1);
                if (breakSpot != -1) {
                    p1 = breakSpot;
                }
                if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
                    return this;
                }
                GlyphView v = (GlyphView)this.createFragment(p0, p1);
                return v;
            }
            return this;
        }

        protected int getBreakSpot(int p0, int p1) {
            Segment s = this.getText(p0, p1);
            char ch = s.last();
            while (ch != '\uffff') {
                if (CustomLinebreakHTMLEditorKit.this.isBreakCharacter(ch)) {
                    return s.getIndex() - s.getBeginIndex() + 1 + p0;
                }
                ch = s.previous();
            }
            return -1;
        }
    }

    public class CustomHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        @Override
        public View create(Element elem) {
            HTML.Tag kind;
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag && (kind = (HTML.Tag)o) == HTML.Tag.CONTENT) {
                return new CustomLinebreakInlineView(elem);
            }
            return super.create(elem);
        }
    }

    protected static class SegmentCache {
        private static SegmentCache sharedCache = new SegmentCache();
        private List segments = new ArrayList(11);

        public static SegmentCache getSharedInstance() {
            return sharedCache;
        }

        public static Segment getSharedSegment() {
            return SegmentCache.getSharedInstance().getSegment();
        }

        public static void releaseSharedSegment(Segment segment) {
            SegmentCache.getSharedInstance().releaseSegment(segment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment getSegment() {
            SegmentCache segmentCache = this;
            synchronized (segmentCache) {
                int size = this.segments.size();
                if (size > 0) {
                    return (Segment)this.segments.remove(size - 1);
                }
            }
            return new CachedSegment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSegment(Segment segment) {
            if (segment instanceof CachedSegment) {
                SegmentCache segmentCache = this;
                synchronized (segmentCache) {
                    segment.array = null;
                    segment.count = 0;
                    this.segments.add(segment);
                }
            }
        }

        private static class CachedSegment
        extends Segment {
            private CachedSegment() {
            }
        }
    }
}

