/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.bbop.swing.AbstractDynamicMenuItem;

public class DynamicMenu
extends AbstractDynamicMenuItem {
    protected static final Logger logger = Logger.getLogger(DynamicMenu.class);
    protected List<Component> items = new LinkedList<Component>();

    public DynamicMenu(String s, boolean merge, boolean bracketTop, boolean bracketBottom) {
        super(s, merge, bracketTop, bracketBottom);
    }

    public DynamicMenu(String s) {
        super(s, false, false, false);
    }

    public List<Component> getItems() {
        return this.items;
    }

    public List<Component> getDynamicItems() {
        return null;
    }

    @Override
    public void addSeparator() {
        this.items.add(new JSeparator());
    }

    @Override
    public JMenuItem add(Action a) {
        JMenuItem item = new JMenuItem(a);
        this.items.add(item);
        return item;
    }

    @Override
    public Component add(Component c) {
        this.items.add(c);
        return c;
    }

    @Override
    public Component add(Component c, int index) {
        if (index == -1) {
            index = this.items.size();
        }
        this.items.add(index, c);
        return c;
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.items.add(comp);
        super.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.items.add(comp);
        super.add(comp, constraints, index);
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.items.add(menuItem);
        return menuItem;
    }

    @Override
    public synchronized void add(PopupMenu popup) {
        throw new UnsupportedOperationException("Cannot add non-components to dynamic menu");
    }

    @Override
    public Component add(String name, Component comp) {
        return this.add(comp);
    }

    @Override
    public JMenuItem add(String s) {
        JMenuItem item = new JMenuItem(s);
        this.items.add(item);
        return item;
    }

    @Override
    public void remove(Component c) {
        this.items.remove(c);
        super.remove(c);
    }

    @Override
    public void remove(int pos) {
        this.items.remove(pos);
        super.remove(pos);
    }

    @Override
    public void remove(JMenuItem item) {
        this.items.remove(item);
        super.remove(item);
    }

    @Override
    public synchronized void remove(MenuComponent popup) {
        this.items.remove(popup);
        super.remove(popup);
    }

    @Override
    public void removeAll() {
        this.items.clear();
        super.removeAll();
    }
}

