/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import org.apache.log4j.Logger;
import org.bbop.swing.AbstractShapeExtender;
import org.bbop.swing.PathOpList;

public class EndpointShapeExtender
extends AbstractShapeExtender {
    protected static final Logger logger = Logger.getLogger(EndpointShapeExtender.class);

    @Override
    protected void addPoints(PathOpList source, int startSourceIndex, int endSourceIndex, PathOpList target, int startTargetIndex, int endTargetIndex) {
        int i;
        PathOpList smallerList;
        int smallerEndIndex;
        int smallerStartIndex;
        int newNodeCount;
        if (endSourceIndex - startSourceIndex == endTargetIndex - startTargetIndex) {
            return;
        }
        if (endSourceIndex - startSourceIndex < endTargetIndex - startTargetIndex) {
            newNodeCount = endTargetIndex - startTargetIndex - (endSourceIndex - startSourceIndex);
            smallerStartIndex = startSourceIndex;
            smallerEndIndex = endSourceIndex;
            smallerList = source;
        } else {
            newNodeCount = endSourceIndex - startSourceIndex - (endTargetIndex - startTargetIndex);
            smallerStartIndex = startTargetIndex;
            smallerEndIndex = endTargetIndex;
            smallerList = target;
        }
        int endNodes = newNodeCount / 2;
        int frontNodes = newNodeCount - endNodes;
        for (i = 0; i < frontNodes; ++i) {
            smallerList.duplicateEndPoint(smallerStartIndex);
        }
        for (i = 0; i < endNodes; ++i) {
            smallerList.duplicateEndPoint(smallerEndIndex);
        }
    }
}

