/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;
import org.bbop.swing.HTMLLabel;
import org.bbop.swing.IconFactory;
import org.bbop.swing.IconFactoryRegistry;
import org.bbop.swing.PluggableImageHTMLEditorKit;

public class ExtensibleLabelUI
extends BasicLabelUI {
    protected static final Logger logger = Logger.getLogger(ExtensibleLabelUI.class);
    private static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }";
    protected BasicEditorKit editorKit = new BasicEditorKit();
    boolean disableHTML = false;
    protected IconFactoryRegistry.IconRegistryListener registryListener = new IconFactoryRegistry.IconRegistryListener(){

        @Override
        public void factoryInstalled(String suffix, IconFactory factory) {
            ExtensibleLabelUI.this.installFactory(suffix, factory);
        }

        @Override
        public void factoryRemoved(String suffix, IconFactory factory) {
            ExtensibleLabelUI.this.uninstallFactory(suffix, factory);
        }
    };

    protected static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuffer rule = new StringBuffer("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            if (fg.getRed() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getRed()));
            if (fg.getGreen() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getGreen()));
            if (fg.getBlue() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getBlue()));
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public ExtensibleLabelUI() {
        for (String suffix : IconFactoryRegistry.getSuffixes()) {
            this.installFactory(suffix, IconFactoryRegistry.getFactory(suffix));
        }
        IconFactoryRegistry.addListener(this.registryListener);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        IconFactoryRegistry.removeListener(this.registryListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name == "text" || "font" == name || "foreground" == name) {
            JLabel lbl = (JLabel)e.getSource();
            String text = lbl.getText();
            this.updateRenderer(lbl, text);
        } else if (name == "labelFor" || name == "displayedMnemonic") {
            this.installKeyboardActions((JLabel)e.getSource());
        }
    }

    @Override
    protected void installComponents(JLabel c) {
        this.updateRenderer(c, c.getText());
        c.setInheritsPopupMenu(true);
    }

    @Override
    protected void uninstallComponents(JLabel c) {
        this.updateRenderer(c, "");
    }

    public void updateRenderer(JComponent c, String text) {
        View value = null;
        View oldValue = (View)c.getClientProperty("html");
        if (!this.disableHTML && BasicHTML.isHTMLString(text)) {
            value = HTMLLabel.createHTMLView(this.editorKit, c, text);
        }
        if (value != oldValue && oldValue != null) {
            for (int i = 0; i < oldValue.getViewCount(); ++i) {
                oldValue.getView(i).setParent(null);
            }
        }
        c.putClientProperty("html", value);
    }

    public void installFactory(String suffix, IconFactory factory) {
        this.editorKit.installFactory(suffix, factory);
    }

    public void uninstallFactory(String suffix, IconFactory factory) {
        this.editorKit.uninstallFactory(suffix, factory);
    }

    public boolean isDisableHTML() {
        return this.disableHTML;
    }

    public void setDisableHTML(boolean disableHTML) {
        this.disableHTML = disableHTML;
    }

    public BasicEditorKit getEditorKit() {
        return this.editorKit;
    }

    public static class BasicEditorKit
    extends PluggableImageHTMLEditorKit {
        private static StyleSheet defaultStyles;

        @Override
        public StyleSheet getStyleSheet() {
            if (defaultStyles == null) {
                defaultStyles = new StyleSheet();
                StringReader r = new StringReader(ExtensibleLabelUI.styleChanges);
                try {
                    defaultStyles.loadRules(r, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                r.close();
                defaultStyles.addStyleSheet(super.getStyleSheet());
            }
            return defaultStyles;
        }

        public Document createDefaultDocument(Font defaultFont, Color foreground) {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            BasicDocument doc = new BasicDocument(ss, defaultFont, foreground);
            doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
            doc.setPreservesUnknownTags(false);
            return doc;
        }

        @Override
        public ViewFactory getViewFactory() {
            return new BasicHTMLViewFactory();
        }

        protected class BasicHTMLViewFactory
        extends PluggableImageHTMLEditorKit.PluggableImageHTMLFactory {
            protected BasicHTMLViewFactory() {
                super(BasicEditorKit.this);
            }

            @Override
            public View create(Element elem) {
                View view = super.create(elem);
                if (view instanceof ImageView) {
                    ((ImageView)view).setLoadsSynchronously(true);
                }
                return view;
            }
        }
    }

    protected static class BasicDocument
    extends HTMLDocument {
        BasicDocument(StyleSheet s, Font defaultFont, Color foreground) {
            super(s);
            this.setPreservesUnknownTags(false);
            this.setFontAndColor(defaultFont, foreground);
        }

        private void setFontAndColor(Font font, Color fg) {
            this.getStyleSheet().addRule(ExtensibleLabelUI.displayPropertiesToCSS(font, fg));
        }
    }

    public static class Renderer
    extends View {
        private int width;
        private View view;
        private ViewFactory factory;
        private JComponent host;

        Renderer(JComponent c, ViewFactory f, View v) {
            super(null);
            this.host = c;
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(axis);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return this.view.getMinimumSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            this.host.revalidate();
            this.host.repaint();
        }

        @Override
        public float getAlignment(int axis) {
            return this.view.getAlignment(axis);
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this.view.setSize(alloc.width, alloc.height);
            this.view.paint(g, allocation);
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return this.view.modelToView(pos, a, b);
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            return this.view.modelToView(p0, b0, p1, b1, a);
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return this.view.viewToModel(x, y, a, bias);
        }

        @Override
        public Document getDocument() {
            return this.view.getDocument();
        }

        @Override
        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        @Override
        public Element getElement() {
            return this.view.getElement();
        }

        @Override
        public void setSize(float width, float height) {
            this.width = (int)width;
            this.view.setSize(width, height);
        }

        @Override
        public Container getContainer() {
            return this.host;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }
    }
}

