/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import javax.swing.text.Document;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;
import org.bbop.swing.ExtensibleLabelUI;
import org.bbop.swing.IconFactory;

public class HTMLLabel
extends JLabel {
    protected static final Logger logger = Logger.getLogger(HTMLLabel.class);
    protected ExtensibleLabelUI labelui;
    protected boolean htmlEnabled = true;

    public HTMLLabel() {
    }

    public HTMLLabel(String text) {
        super(text);
    }

    @Override
    public void setUI(LabelUI ui) {
        this.labelui = new ExtensibleLabelUI();
        super.setUI(this.labelui);
    }

    public void installIconFactory(String suffix, IconFactory factory) {
        this.labelui.installFactory(suffix, factory);
    }

    public void uninstallIconFactory(String suffix, IconFactory factory) {
        this.labelui.uninstallFactory(suffix, factory);
    }

    public boolean isHtmlEnabled() {
        return this.htmlEnabled;
    }

    public void setHtmlEnabled(boolean htmlEnabled) {
        this.htmlEnabled = htmlEnabled;
        this.labelui.setDisableHTML(!htmlEnabled);
    }

    public ExtensibleLabelUI.BasicEditorKit getEditorKit() {
        return this.labelui.getEditorKit();
    }

    public static View createHTMLView(ExtensibleLabelUI.BasicEditorKit kit, JComponent c, String html) {
        Document doc = kit.createDefaultDocument(c.getFont(), c.getForeground());
        Object base = c.getClientProperty("html.base");
        if (base instanceof URL) {
            ((HTMLDocument)doc).setBase((URL)base);
        }
        StringReader r = new StringReader(html);
        try {
            kit.read(r, doc, 0);
        }
        catch (Throwable e) {
            // empty catch block
        }
        ViewFactory f = kit.getViewFactory();
        View hview = f.create(doc.getDefaultRootElement());
        ExtensibleLabelUI.Renderer v = new ExtensibleLabelUI.Renderer(c, f, hview);
        return v;
    }
}

