/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.bbop.swing.DragContainer;

public class JDragPanel
extends JPanel
implements DragContainer {
    protected static final Logger logger = Logger.getLogger(JDragPanel.class);
    private static final long serialVersionUID = -2403533422675994411L;
    protected Image dragImage = null;
    protected int dragX;
    protected int dragY;
    protected int width;
    protected int height;
    protected Rectangle scratchRect = new Rectangle();

    @Override
    public void imageChanged(Image dragImage, int x, int y, int width, int height) {
        int oldx = this.dragX;
        int oldy = this.dragY;
        int oldwidth = this.width;
        int oldheight = this.height;
        this.dragX = x;
        this.dragY = y;
        this.width = width;
        this.height = height;
        this.dragImage = dragImage;
        if (dragImage == null) {
            this.repaint();
            return;
        }
        this.scratchRect.setBounds(oldx, oldy, oldwidth, oldheight);
        SwingUtilities.computeUnion(x, y, width, height, this.scratchRect);
        this.repaint(this.scratchRect);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintDragImage(g);
    }

    public void paintDragImage(Graphics g) {
        if (this.dragImage != null) {
            g.drawImage(this.dragImage, this.dragX, this.dragY, null);
        }
    }
}

