/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class KeyRecorder
implements KeyEventDispatcher {
    protected static final Logger logger = Logger.getLogger(KeyRecorder.class);
    public static final int MAX_KEYS = 10;
    protected int[] codeArray = new int[10];
    protected int arrayLength = 0;
    protected Vector listeners = new Vector();
    protected KeyChecker keyChecker = new KeyChecker();
    protected CoalesceThread coalesceThread;
    protected boolean smoothOutAutorepeat = false;
    KeyEvent lastPress;
    protected long coalesceInterval = 500L;
    protected Map keyTimings = Collections.synchronizedMap(new HashMap());
    protected HashSet sentKeys = new HashSet();

    protected void addKey(int key) {
        if (this.arrayLength < this.codeArray.length) {
            this.codeArray[this.arrayLength++] = key;
        }
    }

    protected void removeKey(int key) {
        for (int i = 0; i < this.arrayLength; ++i) {
            if (this.codeArray[i] != key) continue;
            this.codeArray[i] = this.codeArray[--this.arrayLength];
        }
    }

    protected boolean containsKey(int key) {
        for (int i = 0; i < this.arrayLength; ++i) {
            if (this.codeArray[i] != key) continue;
            return true;
        }
        return false;
    }

    public void setSmoothOutAutorepeat(boolean val) {
        if (val != this.smoothOutAutorepeat) {
            this.smoothOutAutorepeat = val;
            this.keyTimings.clear();
            if (this.smoothOutAutorepeat) {
                this.coalesceThread = new CoalesceThread();
                this.coalesceThread.start();
            } else {
                this.coalesceThread.halt();
                this.coalesceThread = null;
            }
        }
    }

    public void setCoalesceInterval(long coalesceInterval) {
        this.coalesceInterval = coalesceInterval;
    }

    protected synchronized void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            this.addKey(e.getKeyCode());
        } else if (e.getID() == 402) {
            this.removeKey(e.getKeyCode());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            KeyListener kl = (KeyListener)this.listeners.get(i);
            if (e.getID() == 401) {
                kl.keyPressed(e);
                continue;
            }
            if (e.getID() == 402) {
                kl.keyReleased(e);
                continue;
            }
            if (e.getID() != 400) continue;
            kl.keyTyped(e);
        }
    }

    @Override
    public synchronized boolean dispatchKeyEvent(KeyEvent e) {
        if (this.smoothOutAutorepeat) {
            if (e.getID() == 401 || e.getID() == 402) {
                long time = System.currentTimeMillis();
                Integer keyint = new Integer(e.getKeyCode());
                boolean consumed = false;
                if (!this.keyTimings.containsKey(keyint)) {
                    this.processKeyEvent(e);
                    consumed = true;
                }
                KeyEventHolder keh = new KeyEventHolder(e, 0L, consumed);
                this.keyTimings.put(keyint, keh);
                keh.timereceived = System.currentTimeMillis();
            }
        } else {
            this.processKeyEvent(e);
        }
        return false;
    }

    public KeyChecker getKeyChecker() {
        return this.keyChecker;
    }

    public boolean isDown(int keyCode) {
        return this.keyChecker.isDown(keyCode);
    }

    public void addKeyListener(KeyListener kl) {
        this.listeners.add(kl);
    }

    public void removeKeyListener(KeyListener kl) {
        this.listeners.remove(kl);
    }

    public void install() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public void uninstall() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    protected class CoalesceThread
    extends Thread {
        protected HashSet removem = new HashSet();
        protected HashSet examinem = new HashSet();
        protected boolean halt = false;

        public CoalesceThread() {
            this.setDaemon(true);
            this.setPriority(1);
        }

        protected void halt() {
            this.halt = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.halt) {
                try {
                    this.removem.clear();
                    this.examinem.clear();
                    KeyRecorder keyRecorder = KeyRecorder.this;
                    synchronized (keyRecorder) {
                        this.examinem.addAll(KeyRecorder.this.keyTimings.keySet());
                        for (Integer key : this.examinem) {
                            KeyEventHolder e = (KeyEventHolder)KeyRecorder.this.keyTimings.get(key);
                            long timeDiff = System.currentTimeMillis() - e.timereceived;
                            if (timeDiff <= KeyRecorder.this.coalesceInterval) continue;
                            if (!e.consumed) {
                                KeyRecorder.this.processKeyEvent(e.event);
                            }
                            e.timereceived = timeDiff;
                            this.removem.add(key);
                        }
                        for (Object o : this.removem) {
                            KeyEventHolder keh = (KeyEventHolder)KeyRecorder.this.keyTimings.remove(o);
                            KeyRecorder.this.keyTimings.remove(o);
                        }
                    }
                    CoalesceThread.sleep(KeyRecorder.this.coalesceInterval / 2L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            KeyRecorder.this.arrayLength = 0;
        }
    }

    protected class KeyEventHolder {
        KeyEvent event;
        long timereceived;
        boolean consumed;

        public KeyEventHolder(KeyEvent event, long timereceived, boolean consumed) {
            this.event = event;
            this.timereceived = timereceived;
            this.consumed = consumed;
        }
    }

    public class KeyChecker {
        public boolean isDown(int keyCode) {
            return KeyRecorder.this.containsKey(keyCode);
        }
    }
}

