/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;
import org.bbop.swing.HTMLLabel;
import org.bbop.swing.StringLinkListener;
import org.bbop.swing.SwingUtil;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;

public class LabelMouseHyperlinkBridge
implements MouseListener,
MouseMotionListener {
    protected static final Logger logger = Logger.getLogger(LabelMouseHyperlinkBridge.class);
    protected JLabel label;
    protected Collection<HyperlinkListener> hyperlinkListeners = new ArrayList<HyperlinkListener>();
    protected Collection<StringLinkListener> stringListeners = new ArrayList<StringLinkListener>();
    protected MultiMap<String, ActionListener> actionMap = new MultiHashMap<String, ActionListener>();

    public LabelMouseHyperlinkBridge(JLabel label) {
        this.label = label;
    }

    protected static String getURL(JLabel lookAtMe, MouseEvent e) {
        View view = lookAtMe instanceof HTMLLabel ? HTMLLabel.createHTMLView(((HTMLLabel)lookAtMe).getEditorKit(), lookAtMe, lookAtMe.getText()) : BasicHTML.createHTMLView(lookAtMe, lookAtMe.getText());
        if (view != null) {
            int pos = view.viewToModel(e.getX(), e.getY(), SwingUtil.getTextRectangle(lookAtMe));
            HTMLDocument d = (HTMLDocument)view.getDocument();
            Element emt = d.getCharacterElement(pos);
            AttributeSet a = emt.getAttributes();
            AttributeSet anchor = (AttributeSet)a.getAttribute(HTML.Tag.A);
            if (anchor != null) {
                return (String)anchor.getAttribute(HTML.Attribute.HREF);
            }
        }
        return null;
    }

    public void addStringLinkListener(StringLinkListener listener) {
        this.stringListeners.add(listener);
    }

    public void removeStringLinkListener(StringLinkListener listener) {
        this.stringListeners.remove(listener);
    }

    protected void fireStringlinkListener(String href) {
        for (StringLinkListener listener : this.stringListeners) {
            listener.link(href);
        }
    }

    public void addHyperLinkListener(HyperlinkListener listener) {
        this.hyperlinkListeners.add(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.hyperlinkListeners.remove(listener);
    }

    protected void fireHyperlinkListener(HyperlinkEvent e) {
        for (HyperlinkListener listener : this.hyperlinkListeners) {
            listener.hyperlinkUpdate(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String url = LabelMouseHyperlinkBridge.getURL(this.label, e);
        if (url != null) {
            this.fireStringlinkListener(url);
            try {
                this.fireHyperlinkListener(new HyperlinkEvent(e.getSource(), HyperlinkEvent.EventType.ACTIVATED, new URL(url)));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.fireActionListener(new ActionEvent(e.getSource(), 1001, url));
        }
    }

    protected void fireActionListener(ActionEvent event) {
        Collection listeners = (Collection)this.actionMap.get(event.getActionCommand());
        for (ActionListener listener : listeners) {
            listener.actionPerformed(event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setCursor(e);
    }

    protected void setCursor(MouseEvent e) {
        if (LabelMouseHyperlinkBridge.getURL(this.label, e) != null) {
            this.label.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.label.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void add(String command, ActionListener listener) {
        this.actionMap.add(command, listener);
    }

    public void remove(String command, ActionListener listener) {
        this.actionMap.add(command, listener);
    }
}

