/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.apache.log4j.Logger;
import org.bbop.swing.AddButtonListener;
import org.bbop.swing.DelButtonListener;
import org.bbop.swing.GenericEditorComponent;
import org.bbop.swing.PickListener;
import org.bbop.swing.VectorWrapper;
import org.bbop.util.EditableString;
import org.bbop.util.VectorUtil;

public class ListEditor
extends JPanel {
    protected static final Logger logger = Logger.getLogger(ListEditor.class);
    private static final long serialVersionUID = 1651813950977682834L;
    protected boolean listResizable;
    protected boolean editable;
    protected boolean vectorEditable;
    protected boolean undoable;
    protected GenericEditorComponent editor;
    protected Vector original_data;
    protected Vector data;
    protected ListSelectionListener listListener;
    protected JList valueList;
    protected Object currentEditValue;
    protected StateEdit currentEditTransaction;
    private JButton addButton;
    private JButton delButton;
    private JPanel listPanel;
    protected CompoundEdit masterUndolist;
    protected Component noSelectionComponent;
    private JSplitPane resizablePane;
    protected boolean autocommit;
    private boolean showingEditor;
    protected Color buttonColor;
    protected int minDividerSize = 30;
    protected int defaultDividerSize = 200;
    protected int dividerLoc = -1;
    protected JScrollPane listScrollPane;
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    protected Vector listeners;

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.delButton.setEnabled(enabled);
        this.valueList.setEnabled(enabled);
        if (this.editor instanceof Component) {
            ((Component)((Object)this.editor)).setEnabled(enabled);
        }
    }

    public ListEditor(GenericEditorComponent editor) {
        this(editor, new Vector(0));
    }

    public ListEditor(GenericEditorComponent editor, boolean listResizable, boolean editable, boolean vectorEditable, boolean autocommit, boolean undoable) {
        this(editor, null, new Vector(0), listResizable, editable, vectorEditable, autocommit, undoable);
    }

    public ListEditor(GenericEditorComponent editor, Vector data) {
        this(editor, null, data, true, true, false, false, true);
    }

    public ListEditor(GenericEditorComponent editor, Component noSelectionComponent, Vector data, boolean listResizable, boolean editable, boolean vectorEditable, boolean autocommit, boolean undoable) {
        this.autocommit = autocommit;
        this.listResizable = listResizable;
        this.editable = editable;
        this.vectorEditable = vectorEditable;
        this.editor = editor;
        editor.setMasterComponent(this);
        if (noSelectionComponent == null) {
            this.noSelectionComponent = ListEditor.defaultNoSelectionComponent();
            this.noSelectionComponent.setFont(this.getFont());
        } else {
            this.noSelectionComponent = noSelectionComponent;
        }
        this.setData(data, false);
        this.undoable = undoable;
        this.valueList = new JList(data);
        this.listeners = new Vector();
        this.valueList.setSelectionMode(0);
        this.showingEditor = true;
        this.buildGUI();
    }

    public void setOrientation(int orientation) {
        this.resizablePane.setOrientation(orientation);
    }

    public JList getList() {
        return this.valueList;
    }

    public void setDefaultDividerLoc(int loc) {
        this.defaultDividerSize = loc;
        this.updateGUI();
    }

    public void addListSelectionListener(ListSelectionListener in) {
        this.listeners.addElement(in);
    }

    public void removeListSelectionListener(ListSelectionListener in) {
        this.listeners.removeElement(in);
    }

    protected void fireListSelectionEvent(ListSelectionEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListSelectionListener lsl = (ListSelectionListener)this.listeners.elementAt(i);
            lsl.valueChanged(e);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.listPanel != null) {
            this.listPanel.setBackground(color);
        }
        if (this.resizablePane != null) {
            this.resizablePane.setBackground(color);
        }
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
        if (this.addButton != null) {
            this.addButton.setBackground(buttonColor);
        }
        if (this.delButton != null) {
            this.delButton.setBackground(buttonColor);
        }
    }

    public Object getSelectedItem() {
        return this.valueList.getSelectedValue();
    }

    public Vector getData() {
        return this.data;
    }

    public void setVectorEditable(boolean vectorEditable) {
        this.vectorEditable = vectorEditable;
        this.refresh();
    }

    private void buildUndoObjects() {
        this.masterUndolist = new CompoundEdit();
        this.masterUndolist.addEdit(new StateEdit(new VectorWrapper(this.original_data)));
    }

    public static Component defaultNoSelectionComponent() {
        JLabel label = new JLabel("Select an item from the list");
        return label;
    }

    @Override
    public void setFont(Font in) {
        super.setFont(in);
        this.fontify();
    }

    protected void fontify() {
        if (this.valueList != null) {
            this.valueList.setFont(this.getFont());
        }
        if (this.addButton != null) {
            this.addButton.setFont(this.getFont());
        }
        if (this.delButton != null) {
            this.delButton.setFont(this.getFont());
        }
    }

    public void doStore(Object currentEditValue) {
        if (this.editable) {
            if (currentEditValue != null) {
                this.editor.store(currentEditValue);
            }
            this.valueList.validate();
        }
        if (this.currentEditTransaction != null) {
            this.currentEditTransaction.end();
            this.masterUndolist.addEdit(this.currentEditTransaction);
            this.currentEditTransaction = null;
        }
    }

    public void add() {
        if (this.editable) {
            Object obj = this.editor.createNewValue();
            this.data.addElement(obj);
            this.valueList.setListData(this.data);
            this.valueList.setSelectedValue(obj, true);
            this.updateGUI();
        }
    }

    public void select(int index) {
        this.valueList.setSelectedIndex(index);
    }

    public void del() {
        Object value = this.valueList.getSelectedValue();
        int index = this.valueList.getSelectedIndex();
        if (this.editable && value != null) {
            this.data.removeElement(value);
            this.valueList.setListData(this.data);
            this.valueList.clearSelection();
            if (this.data.size() > 0 && index >= this.data.size()) {
                this.valueList.setSelectedIndex(index - 1);
                this.valueList.ensureIndexIsVisible(index - 1);
            } else if (this.data.size() > 0) {
                this.valueList.setSelectedIndex(index);
                this.valueList.ensureIndexIsVisible(index);
            }
            this.refresh();
        }
    }

    public void setShowListPanel(boolean show) {
        if (this.listResizable) {
            if (show) {
                this.resizablePane.setLeftComponent(this.listPanel);
                this.resizablePane.setDividerLocation(this.dividerLoc);
            } else {
                if (this.resizablePane.getLeftComponent() != null) {
                    this.dividerLoc = this.resizablePane.getDividerLocation();
                }
                this.resizablePane.setLeftComponent(null);
                this.resizablePane.setDividerLocation(0);
            }
        } else {
            if (show) {
                this.add("West", this.listPanel);
            } else {
                this.remove(this.listPanel);
            }
            this.validate();
        }
        this.repaint();
    }

    public void setData(Vector vector) {
        this.setData(vector, true);
    }

    protected void setData(Vector vector, boolean redraw) {
        this.original_data = vector;
        this.data = this.vectorEditable ? (Vector)this.original_data.clone() : this.original_data;
        if (this.valueList != null) {
            Object oldSelection = this.valueList.getSelectedValue();
            this.valueList.setListData(this.data);
            this.valueList.setSelectedValue(oldSelection, true);
        }
        if (this.editable && this.undoable) {
            this.buildUndoObjects();
        }
        if (redraw) {
            this.refresh();
        }
    }

    protected void updateGUI() {
        boolean showEditor;
        boolean bl = showEditor = this.valueList.getSelectedIndex() != -1;
        if (this.listResizable) {
            if (this.resizablePane.getLeftComponent() != null) {
                this.dividerLoc = this.resizablePane.getDividerLocation();
            }
            if (showEditor) {
                this.resizablePane.setRightComponent((Component)((Object)this.editor));
            } else {
                this.resizablePane.setRightComponent(this.noSelectionComponent);
            }
            if (this.resizablePane.getOrientation() == 1) {
                int maxDividerSize = (int)this.resizablePane.getSize().getWidth() - (int)((Component)((Object)this.editor)).getPreferredSize().getWidth();
            } else {
                int maxDividerSize = (int)this.resizablePane.getSize().getHeight() - (int)((Component)((Object)this.editor)).getPreferredSize().getHeight();
            }
            if (this.resizablePane.getLeftComponent() != null) {
                this.resizablePane.setDividerLocation(this.dividerLoc);
            }
        } else {
            if (showEditor) {
                this.remove(this.noSelectionComponent);
                this.add((Component)((Object)this.editor), "Center");
            } else if (!showEditor) {
                this.remove((Component)((Object)this.editor));
                this.add(this.noSelectionComponent, "Center");
            }
            this.validate();
        }
        this.repaint();
        if (this.vectorEditable) {
            this.delButton.setEnabled(this.isEnabled() && !this.valueList.isSelectionEmpty());
        }
    }

    public void reload() {
        this.valueList.setSelectedIndex(this.valueList.getSelectedIndex());
        this.refresh();
    }

    public void handleEdit(Object object) {
        if (this.autocommit) {
            this.doStore(this.currentEditValue);
        }
        this.updateGUI();
        if (object == null) {
            return;
        }
        if (this.undoable && object instanceof StateEditable) {
            this.currentEditTransaction = new StateEdit((StateEditable)object);
        }
        this.currentEditValue = object;
        this.editor.load(this.currentEditValue);
    }

    public void refresh() {
        this.updateGUI();
        if (this.editor != null && this.currentEditValue != null) {
            this.editor.load(this.currentEditValue);
        }
        this.repaint();
    }

    public UndoableEdit commit() {
        return this.commit(this.currentEditValue);
    }

    public UndoableEdit commit(Object commitme) {
        this.doStore(commitme);
        this.refresh();
        this.currentEditTransaction = null;
        if (this.vectorEditable) {
            this.original_data.removeAllElements();
            VectorUtil.mergeVectors(this.original_data, this.data);
        }
        if (this.undoable) {
            CompoundEdit committedUndo = this.masterUndolist;
            committedUndo.end();
            this.buildUndoObjects();
            return committedUndo;
        }
        return null;
    }

    protected void buildGUI() {
        this.setOpaque(false);
        this.listListener = new PickListener(this);
        this.valueList.addListSelectionListener(this.listListener);
        this.listPanel = this.getListPanel();
        this.setLayout(new BorderLayout(3, 0));
        if (this.listResizable) {
            this.resizablePane = new JSplitPane();
            this.resizablePane.setDividerSize(3);
            this.resizablePane.setLeftComponent(null);
            this.resizablePane.setDividerLocation(this.dividerLoc);
            this.add((Component)this.resizablePane, "Center");
        }
        this.setShowListPanel(true);
        this.fontify();
        this.updateGUI();
    }

    protected JPanel getListPanel() {
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        this.listScrollPane = new JScrollPane(this.valueList);
        this.listScrollPane.setPreferredSize(new Dimension(200, 300));
        this.listScrollPane.setMinimumSize(new Dimension(100, 300));
        listPanel.add((Component)this.listScrollPane, "Center");
        if (this.vectorEditable) {
            this.initButtons();
            JPanel buttonPanel = new JPanel();
            buttonPanel.setOpaque(false);
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.delButton);
            listPanel.add((Component)buttonPanel, "South");
            listPanel.setMinimumSize(buttonPanel.getPreferredSize());
            this.minDividerSize = (int)buttonPanel.getPreferredSize().getWidth();
        }
        listPanel.setOpaque(false);
        return listPanel;
    }

    public void setListSize(int size) {
        this.listScrollPane.setPreferredSize(new Dimension(size, size));
        this.dividerLoc = size;
        this.resizablePane.setDividerLocation(this.dividerLoc);
        this.revalidate();
    }

    protected void initButtons() {
        if (this.addButton == null) {
            this.addButton = new JButton("Add");
            this.addButton.addActionListener(new AddButtonListener(this));
        }
        if (this.delButton == null) {
            this.delButton = new JButton("Del");
            this.delButton.addActionListener(new DelButtonListener(this));
        }
    }

    public void setEditable(boolean in) {
        this.editable = in;
    }

    public void hideList() {
        this.setShowListPanel(false);
    }

    public void showList() {
        this.setShowListPanel(true);
    }

    public void undo() {
        UndoManager undoman = new UndoManager();
        UndoableEdit edit = this.commit();
        undoman.addEdit(edit);
        undoman.undo();
        this.buildUndoObjects();
        this.refresh();
        this.repaint();
    }

    public static Vector junkVector() {
        Vector<EditableString> out = new Vector<EditableString>();
        out.addElement(new EditableString("Hello"));
        out.addElement(new EditableString("I"));
        out.addElement(new EditableString("love"));
        out.addElement(new EditableString("peaches"));
        out.addElement(new EditableString("huh?"));
        return out;
    }
}

