/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class PercentageLayout
implements LayoutManager2 {
    protected static final Logger logger = Logger.getLogger(PercentageLayout.class);
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int gap;
    private int orientation;
    private Hashtable constraints;

    public PercentageLayout() {
        this(0, 0);
    }

    public PercentageLayout(int orientation) {
        this(orientation, 0);
    }

    public PercentageLayout(int orientation, int gap) {
        this.orientation = orientation;
        this.gap = gap;
        this.constraints = new Hashtable();
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void setConstraints(Component component, Object constraint) {
        if (constraint == null || !(constraint instanceof Integer)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be of type Integer");
        }
        this.constraints.put(component, constraint);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            int width = size.width - (insets.left + insets.right);
            int totalGap = this.gap * (parent.getComponentCount() - 1);
            int height = size.height - (insets.bottom + insets.top);
            int total = this.getTotal(parent);
            int pos = 0;
            pos = this.orientation == 0 ? insets.left : insets.top;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component component = parent.getComponent(i);
                if (!component.isVisible()) continue;
                int value = (Integer)this.constraints.get(component);
                int x = 0;
                int y = 0;
                int w = 0;
                int h = 0;
                if (this.orientation == 0) {
                    x = pos;
                    y = insets.top;
                    h = height;
                    w = i == parent.getComponentCount() - 1 ? width - x + insets.left : (width - totalGap) * value / total;
                    if (w < 0) {
                        w = 0;
                    }
                    component.setBounds(x, y, w, h);
                    pos += w + this.gap;
                    continue;
                }
                x = insets.left;
                y = pos;
                w = width;
                h = i == parent.getComponentCount() - 1 ? height - y + insets.top : (height - totalGap) * value / total;
                if (h < 0) {
                    h = 0;
                }
                component.setBounds(x, y, w, h);
                pos += h + this.gap;
            }
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        this.setConstraints(component, constraints);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    private int getTotal(Container parent) {
        int total = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component component = parent.getComponent(i);
            if (!component.isVisible()) continue;
            total += ((Integer)this.constraints.get(component)).intValue();
        }
        return total;
    }
}

