/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;

public abstract class SelectDialog {
    private static final Logger LOGGER = Logger.getLogger(SelectDialog.class);
    public static final boolean LOAD = false;
    public static final boolean SAVE = true;

    public abstract void show();

    public abstract File getSelected();

    public String getSelectedCanonicalPath() {
        File selected = this.getSelected();
        return SelectDialog.getCanonical(selected);
    }

    private static String getCanonical(File selected) {
        if (selected != null) {
            try {
                return selected.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error((Object)("Unable to get canonical path for file: " + selected.getAbsolutePath()), (Throwable)e);
            }
        }
        return null;
    }

    public static SelectDialog getFileSelector(boolean write, String defaultFolder) {
        return SelectDialog.getFileSelector(GUIManager.getManager().getFrame(), write, defaultFolder, "", null, null);
    }

    public static SelectDialog getFileSelector(final Frame frame, boolean write, String defaultFolder, String title, String description, String[] extensions) {
        if (SelectDialog.isUnix()) {
            final JFileChooser fc = defaultFolder != null ? new JFileChooser(defaultFolder) : new JFileChooser();
            int dialogType = 0;
            if (write) {
                dialogType = 1;
            }
            fc.setDialogType(dialogType);
            fc.setDialogTitle(title);
            if (extensions != null && extensions.length > 0) {
                fc.setFileFilter(new SuffixFileFilter(description, extensions));
            }
            return new SelectDialog(){
                File selected = null;

                @Override
                public void show() {
                    this.selected = null;
                    int returnVal = fc.showOpenDialog(frame);
                    if (returnVal == 0) {
                        this.selected = fc.getSelectedFile();
                    }
                }

                @Override
                public File getSelected() {
                    return this.selected;
                }
            };
        }
        int mode = 0;
        if (write) {
            mode = 1;
        }
        final FileDialog dialog = new FileDialog(frame, title, mode);
        dialog.setDirectory(defaultFolder);
        if (extensions != null && extensions.length > 0) {
            dialog.setFilenameFilter(new SuffixFilenameFilter(extensions));
        }
        return new SelectDialog(){
            File selected = null;

            @Override
            public void show() {
                this.selected = null;
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                String dirName = dialog.getDirectory();
                if (fileName != null && dirName != null) {
                    this.selected = new File(dirName, fileName);
                }
            }

            @Override
            public File getSelected() {
                return this.selected;
            }
        };
    }

    public static SelectDialog getFolderSelector(final Frame frame, String defaultFolder, String title) {
        if (SelectDialog.isUnix()) {
            final JFileChooser folderFC = defaultFolder != null ? new JFileChooser(defaultFolder) : new JFileChooser();
            folderFC.setDialogTitle(title);
            folderFC.setFileSelectionMode(1);
            folderFC.setAcceptAllFileFilterUsed(false);
            return new SelectDialog(){
                File selected = null;

                @Override
                public void show() {
                    this.selected = null;
                    int returnVal = folderFC.showOpenDialog(frame);
                    if (returnVal == 0) {
                        this.selected = folderFC.getSelectedFile();
                    }
                }

                @Override
                public File getSelected() {
                    return this.selected;
                }
            };
        }
        final FileDialog dialog = new FileDialog(frame, title, 0);
        dialog.setDirectory(defaultFolder);
        dialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return false;
            }
        });
        return new SelectDialog(){
            File selected = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void show() {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                try {
                    this.selected = null;
                    dialog.setVisible(true);
                    String fileName = dialog.getFile();
                    String dirName = dialog.getDirectory();
                    if (fileName != null && dirName != null) {
                        File file = new File(dirName, fileName);
                        if (file.isDirectory()) {
                            this.selected = file;
                        } else if (file.isFile()) {
                            this.selected = file.getParentFile();
                        }
                    } else if (dirName != null) {
                        this.selected = new File(dirName);
                    }
                }
                finally {
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                }
            }

            @Override
            public File getSelected() {
                return this.selected;
            }
        };
    }

    private static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    private static class SuffixFilenameFilter
    implements FilenameFilter {
        private final Set<String> extensions;

        SuffixFilenameFilter(String ... suffixes) {
            this.extensions = suffixes != null ? new HashSet<String>(Arrays.asList(suffixes)) : null;
        }

        @Override
        public boolean accept(File dir, String fileName) {
            int i;
            if (this.extensions == null) {
                return true;
            }
            if (fileName != null && fileName.length() > 0 && (i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
                String extension = fileName.substring(i + 1).toLowerCase();
                return this.extensions.contains(extension);
            }
            return false;
        }
    }

    private static class SuffixFileFilter
    extends FileFilter {
        private final String description;
        private final Set<String> extensions;

        SuffixFileFilter(String description, String ... suffixes) {
            this.description = description;
            this.extensions = suffixes != null ? new HashSet<String>(Arrays.asList(suffixes)) : null;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean accept(File f) {
            if (this.extensions == null) {
                return true;
            }
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName();
                int i = fileName.lastIndexOf(46);
                if (i > 0 && i < fileName.length() - 1) {
                    String extension = fileName.substring(i + 1).toLowerCase();
                    return this.extensions.contains(extension);
                }
            }
            return false;
        }
    }
}

