/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.swing.ReversePathIterator;

public class ShapeUtil {
    protected static final Logger logger = Logger.getLogger(ShapeUtil.class);
    protected static final float[] scratch = new float[6];
    public static final int NO_INTERSECTION = 0;
    public static final int COINCIDENT = -1;
    public static final int PARALLEL = -2;

    private ShapeUtil() {
    }

    public static double distance(double x, double y, double z, double a, double b, double c) {
        return Math.sqrt(Math.pow(x - a, 2.0) + Math.pow(y - b, 2.0) + Math.pow(z - c, 2.0));
    }

    public static Shape createRoundRectangle(float x, float y, float width, float height) {
        return ShapeUtil.createRoundRectangle(50, x, y, width, height);
    }

    public static Shape createRoundRectangle(int roundingPercentage, float x, float y, float width, float height) {
        float roundingSize = Math.min(width, height) * (float)roundingPercentage / 100.0f;
        return ShapeUtil.createRoundRectangle(null, roundingSize, x, y, width, height);
    }

    public static Shape createRoundRectangle(GeneralPath out, float roundingSize, float x, float y, float width, float height) {
        if (out == null) {
            out = new GeneralPath();
        } else {
            out.reset();
        }
        if (roundingSize > width / 2.0f) {
            roundingSize = width / 2.0f;
        }
        if (roundingSize > height / 2.0f) {
            roundingSize = height / 2.0f;
        }
        out.moveTo(x, y + roundingSize);
        out.curveTo(x, y, x, y, x + roundingSize, y);
        out.lineTo(x + width - roundingSize, y);
        out.curveTo(x + width, y, x + width, y, x + width, y + roundingSize);
        out.lineTo(x + width, y + height - roundingSize);
        out.curveTo(x + width, y + height, x + width, y + height, x + width - roundingSize, y + height);
        out.lineTo(x + roundingSize, y + height);
        out.curveTo(x, y + height, x, y + height, x, y + height - roundingSize);
        out.lineTo(x, y + roundingSize);
        out.closePath();
        return out;
    }

    public static boolean hasSubpaths(Shape shape) {
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(scratch);
            if (type != 0) continue;
            return true;
        }
        return false;
    }

    public static Shape getMaximumOutline(Shape shape) {
        Area out = new Area();
        for (Shape s : ShapeUtil.getSubpaths(shape, null)) {
            out.add(new Area(s));
        }
        return out;
    }

    protected static double calculateLength(Shape shape, double flatness, int limit, double targetLength, double[] out) {
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), flatness, limit);
        double len = 0.0;
        double lastLen = 0.0;
        Point2D.Double lastPoint = new Point2D.Double();
        Point2D.Double endPoint = new Point2D.Double();
        Point2D.Double lastMoveTo = new Point2D.Double();
        double[] coords = new double[6];
        while (!it.isDone()) {
            lastLen = len;
            lastPoint.setLocation(endPoint);
            int op = it.currentSegment(coords);
            if (op == 0) {
                endPoint.setLocation(coords[0], coords[1]);
                lastMoveTo.setLocation(endPoint);
            } else if (op == 1) {
                len += Point2D.distance(endPoint.x, endPoint.y, coords[0], coords[1]);
                endPoint.setLocation(coords[0], coords[1]);
            } else if (op == 4) {
                len += Point2D.distance(endPoint.x, endPoint.y, lastMoveTo.x, lastMoveTo.y);
                endPoint.setLocation(lastMoveTo);
            }
            if (targetLength >= 0.0 && len > targetLength) {
                if (out != null) {
                    double currentSegLen = len - lastLen;
                    double segRatio = (targetLength - lastLen) / currentSegLen;
                    double xpos = lastPoint.x + segRatio * (endPoint.x - lastPoint.x);
                    double ypos = lastPoint.y + segRatio * (endPoint.y - lastPoint.y);
                    out[0] = xpos;
                    out[1] = ypos;
                    if (out.length > 2) {
                        out[2] = Math.atan2(endPoint.y - lastPoint.y, endPoint.x - lastPoint.x);
                    }
                }
                return targetLength;
            }
            it.next();
        }
        return len;
    }

    public static double getLength(Shape shape, double flatness, int limit) {
        return ShapeUtil.calculateLength(shape, flatness, limit, -1.0, null);
    }

    public static Point2D getPointAtRatio(Shape shape, double ratio, double flatness, int limit) {
        double[] arr = ShapeUtil.getPosAndAngleAtRatio(shape, ratio, flatness, limit);
        return new Point2D.Double(arr[0], arr[1]);
    }

    public static double[] getPosAndAngleAtRatio(Shape shape, double ratio, double flatness, int limit) {
        double[] out = new double[3];
        double length = ShapeUtil.calculateLength(shape, flatness, limit, -1.0, out);
        ShapeUtil.calculateLength(shape, flatness, limit, length * ratio, out);
        return out;
    }

    public static Collection<Line2D> getLines(FlatteningPathIterator it) {
        LinkedList<Line2D> out = new LinkedList<Line2D>();
        double[] coords = new double[2];
        double[] lastCoords = new double[2];
        double[] lastMove = new double[2];
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            if (type == 1) {
                out.add(new Line2D.Double(lastCoords[0], lastCoords[1], coords[0], coords[1]));
            } else if (type == 0) {
                lastMove[0] = coords[0];
                lastMove[1] = coords[1];
            } else if (type == 4) {
                out.add(new Line2D.Double(lastMove[0], lastMove[1], coords[0], coords[1]));
            }
            lastCoords[0] = coords[0];
            lastCoords[1] = coords[1];
        }
        return out;
    }

    public static int intersectLineLine(Line2D a, Line2D b, double[] intersect) {
        double a1x = a.getX1();
        double a1y = a.getY1();
        double a2x = a.getX2();
        double a2y = a.getY2();
        double b1x = b.getX1();
        double b1y = b.getY1();
        double b2x = b.getX2();
        double b2y = b.getY2();
        return ShapeUtil.intersectLineLine(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y, intersect);
    }

    public static double getAngle(Line2D line) {
        return Math.atan2(line.getY2() - line.getY1(), line.getX2() - line.getY2());
    }

    public static int intersectLineLine(double a1x, double a1y, double a2x, double a2y, double b1x, double b1y, double b2x, double b2y, double[] intersect) {
        double ua_t = (b2x - b1x) * (a1y - b1y) - (b2y - b1y) * (a1x - b1x);
        double ub_t = (a2x - a1x) * (a1y - b1y) - (a2y - a1y) * (a1x - b1x);
        double u_b = (b2y - b1y) * (a2x - a1x) - (b2x - b1x) * (a2y - a1y);
        if (u_b != 0.0) {
            double ua = ua_t / u_b;
            double ub = ub_t / u_b;
            if (0.0 <= ua && ua <= 1.0 && 0.0 <= ub && ub <= 1.0) {
                intersect[0] = a1x + ua * (a2x - a1x);
                intersect[1] = a1y + ua * (a2y - a1y);
                return 1;
            }
            return 0;
        }
        return ua_t == 0.0 || ub_t == 0.0 ? -1 : -2;
    }

    public static double[] getStartPointAndAngle(Shape shape) {
        double[] startCoords = new double[]{0.0, 0.0, 0.0};
        double[] endCoords = new double[]{0.0, 0.0};
        double[] coords = new double[6];
        PathIterator it = shape.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            it.next();
            if (type == 0) {
                startCoords[0] = coords[0];
                startCoords[1] = coords[1];
                continue;
            }
            if (type == 4) continue;
            endCoords[0] = coords[0];
            endCoords[1] = coords[1];
            break;
        }
        startCoords[2] = Math.atan2(endCoords[1] - startCoords[1], endCoords[0] - startCoords[0]);
        return startCoords;
    }

    public static Shape reverseShape(Shape shape, GeneralPath out) {
        if (out == null) {
            out = new GeneralPath();
        } else {
            out.reset();
        }
        out.append(new ReversePathIterator(shape.getPathIterator(null)), false);
        return out;
    }

    public static Shape extendShape(Shape shape, GeneralPath out, Point2D newStart, Point2D newEnd) {
        if (out == null) {
            out = new GeneralPath();
        } else {
            out.reset();
        }
        double[] coords = new double[6];
        double[] lastCoords = new double[2];
        double[] lastMove = new double[2];
        double outAngle = 0.0;
        PathIterator it = shape.getPathIterator(null);
        boolean firstOp = true;
        if (newStart != null) {
            lastMove[0] = newStart.getX();
            lastMove[1] = newStart.getY();
            out.moveTo((float)lastMove[0], (float)lastMove[1]);
        }
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            it.next();
            if (firstOp && newStart != null) {
                double[] start = ShapeUtil.getStartPointAndAngle(shape);
                double len = Point2D.distance(newStart.getX(), newStart.getY(), start[0], start[1]) / 2.0;
                double ctrlx = len * Math.sin(start[2]);
                double ctrly = len * Math.cos(start[2]);
                out.quadTo((float)ctrlx, (float)ctrly, (float)start[0], (float)start[1]);
                outAngle = start[2];
            }
            if (type == 0) {
                if (!firstOp || newStart == null) {
                    out.moveTo((float)coords[0], (float)coords[1]);
                }
                lastMove[0] = coords[0];
                lastMove[1] = coords[1];
                lastCoords[0] = coords[0];
                lastCoords[1] = coords[1];
            } else if (type == 4) {
                out.closePath();
                lastCoords[0] = lastMove[0];
                lastCoords[1] = lastMove[1];
            } else if (type == 1) {
                out.lineTo((float)coords[0], (float)coords[1]);
                outAngle = Math.atan2(coords[1] - lastCoords[1], coords[0] - lastCoords[0]);
                lastCoords[0] = coords[0];
                lastCoords[1] = coords[1];
            } else if (type == 3) {
                out.curveTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3], (float)coords[4], (float)coords[5]);
                lastCoords[0] = coords[4];
                lastCoords[1] = coords[5];
                outAngle = Math.atan2(coords[1] - lastCoords[1], coords[0] - lastCoords[0]);
            } else if (type == 2) {
                out.quadTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3]);
                lastCoords[0] = coords[2];
                lastCoords[1] = coords[3];
                outAngle = Math.atan2(coords[1] - lastCoords[1], coords[0] - lastCoords[0]);
            }
            firstOp = false;
        }
        if (newEnd != null) {
            double len = Point2D.distance(lastCoords[0], lastCoords[1], newEnd.getX(), newEnd.getY()) / 2.0;
            double ctrlx = len * Math.sin(outAngle);
            double ctrly = len * Math.cos(outAngle);
            out.quadTo((float)ctrlx, (float)ctrly, (float)newEnd.getX(), (float)newEnd.getY());
        }
        return out;
    }

    public static Collection<double[]> getPointsAndAnglesOfIntersection(Shape a, Shape b, double flatness, int limit, int maxPoints) {
        LinkedList<double[]> out = new LinkedList<double[]>();
        Collection<Line2D> shapeaLines = ShapeUtil.getLines(new FlatteningPathIterator(a.getPathIterator(null), flatness, limit));
        Collection<Line2D> shapebLines = ShapeUtil.getLines(new FlatteningPathIterator(a.getPathIterator(null), flatness, limit));
        double[] scratch = new double[2];
        for (Line2D linea : shapeaLines) {
            for (Line2D lineb : shapebLines) {
                int code = ShapeUtil.intersectLineLine(linea, lineb, scratch);
                if (code != -1) continue;
                double[] p = new double[]{scratch[0], scratch[1], ShapeUtil.getAngle(linea), ShapeUtil.getAngle(lineb)};
                out.add(p);
                if (maxPoints <= 0 || out.size() < maxPoints) continue;
                return out;
            }
        }
        return out;
    }

    public static Point2D normalize(Shape shape, GeneralPath out) {
        Rectangle2D b = shape.getBounds2D();
        out.reset();
        out.append(shape.getPathIterator(AffineTransform.getTranslateInstance(-b.getX(), -b.getY())), false);
        return new Point2D.Double(b.getX(), b.getY());
    }

    public static List getSubpaths(Shape shape, List out) {
        if (out == null) {
            out = new LinkedList<Shape>();
        }
        if (!ShapeUtil.hasSubpaths(shape)) {
            out.add(shape);
            return out;
        }
        Path2D currentPath = null;
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(scratch);
            if (type == 0) {
                if (currentPath != null) {
                    out.add(currentPath);
                }
                currentPath = new GeneralPath();
                ((Path2D.Float)currentPath).moveTo(scratch[0], scratch[1]);
            } else if (type == 4) {
                currentPath.closePath();
            } else if (type == 3) {
                ((Path2D.Float)currentPath).curveTo(scratch[0], scratch[1], scratch[2], scratch[3], scratch[4], scratch[5]);
            } else if (type == 1) {
                ((Path2D.Float)currentPath).lineTo(scratch[0], scratch[1]);
            } else if (type == 2) {
                ((Path2D.Float)currentPath).quadTo(scratch[0], scratch[1], scratch[2], scratch[3]);
            }
            iterator.next();
        }
        if (currentPath != null) {
            out.add(currentPath);
        }
        return out;
    }

    public static int getArrayUse(int op) {
        if (op == 4) {
            return 0;
        }
        if (op == 3) {
            return 6;
        }
        if (op == 1) {
            return 2;
        }
        if (op == 0) {
            return 2;
        }
        if (op == 2) {
            return 4;
        }
        return 0;
    }
}

