/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.bbop.util.StringUtil;

public class SwingUtil {
    protected static final Logger logger = Logger.getLogger(SwingUtil.class);
    public static int NONE = 0;
    public static int TOP = 1;
    public static int BOTTOM = 2;
    public static int LEFT = 4;
    public static int RIGHT = 8;

    protected SwingUtil() {
    }

    public static String getComboBoxValue(JComboBox comp) {
        String selectedPath = comp.getSelectedItem().toString();
        if (selectedPath == null || !selectedPath.equals(comp.getEditor().getItem())) {
            selectedPath = comp.getEditor().getItem().toString();
        }
        return selectedPath;
    }

    public static Component getShallowestAncestorOfClass(Class<?> c, Component comp) {
        if (comp == null || c == null) {
            return null;
        }
        Component match = null;
        for (Component parent = comp; parent != null; parent = parent.getParent()) {
            if (!c.isInstance(parent)) continue;
            match = parent;
        }
        return match;
    }

    public static void setPreferredWidth(JComponent component, int width) {
        component.setPreferredSize(new Dimension(width, component.getPreferredSize().height));
    }

    public static void setPreferredHeight(JComponent component, int height) {
        component.setPreferredSize(new Dimension(component.getPreferredSize().width, height));
    }

    public static String getHTMLFontStyle(Font font) {
        StringBuffer out = new StringBuffer();
        out.append("font-size: " + font.getSize() + "px; ");
        out.append("font-family: " + font.getSize() + "; ");
        if (font.isItalic()) {
            out.append("font-style: italic; ");
        }
        if (font.isBold()) {
            out.append("font-weight: bold; ");
        }
        return out.toString();
    }

    public static int withinInsets(Point p, Insets insets, Component c) {
        if (insets == null || p == null || c == null || !c.contains(p)) {
            return NONE;
        }
        int out = 0;
        if (p.x < insets.left) {
            out |= LEFT;
        } else if (p.x > c.getSize().width - insets.right) {
            out |= RIGHT;
        }
        if (p.y < insets.bottom) {
            out |= TOP;
        } else if (p.y > c.getSize().height - insets.top) {
            out |= BOTTOM;
        }
        return out;
    }

    public static void mapAction(JComponent c, int condition, KeyStroke keyStroke, Action action) {
        Object key = action.getValue("Name");
        if (key == null) {
            throw new IllegalArgumentException("The provided action must have a name defined");
        }
        SwingUtil.mapAction(c, condition, key, keyStroke, action);
    }

    public static void mapAction(JComponent c, int condition, Object key, KeyStroke keyStroke, Action action) {
        c.getActionMap().put(key, action);
        c.getInputMap(condition).put(keyStroke, key);
    }

    public static <T> T getAncestorOfClass(Class<T> c, Component comp) {
        Container parent;
        if (comp == null || c == null) {
            return null;
        }
        for (parent = comp.getParent(); parent != null && !c.isInstance(parent); parent = parent.getParent()) {
        }
        return (T)parent;
    }

    public static Container getParentOfClass(Class<?> c, Component comp) {
        if (comp == null || c == null) {
            return null;
        }
        Container parent = comp.getParent();
        while (parent != null && !c.isInstance(parent)) {
            logger.debug((Object)("parent: " + parent));
        }
        return parent;
    }

    public static Image getImage(Component c) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage bImage = gc.createCompatibleImage(c.getWidth(), c.getHeight(), 2);
        Graphics2D g = bImage.createGraphics();
        c.paint(g);
        return bImage;
    }

    public static void masterValidate(Component c) {
        JRootPane pane = SwingUtilities.getRootPane(c);
        if (pane != null) {
            pane.getContentPane().validate();
        }
    }

    public static boolean isVectorFont(Font font) {
        GlyphVector gv = font.createGlyphVector(new FontRenderContext(null, true, false), "Test");
        Shape fontShape = gv.getOutline();
        Rectangle2D bounds = fontShape.getBounds2D();
        return bounds.getWidth() != 0.0 || bounds.getHeight() != 0.0;
    }

    public static boolean isChildPath(TreePath child, TreePath parent) {
        Object[] childArr = child.getPath();
        Object[] parentArr = parent.getPath();
        if (childArr.length == 0 || childArr.length > parentArr.length) {
            return false;
        }
        for (int i = 0; i < childArr.length; ++i) {
            if (childArr[i].equals(parentArr[i])) continue;
            return false;
        }
        return true;
    }

    public static int getIndex(Container parent, Component child) {
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (!child.equals(parent.getComponent(i))) continue;
            return i;
        }
        return -1;
    }

    public static void printTreeModel(TreeModel model) {
        SwingUtil.printTreeModel(System.err, model);
    }

    public static void printTreeModel(PrintStream out, TreeModel model) {
        SwingUtil.printTreeModel(out, model.getRoot(), 0, model, new Hashtable());
    }

    private static void printTreeModel(PrintStream out, Object current, int depth, TreeModel model, Hashtable seen) {
        out.print(StringUtil.repeat(" ", depth));
        out.println(current);
        if (seen.containsKey(current)) {
            return;
        }
        seen.put(current, current);
        int count = model.getChildCount(current);
        for (int i = 0; i < count; ++i) {
            SwingUtil.printTreeModel(out, model.getChild(current, i), depth + 2, model, seen);
        }
    }

    public static Rectangle getTextRectangle(JLabel label) {
        Icon icon;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return null;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        paintViewInsets = label.getInsets(paintViewInsets);
        paintViewR.x = paintViewInsets.left;
        paintViewR.y = paintViewInsets.top;
        paintViewR.width = label.getWidth() - (paintViewInsets.left + paintViewInsets.right);
        paintViewR.height = label.getHeight() - (paintViewInsets.top + paintViewInsets.bottom);
        Graphics g = label.getGraphics();
        if (g == null) {
            return null;
        }
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label.getIconTextGap());
        return paintTextR;
    }

    public static void center(Window win) {
        Dimension screenSize = win.getToolkit().getScreenSize();
        Dimension windowSize = win.getSize();
        int x = (screenSize.width - windowSize.width) / 2;
        int y = (screenSize.height - windowSize.height) / 2;
        win.setLocation(x, y);
    }

    public static void center(Window relativeToMe, Window centerMe) {
        int x = relativeToMe.getX() + (relativeToMe.getWidth() - centerMe.getWidth()) / 2;
        int y = relativeToMe.getY() + (relativeToMe.getHeight() - centerMe.getHeight()) / 2;
        centerMe.setLocation(x, y);
    }

    public static ComponentUI getUI(JComponent component) {
        try {
            Method method = component.getClass().getMethod("getUI", new Class[0]);
            Object o = method.invoke((Object)component, new Object[0]);
            if (o instanceof ComponentUI) {
                return (ComponentUI)o;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void sizeToPreferred(JDialog dialog) {
        Dimension preferredSize = dialog.getContentPane().getPreferredSize();
        dialog.setSize(preferredSize);
    }

    public static void sizeToPreferred(Component comp) {
        Dimension preferredSize = comp.getPreferredSize();
        comp.setSize(preferredSize);
    }

    @Deprecated
    public static void blockUntilImagePrepared(Image in) {
        while (!Toolkit.getDefaultToolkit().prepareImage(in, -1, -1, null)) {
            Thread.currentThread();
            Thread.yield();
        }
    }

    public static void collapseTree(JTree tree, TreePath path) {
        HashSet<TreePath> pathSet = new HashSet<TreePath>();
        pathSet.add(path);
        Enumeration<TreePath> e = tree.getExpandedDescendants(path);
        while (e != null && e.hasMoreElements()) {
            for (TreePath currentPath = e.nextElement(); currentPath != null && path.isDescendant(currentPath) && currentPath.getPathCount() > 0; currentPath = currentPath.getParentPath()) {
                pathSet.add(currentPath);
            }
        }
        Vector paths = new Vector(pathSet);
        Comparator pathSorter = new Comparator(){

            public int compare(Object a, Object b) {
                TreePath ta = (TreePath)a;
                TreePath tb = (TreePath)b;
                if (ta.getPathCount() > tb.getPathCount()) {
                    return -1;
                }
                if (ta.getPathCount() < tb.getPathCount()) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(paths, pathSorter);
        for (int i = 0; i < paths.size(); ++i) {
            TreePath p = (TreePath)paths.elementAt(i);
            tree.collapsePath(p);
        }
    }

    public static void requestFocus(Component c) {
        Component parent = c;
        Component lastParent = null;
        do {
            lastParent = parent;
            parent = parent.getParent();
            if (!(c instanceof JTabbedPane)) continue;
            JTabbedPane pane = (JTabbedPane)parent;
            pane.setSelectedComponent(lastParent);
        } while (parent != null);
        c.requestFocus();
    }

    public static void collapseTree(JTree tree) {
        SwingUtil.collapseTree(tree, new TreePath(tree.getModel().getRoot()));
    }

    public static void expandTree(JTree tree) {
        SwingUtil.expandTree(tree, new TreePath(tree.getModel().getRoot()));
    }

    public static void expandTree(JTree tree, TreePath path) {
        SwingUtil.expandTree(tree, path, new Hashtable());
    }

    protected static void expandTree(JTree tree, TreePath path, Hashtable lookedAt) {
        Object node = path.getLastPathComponent();
        if (lookedAt.containsKey(node)) {
            return;
        }
        lookedAt.put(node, node);
        Vector paths = new Vector();
        tree.makeVisible(path);
        int childCount = tree.getModel().getChildCount(node);
        for (int i = 0; i < childCount; ++i) {
            Object child = tree.getModel().getChild(node, i);
            TreePath p = path.pathByAddingChild(child);
            SwingUtil.expandTree(tree, p, lookedAt);
        }
    }

    public static boolean existsInModel(TreeModel model, TreePath path) {
        Object[] objects = path.getPath();
        if (!objects[0].equals(model.getRoot())) {
            return false;
        }
        Object prev = objects[0];
        for (int i = 1; i < objects.length; ++i) {
            if (model.getIndexOfChild(prev, objects[i]) < 0) {
                return false;
            }
            prev = objects[i];
        }
        return true;
    }

    public static String imageObserverInfoflagToString(int infoflag) {
        String out = "";
        if ((infoflag & 0x80) == 128) {
            out = out + "ABORT ";
        }
        if ((infoflag & 0x20) == 32) {
            out = out + "ALLBITS ";
        }
        if ((infoflag & 0x40) == 64) {
            out = out + "ERROR ";
        }
        if ((infoflag & 0x10) == 16) {
            out = out + "FRAMEBITS ";
        }
        if ((infoflag & 2) == 2) {
            out = out + "HEIGHT ";
        }
        if ((infoflag & 4) == 4) {
            out = out + "PROPERTIES ";
        }
        if ((infoflag & 8) == 8) {
            out = out + "SOMEBITS ";
        }
        if ((infoflag & 1) == 1) {
            out = out + "WIDTH ";
        }
        return out;
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static <T> T getDescendantOfType(Component c, Class<T> type) {
        if (type.isAssignableFrom(c.getClass())) {
            return (T)c;
        }
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                T out = SwingUtil.getDescendantOfType(child, type);
                if (out == null) continue;
                return out;
            }
        }
        return null;
    }

    public static Component getDescendantWithName(Component c, String name) {
        if (c.getName() != null && c.getName().equals(name)) {
            return c;
        }
        if (c instanceof Container) {
            for (int i = 0; i < ((Container)c).getComponentCount(); ++i) {
                Component out = SwingUtil.getDescendantWithName(((Container)c).getComponent(i), name);
                if (out == null) continue;
                return out;
            }
            return null;
        }
        return null;
    }

    public static Collection getAllDescendants(Container c, Class findClass) {
        return SwingUtil.getAllDescendants(c, findClass, false);
    }

    public static Collection getAllDescendants(Container c, Class findClass, boolean deep) {
        LinkedList results = new LinkedList();
        SwingUtil.fillAllDescendants(c, findClass, deep, results);
        return results;
    }

    protected static void fillAllDescendants(Container c, Class findClass, boolean deep, Collection results) {
        if (findClass.isInstance(c)) {
            results.add(c);
            if (!deep) {
                return;
            }
        }
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component comp = c.getComponent(i);
            if (!(comp instanceof Container)) continue;
            SwingUtil.fillAllDescendants((Container)comp, findClass, deep, results);
        }
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, SwingUtil.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = SwingUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, SwingUtil.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = SwingUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    public static List getListData(JList jlist) {
        ArrayList out = new ArrayList();
        ListModel model = jlist.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            out.add(model.getElementAt(i));
        }
        return out;
    }

    public static Cursor buildCursorByTrimming(Image image, String name, Cursor defaultCursor) {
        return SwingUtil.buildCursorByTrimming(image, 0, 0, name, defaultCursor);
    }

    public static Cursor buildCursorByTrimming(Image image, int x, int y, String name, Cursor defaultCursor) {
        return SwingUtil.buildCursorByTrimming(Toolkit.getDefaultToolkit(), image, x, y, name, defaultCursor);
    }

    public static Cursor buildCursorByTrimming(Toolkit toolkit, Image image, int x, int y, String name, Cursor defaultCursor) {
        Dimension d = toolkit.getBestCursorSize(image.getWidth(null), image.getHeight(null));
        if (d == null || d.getWidth() <= 0.0 || d.getHeight() <= 0.0) {
            return defaultCursor;
        }
        BufferedImage out = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
        out.getGraphics().drawImage(image, 0, 0, null);
        return toolkit.createCustomCursor(out, new Point(x, y), name);
    }

    public static boolean isLeftMouseButton(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return false;
        }
        return SwingUtilities.isLeftMouseButton(e);
    }
}

