/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.bbop.swing.BackgroundEventQueue;
import org.bbop.swing.ProgressBarUpdateRunnable;
import org.bbop.util.TaskDelegate;

public class TaskPanel
extends JPanel {
    protected static final Logger logger = Logger.getLogger(TaskPanel.class);
    protected static final String CONTENT_KEY = "CONTENT";
    protected static final String PROGRESS_KEY = "PROGRESS";
    protected JPanel contentPanel = new JPanel();
    protected JPanel progressPanel = new JPanel();
    protected JLabel progressLabel = new JLabel();
    protected JProgressBar progressBar = new JProgressBar();
    protected BackgroundEventQueue queue = new BackgroundEventQueue();
    protected CardLayout layout = new CardLayout();

    public TaskPanel() {
        super.setLayout(this.layout);
        super.add((Component)this.contentPanel, CONTENT_KEY);
        super.add((Component)this.progressPanel, PROGRESS_KEY);
        this.progressBar.setStringPainted(true);
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
        this.progressPanel.add(Box.createVerticalGlue());
        this.progressPanel.add(this.progressLabel);
        this.progressPanel.add(this.progressBar);
        this.progressPanel.add(Box.createVerticalGlue());
        this.queue.addStartupNotifier(new ProgressBarUpdateRunnable(this.queue, this.progressBar){

            @Override
            protected void cleanupUpdate() {
                TaskPanel.this.setProgressVisible(false);
            }
        });
    }

    public void schedule(TaskDelegate<?> task, boolean exclusive) {
        this.setProgressVisible(true);
        if (exclusive) {
            this.queue.cancelAll();
        }
        this.queue.scheduleTask(task);
    }

    protected void setProgressVisible(boolean visible) {
        if (visible) {
            this.progressLabel.setText("");
            this.progressBar.setValue(0);
            this.progressBar.setString("");
            this.layout.show(this, PROGRESS_KEY);
        } else {
            this.layout.show(this, CONTENT_KEY);
        }
        this.repaint();
        this.validate();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.contentPanel != null) {
            this.contentPanel.setOpaque(isOpaque);
        }
        if (this.progressPanel != null) {
            this.progressPanel.setOpaque(isOpaque);
        }
    }

    @Override
    public Component add(Component comp) {
        return this.contentPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.contentPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.contentPanel.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.contentPanel.add(comp, constraints, index);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.contentPanel.add(name, comp);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.contentPanel != null) {
            this.contentPanel.setLayout(mgr);
        }
    }

    @Override
    public void remove(Component comp) {
        this.contentPanel.remove(comp);
    }

    @Override
    public void remove(int index) {
        this.contentPanel.remove(index);
    }

    @Override
    public void removeAll() {
        this.contentPanel.removeAll();
    }
}

